/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimerTask;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.plugin.cache.HistoryMessageRedisCacheUtil;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteHistoryMsgTimerTask
extends TimerTask {
    private static final Logger Log = LoggerFactory.getLogger(DeleteHistoryMsgTimerTask.class);

    @Override
    public void run() {
        int historyMsg = JiveGlobals.getIntProperty((String)"optimize.msg.history.expire.day", (int)0);
        if (historyMsg == 0) {
            Log.info("optimize.msg.history.expire.day is null or 0 ,not need to delete historyMsg");
            return;
        }
        if (historyMsg < 7) {
            Log.warn("optimize.msg.history.expire.day is less than 7 days,not need to delete historyMsg historyMsg:{}", (Object)historyMsg);
        }
        if (HistoryMessageRedisCacheUtil.getInstance() != null) {
            HistoryMessageRedisCacheUtil.stop();
        }
        String dayAfter = DeleteHistoryMsgTimerTask.getDayAfter(historyMsg);
        if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
            Log.info("delete historyMsg for oracle start . dayAfter : {} ", (Object)dayAfter);
            this.deleteHistoryMsgForOracle(dayAfter);
            Log.info("db is oracle and now start delete old data for socialhistorymsgright.");
            this.deleteSocialHistoryMsgRightForOracle(dayAfter);
            Log.info("db is oracle and now start delete old data for socialimmsgread.");
            this.deleteSocialImMsgReadForOracle(dayAfter);
            Log.info("delete historyMsg for oracle end . dayAfter : {} ", (Object)dayAfter);
            this.deleteSocial_HistoryRight(dayAfter);
            this.deleteSocial_IMConversation(dayAfter);
            this.deleteSocial_IMRecentConver(dayAfter);
            this.deleteHistoryMsgRecently(dayAfter);
        } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
            Log.info("delete historyMsg for mysql start . dayAfter  : {} ", (Object)dayAfter);
            this.deleteHistoryMsgForMySQL(dayAfter);
            Log.info("db is mysql and now start delete old data for socialhistorymsgright.");
            this.deleteSocialHistoryMsgRightForMySQL(dayAfter);
            Log.info("db is mysql and now start delete old data for socialimmsgread.");
            this.deleteSocialImMsgReadForMySQL(dayAfter);
            Log.info("delete historyMsg for mysql end . dayAfter : {} ", (Object)dayAfter);
            this.deleteSocial_HistoryRight(dayAfter);
            this.deleteSocial_IMConversation(dayAfter);
            this.deleteSocial_IMRecentConver(dayAfter);
            this.deleteHistoryMsgRecently(dayAfter);
        } else {
            Log.info("delete historyMsg for sqlserver start . dayAfter = {} ", (Object)dayAfter);
            this.deleteHistoryMsgForSqlServer(dayAfter);
            Log.info("db is sqlserver and now start delete old data for socialhistorymsgright.");
            this.deleteSocialHistoryMsgRightForSqlServer(dayAfter);
            Log.info("db is sqlserver and now start delete old data for socialimmsgread.");
            this.deleteSocialImMsgReadForSqlServer(dayAfter);
            Log.info("delete historyMsg for sqlserver end . dayAfter = {} ", (Object)dayAfter);
            this.deleteSocial_HistoryRight(dayAfter);
            this.deleteSocial_IMConversation(dayAfter);
            this.deleteSocial_IMRecentConver(dayAfter);
            this.deleteHistoryMsgRecently(dayAfter);
        }
        Log.info("deleteHistoryMsg success ,dayAfter={}", (Object)dayAfter);
        if (HistoryMessageRedisCacheUtil.getInstance() != null) {
            HistoryMessageRedisCacheUtil.reStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteHistoryMsgRecently(String dayAfter) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "delete from HistoryMsgRecently where dateTime < ? and rownum < 1000";
            if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sql = "delete from HistoryMsgRecently where dateTime < ? LIMIT 1000";
            }
            if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
                sql = " delete top(1000) from HistoryMsgRecently where dateTime < ? ";
            }
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sql);
            pstmt.setString(1, dayAfter);
            int deleteNum = pstmt.executeUpdate();
            while (deleteNum > 0) {
                deleteNum = pstmt.executeUpdate();
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        catch (Exception e) {
            Log.error("deleteSocial_HistoryRight error :{} ,e :{} ", (Object)e.getMessage(), (Object)e);
        }
        finally {
            DbConnectionManager.closeConnection(pstmt, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSocial_IMRecentConver(String dayAfter) {
        long timeStamp;
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            timeStamp = this.getDayAfterStamp(dayAfter);
        }
        catch (ParseException e1) {
            return;
        }
        try {
            String sql = "delete from social_IMRecentConver where lasttime < ? and rownum < 1000";
            if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sql = "delete from Social_IMRecentConver where lasttime < ? LIMIT 1000";
            }
            if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
                sql = " delete top(1000) from Social_IMRecentConver where lasttime < ? ";
            }
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sql);
            pstmt.setString(1, String.valueOf(timeStamp));
            int deleteNum = pstmt.executeUpdate();
            while (deleteNum > 0) {
                deleteNum = pstmt.executeUpdate();
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        catch (Exception e) {
            Log.error("deleteSocial_IMConversation error :{} ,e :{} ", (Object)e.getMessage(), (Object)e);
        }
        finally {
            DbConnectionManager.closeConnection(pstmt, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSocial_IMConversation(String dayAfter) {
        long timeStamp;
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            timeStamp = this.getDayAfterStamp(dayAfter);
        }
        catch (ParseException e1) {
            return;
        }
        try {
            String sql = "delete from Social_IMConversation where lasttime < ? and rownum < 1000";
            if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sql = "delete from Social_IMConversation where lasttime < ? LIMIT 1000";
            }
            if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
                sql = " delete top(1000) from Social_IMConversation where lasttime < ? ";
            }
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sql);
            pstmt.setString(1, String.valueOf(timeStamp));
            int deleteNum = pstmt.executeUpdate();
            while (deleteNum > 0) {
                deleteNum = pstmt.executeUpdate();
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        catch (Exception e) {
            Log.error("deleteSocial_IMConversation error :{} ,e :{} ", (Object)e.getMessage(), (Object)e);
        }
        finally {
            DbConnectionManager.closeConnection(pstmt, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSocial_HistoryRight(String dayAfter) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "delete from Social_historyMsgRecentlyRight where dateTime < ? and rownum < 1000";
            if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sql = "delete from Social_historyMsgRecentlyRight where dateTime < ? LIMIT 1000";
            }
            if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
                sql = " delete top(1000) from Social_historyMsgRecentlyRight where dateTime < ? ";
            }
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sql);
            pstmt.setString(1, dayAfter);
            int deleteNum = pstmt.executeUpdate();
            while (deleteNum > 0) {
                deleteNum = pstmt.executeUpdate();
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        catch (Exception e) {
            Log.error("deleteSocial_HistoryRight error :{} ,e :{} ", (Object)e.getMessage(), (Object)e);
        }
        finally {
            DbConnectionManager.closeConnection(pstmt, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void socialHistoryMsgRightClean() {
        int pageSize = Integer.valueOf(JiveGlobals.getProperty((String)"task.clean.historymsgright.pageSize", (String)"1000"));
        Long startTime = System.currentTimeMillis();
        Log.info("SocialHistoryMsgRightCleanTimerTask running.");
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList list = new ArrayList();
        String sql = this.getSql(pageSize);
        try {
            int deleteNum;
            do {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(sql);
                deleteNum = pstmt.executeUpdate();
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                Log.info("SocialHistoryMsgRightCleanTimerTask, has successfully deleted {} rows of duplicated records from social_historymsgright", (Object)deleteNum);
            } while (0 < deleteNum && deleteNum <= pageSize);
            Log.info("SocialHistoryMsgRightCleanTimerTask, end");
        }
        catch (Exception e) {
            Log.error("SocialHistoryMsgRightCleanTimerTask, executed sql is ======:{},and Error is:{} ", (Object)sql, (Object)e.getMessage());
        }
        finally {
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        Log.info("SocialHistoryMsgRightCleanTimerTask end. cost time: {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void socialHistoryMsgRightDeduplication() {
        int pageSize = Integer.valueOf(JiveGlobals.getProperty((String)"task.deduplication.historymsgright.pageSize", (String)"200"));
        Long startTime = System.currentTimeMillis();
        Log.info("SocialHistoryMsgRightDeduplicationTimerTask running.");
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList list = new ArrayList();
        String sql = this.getSqlForDeduplication(pageSize);
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sql);
            int deleteNum = pstmt.executeUpdate();
            if (0 < deleteNum) {
                Log.info("SocialHistoryMsgRightDeduplicationTimerTask, has successfully deleted {} rows of duplicated records from social_historymsgright", (Object)deleteNum);
            }
        }
        catch (Exception e) {
            Log.error("SocialHistoryMsgRightDeduplicationTimerTask, executed sql is ======:{},and Error is:{} ", (Object)sql, (Object)e.getMessage());
        }
        finally {
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        Log.info("SocialHistoryMsgRightDeduplicationTimerTask end. cost time: {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSocialImMsgReadForSqlServer(String dayAfter) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            int historyMsgDeleteCount;
            do {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(" delete top(1000) from social_IMMsgRead where sendtime < ? ");
                pstmt.setString(1, dayAfter);
                historyMsgDeleteCount = pstmt.executeUpdate();
                Log.info("delete deleteSocialImMsgReadForSqlServer Count={}", (Object)historyMsgDeleteCount);
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            } while (historyMsgDeleteCount > 0);
        }
        catch (SQLException e) {
            try {
                Log.error("delete deleteSocialImMsgReadForSqlServer error={}", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSocialImMsgReadForMySQL(String dayAfter) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            int historyMsgDeleteCount;
            do {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("  delete from social_IMMsgRead where sendtime < ? LIMIT 1000 ");
                pstmt.setString(1, dayAfter);
                historyMsgDeleteCount = pstmt.executeUpdate();
                Log.info("delete deleteSocialImMsgReadForMySQL count : {} ", (Object)historyMsgDeleteCount);
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            } while (historyMsgDeleteCount > 0);
        }
        catch (SQLException e) {
            try {
                Log.error("delete deleteSocialImMsgReadForMySQL dayAfter : {} ,error : {} ", (Object)dayAfter, (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSocialImMsgReadForOracle(String dayAfter) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            int historyMsgDeleteCount;
            do {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("delete from social_IMMsgRead where sendtime < ? and rownum < 1000");
                pstmt.setString(1, dayAfter);
                historyMsgDeleteCount = pstmt.executeUpdate();
                Log.info("delete deleteSocialImMsgReadForOracle Count={}", (Object)historyMsgDeleteCount);
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            } while (historyMsgDeleteCount > 0);
        }
        catch (SQLException e) {
            try {
                Log.error("delete deleteSocialImMsgReadForOracle error={}", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSocialHistoryMsgRightForSqlServer(String dayAfter) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            int historyMsgDeleteCount;
            do {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(" delete top(1000) from social_historymsgright where dateTime < ? ");
                pstmt.setString(1, dayAfter);
                historyMsgDeleteCount = pstmt.executeUpdate();
                Log.info("delete deleteSocialHistoryMsgRightForSqlServer Count={}", (Object)historyMsgDeleteCount);
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            } while (historyMsgDeleteCount > 0);
        }
        catch (SQLException e) {
            try {
                Log.error("delete deleteSocialHistoryMsgRightForSqlServer error={}", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSocialHistoryMsgRightForMySQL(String dayAfter) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            int historyMsgDeleteCount;
            do {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("delete from social_historymsgright where dateTime < ? LIMIT 1000");
                pstmt.setString(1, dayAfter);
                historyMsgDeleteCount = pstmt.executeUpdate();
                Log.info("delete deleteSocialHistoryMsgRightForMySQL count : {} ", (Object)historyMsgDeleteCount);
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            } while (historyMsgDeleteCount > 0);
        }
        catch (SQLException e) {
            try {
                Log.error("delete deleteSocialHistoryMsgRightForMySQL dayAfter : {} ,error : {} ", (Object)dayAfter, (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSocialHistoryMsgRightForOracle(String dayAfter) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            int historyMsgDeleteCount;
            do {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("delete from social_historymsgright where dateTime < ? and rownum < 1000");
                pstmt.setString(1, dayAfter);
                historyMsgDeleteCount = pstmt.executeUpdate();
                Log.info("delete deleteSocialHistoryMsgRightForOracle Count={}", (Object)historyMsgDeleteCount);
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            } while (historyMsgDeleteCount > 0);
        }
        catch (SQLException e) {
            try {
                Log.error("delete deleteSocialHistoryMsgRightForOracle error={}", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteHistoryMsgForMySQL(String dayAfter) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            int historyMsgRecentlyDeleteCount;
            int historyMsgDeleteCount;
            do {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("delete from historyMsg where dateTime < ? LIMIT 1000");
                pstmt.setString(1, dayAfter);
                historyMsgDeleteCount = pstmt.executeUpdate();
                Log.info("delete historyMsg for Mysql count : {}", (Object)historyMsgDeleteCount);
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            } while (historyMsgDeleteCount > 0);
            do {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("delete from HistoryMsgRecently where dateTime < ? LIMIT 1000");
                pstmt.setString(1, dayAfter);
                historyMsgRecentlyDeleteCount = pstmt.executeUpdate();
                Log.info("delete historyMsgRecentlyDeleteCount : {}", (Object)historyMsgDeleteCount);
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            } while (historyMsgRecentlyDeleteCount > 0);
        }
        catch (SQLException e) {
            try {
                Log.error("delete historyMsgForMySQL dayAfter : {} ,error : {} ", (Object)dayAfter, (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteHistoryMsgForOracle(String dayAfter) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            int historyMsgRecentlyDeleteCount;
            int historyMsgDeleteCount;
            do {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("delete from historyMsg where dateTime < ? and rownum < 1000");
                pstmt.setString(1, dayAfter);
                historyMsgDeleteCount = pstmt.executeUpdate();
                Log.info("delete deleteHistoryMsgForOracle Count={}", (Object)historyMsgDeleteCount);
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            } while (historyMsgDeleteCount > 0);
            Log.info("now start delete historyMsgRecently .dayAfter:{}", (Object)dayAfter);
            do {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("delete from HistoryMsgRecently where dateTime < ? and rowNum < 1000");
                pstmt.setString(1, dayAfter);
                historyMsgRecentlyDeleteCount = pstmt.executeUpdate();
                Log.info("delete deleteHistoryMsgForOracle Count={}", (Object)historyMsgDeleteCount);
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            } while (historyMsgRecentlyDeleteCount > 0);
            Log.info("delete historyMsgRecentlyDeleteCount count :{} ", (Object)historyMsgRecentlyDeleteCount);
        }
        catch (SQLException e) {
            try {
                Log.error("delete deleteHistoryMsgForOracle error={}", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteHistoryMsgForSqlServer(String dayAfter) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            int historyMsgRecentlyDeleteCount;
            int historyMsgDeleteCount;
            do {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(" delete top(1000) from historyMsg where dateTime < ? ");
                pstmt.setString(1, dayAfter);
                historyMsgDeleteCount = pstmt.executeUpdate();
                Log.info("delete HistoryMsg ForSqlServer Count={}", (Object)historyMsgDeleteCount);
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            } while (historyMsgDeleteCount > 0);
            do {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("  delete top(1000) from HistoryMsgRecently where dateTime < ?  ");
                pstmt.setString(1, dayAfter);
                historyMsgRecentlyDeleteCount = pstmt.executeUpdate();
                Log.info("historyMsgRecentlyDeleteCount : {} ", (Object)historyMsgRecentlyDeleteCount);
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            } while (historyMsgRecentlyDeleteCount > 0);
            Log.info("historyMsgRecentlyDeleteCount : {} ", (Object)historyMsgRecentlyDeleteCount);
        }
        catch (SQLException e) {
            try {
                Log.error("delete deleteHistoryMsgForSqlServer error={}", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    public static void main(String[] args) {
        System.out.println(DeleteHistoryMsgTimerTask.getDayAfter(40));
    }

    private static String getDayAfter(int retainHistoryMsgDay) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        int day = c.get(5);
        c.set(5, day - retainHistoryMsgDay);
        return new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
    }

    private long getDayAfterStamp(String dayAfter) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = simpleDateFormat.parse(dayAfter);
        long ts = date.getTime();
        return ts;
    }

    private long getNoSenderMsgDate(int retainHistoryMsgDay) {
        return System.currentTimeMillis() - (long)(retainHistoryMsgDay * 24 * 60 * 60) * 1000L;
    }

    public void destoryCache() {
    }

    private String getSql(int pageSize) {
        String sql = "delete top (" + pageSize + ") from Social_historyMsgRight where msgid not in (select msgid from historymsg)";
        if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
            sql = "delete\u00a0from\u00a0Social_Historymsgright\u00a0where\u00a0msgid\u00a0not\u00a0in(\u00a0select\u00a0msgid\u00a0from\u00a0historyMsg\u00a0)\u00a0and\u00a0rowNum\u00a0<=" + pageSize;
        } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
            sql = "delete from social_historymsgright where msgid not in (select msgid from historymsg) limit " + pageSize;
        }
        return sql;
    }

    private String getSqlForDeduplication(int pageSize) {
        String sql = "delete from social_historymsgright where id in (select top " + pageSize + " max(id) as id from social_historymsgright group by userId,msgId having count(*) > 1)";
        if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
            sql = "delete from social_historymsgright where id in (select id from (select A.*, rownum rn from (select max(id) as id from social_historymsgright group by userId,msgId having count(*) > 1) A where rownum <= " + pageSize + ") where rn >= 1) ";
        } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
            sql = "delete from social_historymsgright where id in (select max(id) as id from social_historymsgright group by userId,msgId having count(*) > 1 limit " + pageSize + ")";
        }
        return sql;
    }
}

