/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimerTask;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.plugin.bean.RecentlyLasttime;
import org.jivesoftware.openfire.plugin.cache.HistoryMessageRedisCacheUtil;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteOldRecentlyTimerTask
extends TimerTask {
    private static final Logger Log = LoggerFactory.getLogger(DeleteOldRecentlyTimerTask.class);
    private static final String DELETE_HISTORYMSGRECENTLY = "DELETE FROM  HistoryMsgRecently where groupid = ? and datetime < ?";
    private static SimpleDateFormat SDF_SIMPLE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat SDF_ALL = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Log.info("start DeleteOldRecentlyTimerTask ...");
        this.deleteOfSecurityAuditLog(new Date().getTime() - (long)(JiveGlobals.getIntProperty((String)"auditlog.keep.days", (int)7) * 24 * 60 * 60 * 1000));
        this.deleteOfPushLog(new Date().getTime() - (long)(JiveGlobals.getIntProperty((String)"auditlog.keep.days", (int)7) * 24 * 60 * 60 * 1000));
        Long startTime = System.currentTimeMillis();
        if (HistoryMessageRedisCacheUtil.getInstance() != null) {
            HistoryMessageRedisCacheUtil.stop();
        }
        try {
            this.saveMessageToHistoryMsgRecentlyTemp();
            int deleteCount = this.getHistoryMsgRecentlyCount();
            Log.info("DeleteOldRecentlyTimerTask,needDeleteCount :{} ", (Object)deleteCount);
            if (deleteCount == 0) {
                Log.info("DeleteOldRecentlyTimerTask ,no date need to delete. ");
            } else {
                if (deleteCount <= 100) {
                    List<RecentlyLasttime> list = this.getRecentlyLastTime();
                    this.deleteOldRecently(list);
                } else {
                    int num = deleteCount / 100;
                    for (int i = 0; i <= num; ++i) {
                        if (!this.isNeedBreakTimerTask()) {
                            Log.info("DeleteOldRecentlyTimerTask,time > 6,stop delete.");
                            break;
                        }
                        List<RecentlyLasttime> list = this.getRecentlyLastTimeByPage(100, i + 1);
                        this.deleteOldRecently(list);
                    }
                }
                this.turncateTableHistoryMsgRecently();
            }
        }
        catch (Exception e) {
            Log.error("DeleteOldRecentlyTimerTask error :{} ", (Throwable)e);
        }
        finally {
            if (HistoryMessageRedisCacheUtil.getInstance() != null) {
                HistoryMessageRedisCacheUtil.reStart();
            }
        }
        Log.info("done DeleteOldRecentlyTimerTask ok, remove delete flag,cast time:{} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private boolean isNeedBreakTimerTask() {
        Date date = new Date();
        int hours = date.getHours();
        boolean allTimeWork = JiveGlobals.getBooleanProperty((String)"historymsgupdatetimertaskalltime", (boolean)false);
        if (allTimeWork) {
            Log.info("DeleteOldRecentlyTimerTask,isNeedBreakTimerTask,allTimeWork:{}", (Object)allTimeWork);
            return true;
        }
        if (hours >= 6) {
            Log.info("DeleteOldRecentlyTimerTask,isNeedBreakTimerTask,hours >= 6:{}", (Object)hours);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turncateTableHistoryMsgRecently() {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" truncate table historyMsgRecentlytemp ");
            pstmt.execute();
        }
        catch (Exception e) {
            try {
                Log.error("turncateTableHistoryMsgRecently ,error :{} ,e :{} ", (Object)e.getMessage(), (Object)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RecentlyLasttime> getRecentlyLastTimeByPage(int pageSize, int pageNumber) {
        Log.info("getRecentlyLastTimeByPage,pageSize :{},pageNumber:{}", (Object)pageSize, (Object)pageNumber);
        ArrayList<RecentlyLasttime> result = new ArrayList<RecentlyLasttime>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(this.getSQL(pageSize, pageNumber));
            rs = pstmt.executeQuery();
            while (rs.next()) {
                RecentlyLasttime r = new RecentlyLasttime();
                String groupId = rs.getString("groupId");
                String maxDatetime = rs.getString("maxDatetime");
                if (groupId == null || groupId.isEmpty() || maxDatetime == null || maxDatetime.isEmpty()) continue;
                r.setGroupid(groupId);
                r.setLasttime(maxDatetime);
                result.add(r);
            }
        }
        catch (Exception e) {
            try {
                Log.error("getRecentlyLastTimeByPage ,error :{} ,e :{} ", (Object)e.getMessage(), (Object)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return result;
    }

    private String getSQL(int pageSize, int pageNumber) {
        String sql = " select groupId,maxDatetime from historyMsgRecentlytemp order by maxDatetime desc ";
        if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
            sql = "select ROW_NUMBER() OVER(ORDER BY maxDatetime DESC) AS rn,groupId,maxDatetime from historyMsgRecentlytemp  ";
        } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.dm.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.st.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
            sql = " select groupId,maxDatetime from historyMsgRecentlytemp order by maxDatetime desc ";
        }
        String sqlByPage = "";
        if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
            sqlByPage = "SELECT * FROM (" + sql + ") AS pageTable WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
        } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
            sqlByPage = "SELECT * FROM (SELECT rownum as rn, pageTable.* FROM (" + sql + ")pageTable) WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
        } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
            sqlByPage = sql + " LIMIT " + (pageNumber - 1) * pageSize + "," + pageSize;
        } else if (DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
            sqlByPage = sql + " LIMIT " + pageSize + " offset " + (pageNumber - 1) * pageSize;
        }
        return sqlByPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getHistoryMsgRecentlyCount() {
        int result = 0;
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" select count(1) as hmrtCount from historyMsgRecentlytemp ");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                result = rs.getInt("hmrtCount");
            }
        }
        catch (Exception e) {
            try {
                Log.error("getHistoryMsgRecentlyCount error :{} ,e :{} ", (Object)e.getMessage(), (Object)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMessageToHistoryMsgRecentlyTemp() {
        String sql = "";
        sql = DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) ? " insert into historyMsgRecentlytemp select groupid,max(datetime) as maxDatetime,min(datetime) as minDatetime  from  HistoryMsgRecently group by groupid having  datediff ( max(datetime) ,min(datetime) ) > 7 " : (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType()) ? " insert into historyMsgRecentlytemp select groupid,max(datetime) as maxDatetime,min(datetime) as minDatetime  from  HistoryMsgRecently group by groupid having  datediff ( day,min(datetime) ,max(datetime) ) > 7 " : " insert into historyMsgRecentlytemp select groupid,max(datetime) as maxDatetime,min(datetime) as minDatetime  from  HistoryMsgRecently group by groupid having to_date(substr(max(datetime) ,1,10),'yyyy-mm-dd') - to_date(substr(min(datetime) ,1,10),'yyyy-mm-dd') > 7 ");
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sql);
            pstmt.execute();
        }
        catch (Exception e) {
            try {
                Log.error("saveMessageToHistoryMsgRecentlyTemp ,error :{} ,e :{} ", (Object)e.getMessage(), (Object)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOfSecurityAuditLog(long time) {
        Log.info("deleteSecurityAuditLog time : {} ", (Object)time);
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" delete from ofSecurityAuditLog where entryStamp < ? and username != 'admin'");
            pstmt.setLong(1, time);
            int deleteNum = pstmt.executeUpdate();
            while (deleteNum > 0) {
                Log.info("deleteSecurityAuditLog,deleteNum : {} ", (Object)deleteNum);
                deleteNum = pstmt.executeUpdate();
            }
        }
        catch (Exception e) {
            try {
                Log.error("deleteSecurityAuditLog error : {} ", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOfPushLog(long time) {
        Log.info("deleteOfPushLog time : {} ", (Object)time);
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" delete from ofpushlog where entryStamp < ? ");
            pstmt.setLong(1, time);
            int deleteNum = pstmt.executeUpdate();
            while (deleteNum > 0) {
                Log.info("deleteOfPushLog,deleteNum : {} ", (Object)deleteNum);
                deleteNum = pstmt.executeUpdate();
            }
        }
        catch (Exception e) {
            try {
                Log.error("deleteOfPushLog error : {} ", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RecentlyLasttime> getRecentlyLastTime() {
        ArrayList<RecentlyLasttime> result = new ArrayList<RecentlyLasttime>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" select groupId,maxDatetime from historyMsgRecentlytemp ");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                RecentlyLasttime r = new RecentlyLasttime();
                String groupId = rs.getString("groupId");
                String maxDatetime = rs.getString("maxDatetime");
                if (groupId == null || groupId.isEmpty() || maxDatetime == null || maxDatetime.isEmpty()) continue;
                r.setGroupid(groupId);
                r.setLasttime(maxDatetime);
                result.add(r);
            }
        }
        catch (Exception e) {
            try {
                Log.error("getRecentlyLastTime ,error :{} ,e :{} ", (Object)e.getMessage(), (Object)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void deleteOldRecently(List<RecentlyLasttime> list) {
        if (list != null) {
            Connection con = null;
            PreparedStatement pstmt = null;
            try {
                String dayAfter;
                int day;
                Calendar c;
                Date date;
                String maxLasttime;
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(DELETE_HISTORYMSGRECENTLY);
                for (RecentlyLasttime lasttime : list) {
                    maxLasttime = lasttime.getLasttime();
                    date = null;
                    date = maxLasttime.indexOf(".") != -1 ? SDF_ALL.parse(maxLasttime) : SDF_SIMPLE.parse(maxLasttime);
                    c = Calendar.getInstance();
                    c.setTime(date);
                    day = c.get(5);
                    c.set(5, day - 6);
                    dayAfter = new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
                    pstmt.setString(1, lasttime.getGroupid());
                    pstmt.setString(2, dayAfter);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                pstmt.clearBatch();
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(" DELETE FROM  Social_historyMsgRecentlyRight where groupid = ? and datetime < ? ");
                for (RecentlyLasttime lasttime : list) {
                    maxLasttime = lasttime.getLasttime();
                    date = null;
                    date = maxLasttime.indexOf(".") != -1 ? SDF_ALL.parse(maxLasttime) : SDF_SIMPLE.parse(maxLasttime);
                    c = Calendar.getInstance();
                    c.setTime(date);
                    day = c.get(5);
                    c.set(5, day - 6);
                    dayAfter = new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
                    pstmt.setString(1, lasttime.getGroupid());
                    pstmt.setString(2, dayAfter);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
            catch (SQLException e) {
                Log.error("deleteOldRecently,error={}", (Object)e.getMessage());
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            }
            catch (Exception e2) {
                Log.error("deleteOldRecently,error={}", (Object)e2.getMessage());
                {
                    catch (Throwable throwable) {
                        DbConnectionManager.closeConnection(pstmt, (Connection)con);
                        throw throwable;
                    }
                }
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
    }
}

