/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weaver.cache.redis.RedisPoolMgr;
import com.weaver.emessage.multirouter.messagemanager.UsernameUtil;
import com.weaver.util.ServerInfo;
import com.weaver.util.ThreadPoolFactory;
import com.weaver.util.WeiSouPropertiesUtil;
import com.weaver.util.emservertutil.EMAPIUtil;
import com.weaver.util.subtable.historymsg.MsgIndexUpdateUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.plugin.MultiRouterPlugin;
import org.jivesoftware.openfire.plugin.cache.HistoryMessageRedisCacheUtil;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.jivesoftware.openfire.security.SecurityAuditManager;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;

public class DingUtil {
    private static final Logger Log = LoggerFactory.getLogger(DingUtil.class);
    private static final String SELECT_MOBILE_DING_BY_ID = "select * from mobile_ding where id =? and isdel <> 1";
    private static String REVERT_HISTORYMSGRECENTLY_DING = "UPDATE HistoryMsgRecently SET classname ='RC:TxtMsg', msgContent=? WHERE  msgid =? ";
    private static String REVERT_HISTORY_DING = "UPDATE HistoryMsg SET classname ='RC:TxtMsg', msgContent=? WHERE  msgid =?";
    private static String DELETE_MOBILE_DING = "update mobile_ding set isdel = 1,delete_date = ? where id = ?";
    private static String DELETE_MOBILE_DINGREPLY = "update mobile_dingreply set isdel = 1 where dingid = ?";
    private static String DELETE_MOBILE_DINGRECIVER = "update mobile_dingreciver set isdel = 1 where dingid = ?";
    private final String DING_RECIVER_REDIS_KEY = "ding:reciver:redis:key:";
    private final int DING_RECIVEAR_REDIS_KEY_EXPIRE = 2592000;

    public boolean chechUserDing(String userId, int ding_id) {
        Set<String> userIds = this.getUsersByDingId(ding_id);
        return userIds != null && userIds.size() > 0 && userIds.contains(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUsersByDingId(int ding_id) {
        Set user;
        HashSet<String> userIds = new HashSet<String>();
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr != null && (user = redisPoolMgr.zrange("ding:reciver:redis:key:" + ding_id, 0L, -1L)) != null && !user.isEmpty()) {
            return user;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" select sendid from mobile_ding where id =? and isdel <> 1");
            pstmt.setInt(1, ding_id);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                userIds.add(rs.getString("sendid"));
            }
            DbConnectionManager.closeResultSet((ResultSet)rs);
            DbConnectionManager.closeStatement((Statement)pstmt);
            pstmt = con.prepareStatement(" select id, userid ,dingid ,confirm from mobile_dingReciver where dingid = ? and isdel <> 1 ");
            pstmt.setInt(1, ding_id);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                userIds.add(rs.getString("userid"));
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getUsersByDingId ,error :{} ,ding_id :{} ", (Object)e.getMessage(), (Object)ding_id);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        if (userIds != null && userIds.size() == 0) {
            userIds.add("-1");
        }
        if (redisPoolMgr != null) {
            redisPoolMgr.batchzaddKey("ding:reciver:redis:key:" + ding_id, System.currentTimeMillis(), userIds, 2592000);
        }
        return userIds;
    }

    public static void main(String[] args) {
        String content = "{\"alert\":\"\u76ef\u529e\",\"badge\":\"1\",\"para\":{\"ding\":{\"confirmUpdate\":\"true\",\"content\":\"\u6d4b\u8bd5\",\"dingRecivers\":[{\"confirm\":\"false\",\"dingid\":\"12194\",\"id\":\"53350\",\"userid\":\"9069\"},{\"confirm\":\"false\",\"dingid\":\"12194\",\"id\":\"53351\",\"userid\":\"9067\"},{\"confirm\":\"true\",\"dingid\":\"12194\",\"id\":\"53352\",\"userid\":\"12334\"}],\"dingReplys\":[],\"displayedContent\":\"\u5510\u601d\u8d85\u786e\u5b9a\u4e86\u5fc5\u8fbe: \u6d4b\u8bd5\",\"id\":12194,\"messageid\":\"de487b6b-d35e-4761-8454-b8f185dda059\",\"module\":0,\"operate_date\":\"2020-07-21 19:36:38\",\"replyUpdate\":\"false\",\"scopeid\":\"\",\"sendid\":\"6374\",\"udid\":\"5f72215b-89c3-4cb1-bd2e-5407af80b6ce\"}},\"sound\":\"default\",\"vibrate\":\"1\"}";
        System.out.println(new DingUtil().getDingIdByMessageContent(content));
    }

    public String getDingContent(String content) {
        JSONObject json;
        Log.info("getDingContent contnet :{} ", (Object)content);
        String ding_content = "";
        if (content == null || content.isEmpty()) {
            ding_content = "";
        }
        if ((json = JSON.parseObject((String)content)) != null && json.containsKey((Object)"para")) {
            String ding;
            JSONObject dingJson;
            String para = json.getString("para");
            if (para == null || para.isEmpty()) {
                ding_content = "";
                return ding_content;
            }
            JSONObject paraJson = JSON.parseObject((String)para);
            if (paraJson != null && paraJson.containsKey((Object)"ding") && (dingJson = JSON.parseObject((String)(ding = paraJson.getString("ding")))) != null && dingJson.containsKey((Object)"content")) {
                ding_content = dingJson.getString("content");
            }
        }
        Log.info("getDingContent contnet :{},dingContent:{}  ", (Object)content, (Object)ding_content);
        return ding_content;
    }

    public int getDingIdByMessageContent(String content) {
        int ding_id = 0;
        if (content == null || content.isEmpty()) {
            return ding_id;
        }
        JSONObject json = JSON.parseObject((String)content);
        if (json != null && json.containsKey((Object)"para")) {
            String ding;
            JSONObject dingJson;
            String para = json.getString("para");
            if (para == null || para.isEmpty()) {
                return ding_id;
            }
            JSONObject paraJson = JSON.parseObject((String)para);
            if (paraJson != null && paraJson.containsKey((Object)"ding") && (dingJson = JSON.parseObject((String)(ding = paraJson.getString("ding")))) != null && dingJson.containsKey((Object)"id")) {
                ding_id = dingJson.getIntValue("id");
            }
        }
        return ding_id;
    }

    public void deleteDingUtil(int ding_id, String userId) {
        this.deleteDing(ding_id);
        this.sendMessageToUpdateDing(ding_id);
        this.updateCon(ding_id);
        this.deleteDingId(ding_id, userId);
    }

    private void deleteDingId(int ding_id, String userId) {
        String emServerUrl = JiveGlobals.getProperty((String)"emServerUrl");
        if (emServerUrl == null || emServerUrl.isEmpty()) {
            SecurityAuditManager.getInstance().logEvent("admin", "\u5fc5\u8fbe\u5220\u9664\uff0cEM\u8c03\u7528\u5f02\u5e38 " + ding_id, "em \u5730\u5740\u4e3a\u7a7a");
            return;
        }
        String httpUrl = emServerUrl + "/emp/msgapi/ding/revoke?dingid=" + ding_id + "&userid=" + userId;
        String errmsg = null;
        try {
            String result = EMAPIUtil.httpGet((String)httpUrl, (int)5000, (int)5000);
            JSONObject json = JSONObject.parseObject((String)result);
            if (json != null && json.containsKey((Object)"errcode")) {
                if (0 == json.getIntValue("errcode")) {
                    return;
                }
                if (json != null && json.containsKey((Object)"errmsg")) {
                    errmsg = json.getString("errmsg");
                }
            }
        }
        catch (IOException e) {
            errmsg = "\u7f51\u7edc\u5f02\u5e38";
        }
        SecurityAuditManager.getInstance().logEvent("admin", "\u5fc5\u8fbe\u5220\u9664\uff0cEM\u8c03\u7528\u5f02\u5e38 " + ding_id, errmsg);
    }

    public void withdrawDing(int ding_id, String userId) {
        this.withdrawDingDb(ding_id);
        this.sendMessageToUpdateDing(ding_id);
        this.updateCon(ding_id);
        this.deleteDingId(ding_id, userId);
    }

    private void updateCon(int ding_id) {
        DatabaseUtil du = new DatabaseUtil();
        Map<String, Object> dingMap = du.getDingInfoByDingId(ding_id, true);
        String dingSendid = (String)dingMap.get("sendid");
        List dingRecivers = (List)dingMap.get("dingRecivers");
        ArrayList<String> toUserIds = new ArrayList<String>();
        toUserIds.add(dingSendid);
        Iterator iterator = dingRecivers.iterator();
        Log.info("ding start to delete");
        while (iterator.hasNext()) {
            Map dingReciverMap = (Map)iterator.next();
            String userid = (String)dingReciverMap.get("userid");
            toUserIds.add(userid);
        }
        String xmppid = StringUtils.randomString((int)8);
        if (toUserIds != null && toUserIds.size() > 0) {
            for (String i : toUserIds) {
                String reciverId = this.getRealUserId(i);
                this.updateDingCon((String)dingMap.get("sendid"), "bing_" + reciverId, "3", "\u5fc5\u8fbe", "", xmppid, reciverId, false, "", "RC:InfoNtf:withdraw:RC:TxtMsg");
            }
        }
        this.updateDingCon((String)dingMap.get("sendid"), "bing_" + (String)dingMap.get("sendid"), "3", "\u5fc5\u8fbe", "", xmppid, (String)dingMap.get("sendid"), false, "", "RC:InfoNtf:withdraw:RC:TxtMsg");
    }

    private String getRealUserId(String jidNode) {
        if (jidNode.indexOf("|") > 0) {
            jidNode = jidNode.substring(0, jidNode.indexOf("|"));
        }
        return jidNode;
    }

    private void sendMessageToUpdateDing(int ding_id) {
        DatabaseUtil du = new DatabaseUtil();
        Map<String, Object> dingMap = du.getDingInfoByDingId(ding_id, true);
        String dingSendid = (String)dingMap.get("sendid");
        List dingRecivers = (List)dingMap.get("dingRecivers");
        ArrayList<String> toUserIds = new ArrayList<String>();
        toUserIds.add(dingSendid);
        for (Map dingReciverMap : dingRecivers) {
            String userid = (String)dingReciverMap.get("userid");
            toUserIds.add(userid);
        }
        this.sendDingMessage(this.getDeleteMessage(ding_id, (String)dingMap.get("messageid"), dingSendid), toUserIds, true);
    }

    private void sendDingMessage(Message message, List<String> toUserIds, final boolean isDelDing) {
        for (int i = 0; i < toUserIds.size(); ++i) {
            toUserIds.set(i, this.getNodeID(toUserIds.get(i)));
        }
        final List<String> toUserIdsFinal = toUserIds;
        final Message messageFinal = message;
        ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                if (toUserIdsFinal != null && toUserIdsFinal.size() > 0) {
                    for (int i = 0; i < toUserIdsFinal.size(); ++i) {
                        if (i != 0 && i % 200 == 0) {
                            if (isDelDing) {
                                Log.info("sendDelMessage,sendMessageNumber is {} ,and now thread sleep,msgid={}", (Object)i, (Object)messageFinal.getID());
                            } else {
                                Log.info("sendConfirmMessage,sendMessageNumber is {} ,and now thread sleep,msgid={}", (Object)i, (Object)messageFinal.getID());
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                if (isDelDing) {
                                    Log.error("sendDelMessage,sendMessageThread sleep msgid={}, error={},", (Object)messageFinal.getID(), (Object)e.getMessage());
                                }
                                Log.error("sendConfirmMessage,sendMessageThread sleep msgid={}, error={},", (Object)messageFinal.getID(), (Object)e.getMessage());
                            }
                        }
                        Message messageCopy = messageFinal.createCopy();
                        String toUserId = ((String)toUserIdsFinal.get(i)).toLowerCase();
                        messageCopy.setTo(new JID(toUserId, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                        MultiRouterPlugin.serverPlugin.sendPacket((Packet)messageCopy);
                    }
                }
            }
        });
    }

    private Message getDeleteMessage(int ding_id, String messageid, String sendid) {
        Message message = new Message();
        JSONObject dingMessage = new JSONObject();
        JSONObject contentObject = new JSONObject();
        JSONObject paraObject = new JSONObject();
        HashMap<String, Object> dingMap = new HashMap<String, Object>();
        dingMap.put("id", ding_id);
        dingMap.put("sendid", sendid);
        dingMap.put("messageid", messageid);
        paraObject.put("ding", dingMap);
        contentObject.put("para", (Object)paraObject);
        contentObject.put("type", (Object)"delete");
        dingMessage.put("objectName", (Object)"FW:CMDMsg");
        dingMessage.put("content", (Object)contentObject.toJSONString());
        message.setType(Message.Type.chat);
        message.setBody(dingMessage.toJSONString());
        message.setFrom(new JID(ServerInfo.SYSTEM_UDID + "|ding", XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
        message.setID(StringUtils.randomString((int)8));
        Log.info("DingUtil,getDeleteMessage : ding_id :{} ,message :{} ", (Object)ding_id, (Object)message.toString());
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean withdrawDingDb(int dingId) {
        boolean bl;
        SimpleDateFormat SDF_ALL = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String deleteDate = SDF_ALL.format(new Date());
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        boolean abortTransaction = false;
        String messageid = null;
        Object msgContent = null;
        try {
            con = DbConnectionManager.getTransactionConnection();
            pstmt = con.prepareStatement(SELECT_MOBILE_DING_BY_ID);
            pstmt.setInt(1, dingId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                messageid = rs.getString("messageid");
            }
            DbConnectionManager.fastcloseStmt((PreparedStatement)pstmt);
            pstmt = con.prepareStatement(DELETE_MOBILE_DING);
            pstmt.setString(1, deleteDate);
            pstmt.setInt(2, dingId);
            int dingResult = pstmt.executeUpdate();
            DbConnectionManager.fastcloseStmt((PreparedStatement)pstmt);
            pstmt = con.prepareStatement(DELETE_MOBILE_DINGREPLY);
            pstmt.setInt(1, dingId);
            int dingReplyResult = pstmt.executeUpdate();
            DbConnectionManager.fastcloseStmt((PreparedStatement)pstmt);
            pstmt = con.prepareStatement(DELETE_MOBILE_DINGRECIVER);
            pstmt.setInt(1, dingId);
            int dingReciverResult = pstmt.executeUpdate();
            bl = dingResult > -1 && dingReplyResult > -1 && dingReciverResult > -1;
        }
        catch (SQLException e) {
            try {
                abortTransaction = true;
                Log.error("deleteDing, dingId={},operateDate={},err={}", new Object[]{dingId, deleteDate, e.getMessage()});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeStatement(pstmt);
                DbConnectionManager.closeTransactionConnection((Connection)con, (boolean)abortTransaction);
                throw throwable;
            }
            DbConnectionManager.closeStatement((Statement)pstmt);
            DbConnectionManager.closeTransactionConnection((Connection)con, (boolean)abortTransaction);
            return false;
        }
        DbConnectionManager.closeStatement((Statement)pstmt);
        DbConnectionManager.closeTransactionConnection((Connection)con, (boolean)abortTransaction);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDingCon(String userid, String targetid, String targettype, String targetname, String msgcontent, String msgId, String reciverId, boolean needRecordUnreadCount, String content, String objectName) {
        Log.info("updateDingCon,userid={},targetid={},msgId={},reciverId={},targetname={}", new Object[]{userid, targetid, msgId, reciverId, targetname});
        try {
            UserManager userManager = UserManager.getInstance();
            User user = userManager.getUser((userid + "|" + ServerInfo.SYSTEM_UDID).toLowerCase());
            String username = UsernameUtil.getUserName(user.getUsername(), user.getName());
            msgcontent = username + LocaleUtils.getLocalizedString((String)"ding.delete", (String)"multirouter");
            content = LocaleUtils.getLocalizedString((String)"ding.delete", (String)"multirouter");
        }
        catch (Exception e) {
            Log.error("updateDingCon error :{}", (Object)e.getMessage());
        }
        Long updatetime = System.currentTimeMillis();
        HashMap<String, String> obMap = new HashMap<String, String>();
        obMap.put("userid", userid);
        obMap.put("targetid", targetid);
        obMap.put("targettype", targettype);
        obMap.put("targetname", targetname);
        obMap.put("msgcontent", msgcontent);
        obMap.put("msgid", msgId);
        obMap.put("lasttime", String.valueOf(updatetime));
        obMap.put("istop", "0");
        obMap.put("isdel", "0");
        obMap.put("unreadcount", "0");
        obMap.put("groupName", "");
        obMap.put("groupIconUrl", "");
        obMap.put("objectName", objectName);
        obMap.put("content", content);
        obMap.put("sendId", userid);
        String key_itme = "conversation:itmes:" + targetid + ":" + reciverId;
        String key_right = "conversation:right:" + reciverId;
        RedisPoolMgr redisPoolMgr = null;
        try {
            redisPoolMgr = RedisPoolMgr.getInstance();
            for (Map.Entry kv : obMap.entrySet()) {
                redisPoolMgr.hsetnx(key_itme, (String)kv.getKey(), (String)kv.getValue());
            }
            obMap.remove("istop");
            obMap.remove("unreadcount");
            for (Map.Entry kv : obMap.entrySet()) {
                redisPoolMgr.hset(key_itme, (String)kv.getKey(), (String)kv.getValue());
            }
            if (needRecordUnreadCount) {
                redisPoolMgr.hincrBy(key_itme, "unreadcount", 1L);
            }
            redisPoolMgr.zadd(key_right, updatetime.longValue(), key_itme, -1);
            redisPoolMgr.zadd("conversation:queue", System.currentTimeMillis(), key_itme, -1);
        }
        catch (Exception e) {
            Log.error("updateDingCon,userid={},targetid={},msgId={},targetname={},err={}", new Object[]{userid, targetid, msgId, targetname, e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean deleteDing(int dingId) {
        boolean bl;
        SimpleDateFormat SDF_ALL = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat SDF_ALL_UP = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String deleteDate = SDF_ALL.format(new Date());
        String updateTime = SDF_ALL_UP.format(new Date());
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        boolean abortTransaction = false;
        String messageid = null;
        String msgContent = null;
        try {
            con = DbConnectionManager.getTransactionConnection();
            pstmt = con.prepareStatement(SELECT_MOBILE_DING_BY_ID);
            pstmt.setInt(1, dingId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                messageid = rs.getString("messageid");
            }
            DbConnectionManager.fastcloseStmt((PreparedStatement)pstmt);
            if (null != messageid && !"".equals(messageid)) {
                RedisPoolMgr redisPoolMgr;
                Log.info("deleteDing, dingId={},start to revert ding to noarmal msg, messageid={}", (Object)dingId, (Object)messageid);
                if (HistoryMessageRedisCacheUtil.getInstance() != null && (redisPoolMgr = RedisPoolMgr.getInstance()) != null) {
                    String fullAmount = redisPoolMgr.hget("history:msg:" + messageid, "fullAmount");
                    Log.info("deleteDing, dingId={},redis data history:msg exists, messageid={}, fullAmount is={}", new Object[]{dingId, messageid, fullAmount});
                    if (fullAmount != null && !"".equals(fullAmount)) {
                        JSONObject fullAmountObj = JSONObject.parseObject((String)fullAmount);
                        msgContent = fullAmountObj.getString("content");
                        HistoryMessageRedisCacheUtil.getInstance().revertDingClassName(messageid, msgContent);
                        pstmt = con.prepareStatement(REVERT_HISTORYMSGRECENTLY_DING);
                        pstmt.setString(1, msgContent);
                        pstmt.setString(2, messageid);
                        pstmt.executeUpdate();
                        DbConnectionManager.fastcloseStmt((PreparedStatement)pstmt);
                        String tableName = MsgIndexUpdateUtil.getTableNameByMsgId((String)messageid);
                        String sql = "UPDATE " + tableName + " SET classname ='RC:TxtMsg', msgContent=?,updatetime=? WHERE  msgid =?";
                        pstmt = con.prepareStatement(sql);
                        pstmt.setString(1, msgContent);
                        pstmt.setString(2, updateTime);
                        pstmt.setString(3, messageid);
                        pstmt.executeUpdate();
                        DbConnectionManager.fastcloseStmt((PreparedStatement)pstmt);
                        WeiSouPropertiesUtil w = WeiSouPropertiesUtil.getInstance();
                        if (w.isWeiSouEnable() && JiveGlobals.getBooleanProperty((String)"subtable.historyMsg", (boolean)false)) {
                            MsgIndexUpdateUtil msg = new MsgIndexUpdateUtil();
                            msg.updateMsgIndex("1", tableName, messageid);
                        }
                    }
                }
            }
            pstmt = con.prepareStatement(DELETE_MOBILE_DING);
            pstmt.setString(1, deleteDate);
            pstmt.setInt(2, dingId);
            int dingResult = pstmt.executeUpdate();
            DbConnectionManager.fastcloseStmt((PreparedStatement)pstmt);
            pstmt = con.prepareStatement(DELETE_MOBILE_DINGREPLY);
            pstmt.setInt(1, dingId);
            int dingReplyResult = pstmt.executeUpdate();
            DbConnectionManager.fastcloseStmt((PreparedStatement)pstmt);
            pstmt = con.prepareStatement(DELETE_MOBILE_DINGRECIVER);
            pstmt.setInt(1, dingId);
            int dingReciverResult = pstmt.executeUpdate();
            bl = dingResult > -1 && dingReplyResult > -1 && dingReciverResult > -1;
        }
        catch (SQLException e) {
            try {
                abortTransaction = true;
                Log.error("deleteDing, dingId={},operateDate={},err={}", new Object[]{dingId, deleteDate, e.getMessage()});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeStatement(pstmt);
                DbConnectionManager.closeTransactionConnection((Connection)con, (boolean)abortTransaction);
                throw throwable;
            }
            DbConnectionManager.closeStatement((Statement)pstmt);
            DbConnectionManager.closeTransactionConnection((Connection)con, (boolean)abortTransaction);
            return false;
        }
        DbConnectionManager.closeStatement((Statement)pstmt);
        DbConnectionManager.closeTransactionConnection((Connection)con, (boolean)abortTransaction);
        return bl;
    }

    private String getNodeID(String userid) {
        if (userid.indexOf("|") < 0) {
            userid = userid + "|" + ServerInfo.SYSTEM_UDID;
        }
        return userid;
    }
}

