/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.weaver.cache.redis.RedisLuaScriptReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuaFileConfig
implements RedisLuaScriptReader {
    private static final Logger Log = LoggerFactory.getLogger(LuaFileConfig.class);

    public String readLuaFromFile(String fileName) {
        String encoding = "UTF-8";
        String filePath = JiveGlobals.getHomeDirectory() + File.separator + "plugins" + File.separator + "multirouter" + File.separator + "lua" + File.separator + fileName;
        File file = new File(filePath);
        Long filelength = file.length();
        byte[] filecontent = new byte[filelength.intValue()];
        try {
            FileInputStream in = new FileInputStream(file);
            in.read(filecontent);
            in.close();
            Log.info("LuaFileConfig, load success,file path is:{}", (Object)filePath);
        }
        catch (FileNotFoundException e) {
            Log.error("LuaFileConfig,lua script not found,path is:{}", (Object)filePath);
            return null;
        }
        catch (IOException e) {
            Log.error("LuaFileConfig,lua script io exception,path is:{}", (Object)filePath);
            return null;
        }
        try {
            return new String(filecontent, encoding);
        }
        catch (UnsupportedEncodingException e) {
            Log.error("LuaFileConfig, the OS does not support:{} " + encoding);
            return null;
        }
    }
}

