/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.weaver.util.cluster.ClusterPropBeanUtil;
import com.weaver.util.cluster.ClusterRedisUtil;
import java.util.Collection;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;

public class MessageRouterUtil {
    private static final Logger Log = LoggerFactory.getLogger(MessageRouterUtil.class);

    public static void RouterMessageToMobileAndPc(Message msg) {
        if (JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false)) {
            MessageRouterUtil.RouterMessageToMobileAndPad(msg);
        } else {
            MessageRouterUtil.RouterMessageToMobile(msg);
        }
    }

    private static void RouterMessageToMobileAndPad(Message msg) {
        ClusterPropBeanUtil clusterPropBeanUtil;
        Message message = msg.createCopy();
        String username = message.getFrom().getNode();
        SessionManager sessionManager = SessionManager.getInstance();
        boolean mobileOnline = false;
        boolean padOnline = false;
        boolean pcOnline = false;
        Collection sessions = sessionManager.getSessions(username);
        if (sessions != null && sessions.size() > 0) {
            for (ClientSession session : sessions) {
                JID jid = session.getAddress();
                if ("mobile".equals(jid.getResource())) {
                    mobileOnline = true;
                } else if ("pc".equals(jid.getResource())) {
                    pcOnline = true;
                } else if ("pad".equals(jid.getResource())) {
                    padOnline = true;
                }
                Message routeMessage = message.createCopy();
                if (message.getTo().getDomain().startsWith("group")) {
                    routeMessage.setFrom(new JID(username, "confirm.group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), msg.getTo().getNode(), true));
                } else {
                    routeMessage.setFrom(new JID(username, "confirm." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), msg.getTo().getNode(), true));
                }
                routeMessage.setTo(jid);
                Log.info("RouterMessageToMobileAndPc to PC :msgid:{},fromJID:{},toJID:{}", new Object[]{routeMessage.getID(), msg.getTo().getNode(), routeMessage.getTo()});
                session.process((Packet)routeMessage);
            }
        }
        if ((clusterPropBeanUtil = ClusterPropBeanUtil.getInstance()).isUseCluster()) {
            JID pcJID;
            String pcClusterName;
            JID padJID;
            String padClusterName;
            Message routeMessage;
            JID mobileJID;
            String mobileClusterName;
            ClusterRedisUtil clusterRedisUtil = ClusterRedisUtil.getInstance();
            if (!mobileOnline && (mobileClusterName = clusterRedisUtil.getUserResourceNode(mobileJID = new JID(msg.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true))) != null && !mobileClusterName.isEmpty()) {
                routeMessage = message.createCopy();
                if (message.getTo().getDomain().startsWith("group")) {
                    routeMessage.setFrom(new JID(username, "confirm.group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), msg.getTo().getNode(), true));
                } else {
                    routeMessage.setFrom(new JID(username, "confirm." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), msg.getTo().getNode(), true));
                }
                routeMessage.setTo(mobileJID);
                clusterRedisUtil.saveToRedis(mobileClusterName, routeMessage);
            }
            if (!padOnline && (padClusterName = clusterRedisUtil.getUserResourceNode(padJID = new JID(msg.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pad", true))) != null && !padClusterName.isEmpty()) {
                routeMessage = message.createCopy();
                if (message.getTo().getDomain().startsWith("group")) {
                    routeMessage.setFrom(new JID(username, "confirm.group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), msg.getTo().getNode(), true));
                } else {
                    routeMessage.setFrom(new JID(username, "confirm." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), msg.getTo().getNode(), true));
                }
                routeMessage.setTo(padJID);
                clusterRedisUtil.saveToRedis(padClusterName, routeMessage);
            }
            if (!pcOnline && (pcClusterName = clusterRedisUtil.getUserResourceNode(pcJID = new JID(msg.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true))) != null && !pcClusterName.isEmpty()) {
                routeMessage = message.createCopy();
                if (message.getTo().getDomain().startsWith("group")) {
                    routeMessage.setFrom(new JID(username, "confirm.group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), msg.getTo().getNode(), true));
                } else {
                    routeMessage.setFrom(new JID(username, "confirm." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), msg.getTo().getNode(), true));
                }
                routeMessage.setTo(pcJID);
                clusterRedisUtil.saveToRedis(pcClusterName, routeMessage);
            }
        }
    }

    private static void RouterMessageToMobile(Message msg) {
        ClusterPropBeanUtil clusterPropBeanUtil;
        Log.info("RouterMessageToMobile:{},fromJID:{}", (Object)msg.getID(), (Object)msg.getFrom());
        Message message = msg.createCopy();
        String username = message.getFrom().getNode();
        SessionManager sessionManager = SessionManager.getInstance();
        boolean mobileOnline = false;
        boolean pcOnline = false;
        Collection sessions = sessionManager.getSessions(username);
        if (sessions != null && sessions.size() > 0) {
            for (ClientSession session : sessions) {
                JID jid = session.getAddress();
                if ("mobile".equals(jid.getResource())) {
                    mobileOnline = true;
                } else if ("pc".equals(jid.getResource())) {
                    pcOnline = true;
                }
                Message routeMessage = message.createCopy();
                if (message.getTo().getDomain().startsWith("group")) {
                    routeMessage.setFrom(new JID(username, "confirm.group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), msg.getTo().getNode(), true));
                } else {
                    routeMessage.setFrom(new JID(username, "confirm." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), msg.getTo().getNode(), true));
                }
                routeMessage.setTo(jid);
                Log.info("RouterMessageToMobileAndPc to PC :msgid:{},fromJID:{},toJID:{}", new Object[]{routeMessage.getID(), msg.getTo().getNode(), routeMessage.getTo()});
                session.process((Packet)routeMessage);
            }
        }
        if ((clusterPropBeanUtil = ClusterPropBeanUtil.getInstance()).isUseCluster()) {
            JID pcJID;
            String clusterNode;
            JID mobileJID;
            ClusterRedisUtil clusterRedisUtil = ClusterRedisUtil.getInstance();
            String mobileClusterName = null;
            if (!mobileOnline && (mobileClusterName = clusterRedisUtil.getUserResourceNode(mobileJID = new JID(msg.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true))) != null && !mobileClusterName.isEmpty()) {
                Message routeMessage = message.createCopy();
                if (message.getTo().getDomain().startsWith("group")) {
                    routeMessage.setFrom(new JID(username, "confirm.group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), msg.getTo().getNode(), true));
                } else {
                    routeMessage.setFrom(new JID(username, "confirm." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), msg.getTo().getNode(), true));
                }
                routeMessage.setTo(mobileJID);
                clusterRedisUtil.saveToRedis(mobileClusterName, routeMessage);
            }
            if (!pcOnline && (clusterNode = clusterRedisUtil.getUserResourceNode(pcJID = new JID(msg.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true))) != null && !clusterNode.isEmpty()) {
                Message routeMessage = message.createCopy();
                if (message.getTo().getDomain().startsWith("group")) {
                    routeMessage.setFrom(new JID(username, "confirm.group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), msg.getTo().getNode(), true));
                } else {
                    routeMessage.setFrom(new JID(username, "confirm." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), msg.getTo().getNode(), true));
                }
                routeMessage.setTo(pcJID);
                clusterRedisUtil.saveToRedis(clusterNode, routeMessage);
            }
        }
    }
}

