/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgDataMaskUtil {
    private static final Logger Log = LoggerFactory.getLogger(MsgDataMaskUtil.class);
    private static MsgDataMaskUtil instance = null;
    private boolean msgDataMaskEnabled = true;
    private static final String MSG_DATA_MASK_PROP = JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + "msgDataMask.properties";

    public static void main(String[] args) {
        String msgcontent = "12345678901234567890";
        StringBuffer sb = new StringBuffer();
        int j = 0;
        for (int i = 0; i < msgcontent.length(); ++i) {
            if (j == 0 || j == 1) {
                sb.append(msgcontent.charAt(i));
                ++j;
            } else if (j == 2 || j == 3) {
                sb.append("*");
                ++j;
            }
            if (j == 4) {
                j = 0;
            }
            System.out.println(j);
        }
        System.out.println(sb.toString());
    }

    public String msgDataMask(String msgcontent) {
        StringBuilder sb = new StringBuilder();
        if (this.msgDataMaskEnabled) {
            int j = 0;
            for (int i = 0; i < msgcontent.length(); ++i) {
                if (j == 0 || j == 1) {
                    sb.append(msgcontent.charAt(i));
                    ++j;
                } else if (j == 2 || j == 3) {
                    sb.append("*");
                    ++j;
                }
                if (j != 4) continue;
                j = 0;
            }
        } else {
            sb = new StringBuilder(msgcontent);
        }
        return sb.toString();
    }

    public static MsgDataMaskUtil getInstance() {
        if (instance == null) {
            instance = new MsgDataMaskUtil();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MsgDataMaskUtil() {
        InputStream is = null;
        try {
            File file = new File(MSG_DATA_MASK_PROP);
            if (!file.exists()) {
                return;
            }
            is = new FileInputStream(file);
            Properties prop = new Properties();
            prop.load(is);
            String msgDataMask = prop.getProperty("msgDataMaskEnabled").trim();
            if ("false".equals(msgDataMask)) {
                this.msgDataMaskEnabled = false;
            }
        }
        catch (Exception e) {
            Log.error("MsgDataMaskUtil,error:{}e:{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

