/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultilingualUtil {
    private static final Logger Log = LoggerFactory.getLogger(MultilingualUtil.class);

    public static String formatMultiLang(String s, String lang) {
        if (lang == null || lang.isEmpty() || MultilingualUtil.isInteger(lang)) {
            lang = "zh";
        }
        String langName = null;
        try {
            JSONObject json = JSON.parseObject((String)s);
            if (json != null) {
                Iterator iterator;
                if (json.containsKey((Object)lang)) {
                    langName = json.getString(lang);
                }
                if ((langName == null || langName.isEmpty()) && json.containsKey((Object)"en")) {
                    langName = json.getString("en");
                }
                if ((langName == null || langName.isEmpty()) && json.containsKey((Object)"zh")) {
                    langName = json.getString("zh");
                }
                if ((langName == null || langName.isEmpty()) && (iterator = json.keySet().iterator()).hasNext()) {
                    String key = (String)iterator.next();
                    langName = json.getString(key);
                }
            }
        }
        catch (Exception e) {
            langName = s;
        }
        return langName;
    }

    public static void main(String[] args) {
        String s = "{\"zh\":\"\u6d4b\u8bd5\u8d26\u53f701\"}";
        System.out.println(MultilingualUtil.formatMultiLang(s, "ff"));
        System.out.println(MultilingualUtil.formatMultiLang(s, null));
    }

    private static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    public static String null2String(String s) {
        return s == null ? "" : s;
    }
}

