/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.weaver.util.ThreadPoolFactory;
import com.weaver.util.ThreadPrefix;
import com.weaver.util.msgpush.RobotDbUtil;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.jivesoftware.openfire.plugin.push.PushMessageForIOS;
import org.jivesoftware.openfire.plugin.push.PushMessageThread;
import org.jivesoftware.openfire.plugin.util.PushMessageInitUtil;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyEventListenerForMessagePush
implements PropertyEventListener {
    private static final Logger Log = LoggerFactory.getLogger(PropertyEventListenerForMessagePush.class);
    private ExecutorService fixedThreadPool = ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool();

    public void propertySet(String property, Map<String, Object> params) {
        if ("pushSet".equals(property)) {
            String value = (String)params.get("value");
            if ("true".equals(value)) {
                this.closePushMessage();
            } else if ("false".equals(value)) {
                this.openPushMessage();
            }
        } else if ("jpushAppKey".equals(property)) {
            PushMessageForIOS.getJPushClientForCustomized();
        } else if ("jpushSecret".equals(property)) {
            PushMessageForIOS.getJPushClientForCustomized();
        } else if ("xmpp.robot.enable".equals(property)) {
            RobotDbUtil.updateRoBot((boolean)false);
        }
    }

    public void propertyDeleted(String property, Map<String, Object> params) {
        if ("pushSet".equals(property)) {
            this.openPushMessage();
        } else if ("jpushAppKey".equals(property)) {
            PushMessageForIOS.getJPushClientForCustomized();
        } else if ("jpushSecret".equals(property)) {
            PushMessageForIOS.getJPushClientForCustomized();
        } else if ("xmpp.robot.enable".equals(property)) {
            RobotDbUtil.updateRoBot((boolean)false);
        }
    }

    public void xmlPropertySet(String property, Map<String, Object> params) {
    }

    public void xmlPropertyDeleted(String property, Map<String, Object> params) {
    }

    private void closePushMessage() {
        if (!PushMessageInitUtil.isPushMessageThreadRunning) {
            Log.info("now pushMessageThread is closed .not need to close.");
        } else {
            PushMessageInitUtil.isPushMessageThreadRunning = false;
            Log.info("now pushMessageThread is cloesd.");
        }
    }

    private void openPushMessage() {
        if (PushMessageInitUtil.isPushMessageThreadRunning) {
            Log.info("now pushMessageThread is running .not need to open.");
        } else {
            boolean signPush = JiveGlobals.getBooleanProperty((String)"signPush", (boolean)false);
            if (signPush) {
                PushMessageInitUtil pmiu = PushMessageInitUtil.getInstance();
                pmiu.initPush();
                PushMessageInitUtil.isPushMessageThreadRunning = true;
                Log.info("pushSet is open and pushThread is not running.not start push thread.");
                for (int i = 0; i < JiveGlobals.getIntProperty((String)"pushMessageThreadCount", (int)40); ++i) {
                    this.fixedThreadPool.execute(new PushMessageThread(ThreadPrefix.PUSH_THREAD.toString() + i + "-" + this.getClass().getSimpleName()));
                }
            } else {
                PushMessageInitUtil pmiu = PushMessageInitUtil.getInstance();
                boolean pushMessageClientInitSuccess = pmiu.initPush();
                if (pushMessageClientInitSuccess) {
                    Log.info("pushSet is open and pushThread is not running.not start push thread.");
                    PushMessageInitUtil.isPushMessageThreadRunning = true;
                    for (int i = 0; i < JiveGlobals.getIntProperty((String)"pushMessageThreadCount", (int)40); ++i) {
                        this.fixedThreadPool.execute(new PushMessageThread(ThreadPrefix.PUSH_THREAD.toString() + i + "-" + this.getClass().getSimpleName()));
                    }
                } else {
                    Log.error("push message client init failed.no push.");
                }
            }
        }
    }
}

