/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.jivesoftware.openfire.plguin.push.zdbank.ZDBankPushUtil;
import org.jivesoftware.openfire.plugin.bean.HttpProxyForPush;
import org.jivesoftware.openfire.plugin.push.MPaaSPushUtil;
import org.jivesoftware.openfire.plugin.push.MessagePushYYUtil;
import org.jivesoftware.openfire.plugin.push.PushMessageForBingoJpush;
import org.jivesoftware.openfire.plugin.push.PushMessageForGePush;
import org.jivesoftware.openfire.plugin.push.TaibaoPushUtil;
import org.jivesoftware.openfire.plugin.push.weapppush.WeAppPushUtil;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushMessageInitUtil {
    private static final Logger Log = LoggerFactory.getLogger(PushMessageInitUtil.class);
    public static Map<String, String> pushTypes = new HashMap<String, String>();
    public static Map<String, String> para = new HashMap<String, String>();
    public static boolean isUserAnyOffice;
    private static PushMessageInitUtil instance;
    public static boolean isPushMessageThreadRunning;

    private PushMessageInitUtil() {
    }

    public static synchronized PushMessageInitUtil getInstance() {
        if (instance == null) {
            instance = new PushMessageInitUtil();
        }
        return instance;
    }

    public boolean initPush() {
        PushMessageForGePush pmfgp = PushMessageForGePush.getInstance();
        boolean useGPush = pmfgp.isUseIGtPush();
        PushMessageForBingoJpush pmfbj = PushMessageForBingoJpush.getInstance();
        boolean useBingoJpush = pmfbj.isUseBingoJpush();
        boolean pushToWX = MessagePushYYUtil.yyPushOpen;
        boolean mpaasPush = MPaaSPushUtil.isEnable();
        if (useGPush || useBingoJpush || pushToWX || mpaasPush) {
            this.initPushForAnyOffice();
            return true;
        }
        if (TaibaoPushUtil.checkTaibaoPushEnable()) {
            this.initPushForAnyOffice();
            return true;
        }
        if (ZDBankPushUtil.checkPushEnable()) {
            this.initPushForAnyOffice();
            return true;
        }
        isUserAnyOffice = JiveGlobals.getBooleanProperty((String)"isUserAnyOffice", (boolean)false);
        if (isUserAnyOffice) {
            this.initPushForAnyOffice();
        } else {
            try {
                this.initPushClient();
            }
            catch (Exception e) {
                Log.error("PushMessageInitUtil,push init error.no push.e:{}", (Object)e.getMessage());
                return false;
            }
        }
        return true;
    }

    private void initPushForAnyOffice() {
        if (pushTypes.size() == 0) {
            pushTypes.put("FW:PersonCardMsg", "FW:PersonCardMsg");
            pushTypes.put("RC:PublicNoticeMsg", "RC:PublicNoticeMsg");
            pushTypes.put("FW:CustomShareMsg", "FW:CustomShareMsg");
            pushTypes.put("FW:UniteMsg", "FW:UniteMsg");
            pushTypes.put("RC:ExpMsg", "RC:ExpMsg");
            boolean isPushFiles = JiveGlobals.getBooleanProperty((String)"isPushFiles", (boolean)true);
            if (isPushFiles) {
                pushTypes.put("FW:attachmentMsg", "FW:attachmentMsg");
            } else {
                Log.info("not push files to e-mobile.");
            }
            pushTypes.put("FW:richTextMsg", "FW:richTextMsg");
            pushTypes.put("FW:CustomMsg", "FW:CustomMsg");
            pushTypes.put("RC:ImgMsg", "RC:ImgMsg");
            pushTypes.put("RC:LBSMsg", "RC:LBSMsg");
            pushTypes.put("RC:ImgTextMsg", "RC:ImgTextMsg");
            pushTypes.put("RC:TxtMsg", "RC:TxtMsg");
            pushTypes.put("RC:VcMsg", "RC:VcMsg");
            pushTypes.put("FW:CMDMsg", "FW:CMDMsg");
        }
    }

    private void initPushClient() throws Exception {
        WeAppPushUtil weAppPushUtil;
        String accessToken;
        if (pushTypes.size() == 0) {
            pushTypes.put("FW:PersonCardMsg", "FW:PersonCardMsg");
            pushTypes.put("RC:PublicNoticeMsg", "RC:PublicNoticeMsg");
            pushTypes.put("FW:CustomShareMsg", "FW:CustomShareMsg");
            pushTypes.put("FW:UniteMsg", "FW:UniteMsg");
            pushTypes.put("RC:ExpMsg", "RC:ExpMsg");
            boolean isPushFiles = JiveGlobals.getBooleanProperty((String)"isPushFiles", (boolean)true);
            if (isPushFiles) {
                pushTypes.put("FW:attachmentMsg", "FW:attachmentMsg");
            } else {
                Log.info("not push files to e-mobile.");
            }
            pushTypes.put("FW:richTextMsg", "FW:richTextMsg");
            pushTypes.put("FW:CustomMsg", "FW:CustomMsg");
            pushTypes.put("RC:ImgMsg", "RC:ImgMsg");
            pushTypes.put("RC:LBSMsg", "RC:LBSMsg");
            pushTypes.put("RC:ImgTextMsg", "RC:ImgTextMsg");
            pushTypes.put("RC:TxtMsg", "RC:TxtMsg");
            pushTypes.put("RC:VcMsg", "RC:VcMsg");
            pushTypes.put("FW:CMDMsg", "FW:CMDMsg");
        }
        if ((accessToken = (weAppPushUtil = WeAppPushUtil.getInstance()).getAccess_Token()) == null) {
            throw new Exception("\u83b7\u53d6pushserver \uff0caccess_token error");
        }
    }

    public static boolean checkPushUrl(String checkUrl) {
        boolean result = false;
        try {
            URL urlObj = new URL(checkUrl);
            HttpURLConnection urlConnection = null;
            HttpProxyForPush httpProxyForPush = HttpProxyForPush.getInstance();
            boolean isUserProxy = httpProxyForPush.isUserProxy();
            if (isUserProxy) {
                InetSocketAddress addr = new InetSocketAddress(httpProxyForPush.getProxyHost(), httpProxyForPush.getProxyPort());
                Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
                urlConnection = (HttpURLConnection)urlObj.openConnection(proxy);
                boolean isNeedAuth = httpProxyForPush.isPropxyNeedAuth();
                if (isNeedAuth) {
                    String encoded = new String(Base64.encodeBase64((byte[])(httpProxyForPush.getProxyUsername() + ":" + httpProxyForPush.getProxyPassword()).getBytes()));
                    urlConnection.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
                }
            } else {
                urlConnection = (HttpURLConnection)urlObj.openConnection();
            }
            urlConnection.setUseCaches(false);
            urlConnection.setConnectTimeout(5000);
            urlConnection.getResponseCode();
            result = true;
        }
        catch (Exception e) {
            Log.error("checkPushUrl testUrl :{} ,error:{}", (Object)checkUrl, (Object)e.getMessage());
            result = false;
        }
        return result;
    }

    static {
        instance = null;
        isPushMessageThreadRunning = false;
    }
}

