/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weaver.multirouter.msgpushutil.MsgPushUtil;
import com.weaver.util.LanguageUtil;
import com.weaver.util.ServerInfo;
import com.weaver.util.nomsgdbutil.NoMsgDatabaseUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.List;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.plguin.push.zdbank.ZDBankPushUtil;
import org.jivesoftware.openfire.plugin.anyoffice.AnyofficeService;
import org.jivesoftware.openfire.plugin.bean.PushDevice;
import org.jivesoftware.openfire.plugin.push.MPaaSPushUtil;
import org.jivesoftware.openfire.plugin.push.MessagePushYYUtil;
import org.jivesoftware.openfire.plugin.push.PushDbUtil;
import org.jivesoftware.openfire.plugin.push.PushMessageForBingoJpush;
import org.jivesoftware.openfire.plugin.push.PushMessageForGePush;
import org.jivesoftware.openfire.plugin.push.PushMessageToWeAPPJpushUtil;
import org.jivesoftware.openfire.plugin.push.PushMessageWithPackage;
import org.jivesoftware.openfire.plugin.push.TaibaoPushUtil;
import org.jivesoftware.openfire.plugin.push.weapppush.WeAppPushUtil;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.jivesoftware.openfire.plugin.util.JIDUtil;
import org.jivesoftware.openfire.plugin.util.MultilingualUtil;
import org.jivesoftware.openfire.plugin.util.PushMessageInitUtil;
import org.jivesoftware.openfire.plugin.util.UDIDUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class PushMessageUtil {
    private static final Logger Log = LoggerFactory.getLogger(PushMessageUtil.class);
    private UserManager userManager = UserManager.getInstance();
    private GroupManager groupManager = GroupManager.getInstance();
    private static String emailPushName = null;
    private String pushBefore = null;

    public void pushMessage(Message message) throws Exception {
        String extraStr;
        JSONObject extraJson;
        String no_push;
        Log.info("now pushMessage,from:{},to:{},msgId:{}", new Object[]{message.getFrom(), message.getTo(), message.getID()});
        boolean pushToWX = MessagePushYYUtil.yyPushOpen;
        String zh_name = "";
        JID jid = message.getTo();
        try {
            zh_name = UserManager.getInstance().getUser(message.getTo().getNode()).getName();
            if (zh_name.startsWith("{")) {
                zh_name = JSON.parseObject((String)zh_name).getString("zh");
            }
        }
        catch (UserNotFoundException e) {
            Log.warn("now pushMessage, user not found");
        }
        boolean isPushEmail = JiveGlobals.getBooleanProperty((String)"isPushEmail", (boolean)true);
        if (!isPushEmail) {
            String username = message.getFrom().getNode();
            String emailPushName = this.getEmailPushName();
            if (emailPushName.equalsIgnoreCase(username)) {
                Log.info("is email message and no push. from:{},to:{}", (Object)message.getFrom(), (Object)message.getTo());
                return;
            }
        }
        PushDbUtil du = new PushDbUtil();
        PushDevice pd = du.getRegisterPush(jid);
        pd = JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false) ? du.getRegisterPush(jid, jid.getResource()) : du.getRegisterPush(jid);
        if (!(pushToWX || pd != null && !pd.getToken().equals(" ") && !pd.getToken().isEmpty() && !"-1".equals(pd.getToken()) || "501".equals(pd.getType()) || "502".equals(pd.getType()) || "601".equals(pd.getType()))) {
            Log.info("user token is empty, no push, to jid:{}, msgid:{}", (Object)jid.toString(), (Object)message.getID());
            return;
        }
        String username = jid.getNode();
        String data = message.getBody();
        JSONObject json = JSON.parseObject((String)data);
        String pushCotent = null;
        if (json.containsKey((Object)"pushCotent")) {
            pushCotent = json.getString("pushCotent");
        }
        if (json.getString("objectName") == null) {
            Log.warn("msg json have no objectName, no push, to jid:{}, msgid:{}", (Object)message.getTo().toString(), (Object)message.getID());
            return;
        }
        if (!PushMessageInitUtil.pushTypes.containsKey(json.getString("objectName")) && pushCotent == null) {
            Log.warn("unknown push type or push content is empty, no push, to jid:{}, msgid:{}", (Object)message.getTo().toString(), (Object)message.getID());
            return;
        }
        MsgPushUtil msgPushUtil = new MsgPushUtil();
        if (msgPushUtil.checkUserPush(username)) {
            Log.info("no need Push by user set. username :{}", (Object)username);
            return;
        }
        String secretGroupType = "0";
        String targetType = "1";
        String targetId = message.getFrom().getNode();
        if (message.getFrom().getDomain().startsWith("group.")) {
            targetType = "2";
            targetId = message.getFrom().getResource();
            try {
                Group group = this.groupManager.getGroup(targetId);
                secretGroupType = (String)group.getProperties().getOrDefault((Object)"secretGroupType", (Object)"0");
            }
            catch (GroupNotFoundException e) {
                Log.error("secretGroupType,group not found:{}", (Object)targetId);
            }
        }
        boolean isIMMsg = false;
        String fromNode = message.getFrom().getNode();
        String fromUserId = null;
        if ("1".equals(targetType) && targetId.contains("|")) {
            fromUserId = JIDUtil.conNodeToID(fromNode);
        }
        if ("1".equals(targetType) && this.isNumber(fromUserId)) {
            List targetIds = NoMsgDatabaseUtil.getNoMsgTargetId((String)fromUserId);
            String tarId = JIDUtil.conNodeToID(jid.getNode());
            if (targetIds != null && (targetIds.contains("-1") || targetIds.contains(tarId))) {
                Log.warn("user \uff1a{}  \u4e0d\u63a5\u6536 \uff1a {} \u7684\u6d88\u606f ", (Object)tarId, (Object)fromUserId);
                return;
            }
        }
        if (this.isNumber(fromUserId) || "2".equals(targetType)) {
            isIMMsg = true;
        }
        if (JiveGlobals.getBooleanProperty((String)"xmpp.close.mobile", (boolean)false) && isIMMsg) {
            Log.info("pushMessage,mobile msg is close,no push immsg to mobile ,fromNode:{},toNode :{} ", (Object)fromUserId, (Object)username);
            return;
        }
        DatabaseUtil dbU = new DatabaseUtil();
        String pushvalue = dbU.getPushSetting(targetId, targetType, username);
        if (pushvalue.equals("1")) {
            Log.info("push pushvalue is 1, no push, to jid:{}, msgid:{}", (Object)jid.toString(), (Object)message.getID());
            if ("2".equals(targetType)) {
                String isAt = this.msgAtUtil(json, username);
                if ("0".equals(isAt)) {
                    return;
                }
            } else {
                return;
            }
        }
        if ("1".equals(targetType) && targetId.contains("|")) {
            targetId = JIDUtil.conNodeToID(targetId);
        }
        if (json != null && json.containsKey((Object)"no_push") && "1".equals(no_push = json.getString("no_push"))) {
            Log.info("message no_push type is 1. message not need to push.tojid:{},msgid:{}", (Object)jid.toString(), (Object)message.getID());
            return;
        }
        if (pushCotent == null) {
            if ("FW:CMDMsg".equals(json.getString("objectName"))) {
                targetId = ServerInfo.SYSTEM_UDID.toLowerCase() + "|ding";
                pushCotent = this.getPushContentFormFWCMDMSG(message.getFrom(), json, pd.getLanguage(), message.getTo());
            } else {
                pushCotent = this.getPushContent(message.getFrom(), json, pd.getLanguage());
            }
        }
        if (pushCotent == null || pushCotent.isEmpty()) {
            Log.warn("pushContent is null.from:{},to:{},json:{}", new Object[]{message.getFrom(), message.getTo(), json});
            return;
        }
        String isUserUnifiedPush = JiveGlobals.getProperty((String)"isUserUnifiedPush", (String)"false");
        String isUserUnifiedPushValue = JiveGlobals.getProperty((String)"isUserUnifiedPushValue", (String)LanguageUtil.getInstance().getLanguage(pd.getLanguage(), "push.message.content"));
        if ("true".equals(isUserUnifiedPush)) {
            pushCotent = MessageFormat.format(isUserUnifiedPushValue, this.pushBefore);
        } else if ("1".equals(isUserUnifiedPush)) {
            if (!isIMMsg) {
                pushCotent = MessageFormat.format(isUserUnifiedPushValue, this.pushBefore);
            }
        } else if ("2".equals(isUserUnifiedPush) && isIMMsg) {
            pushCotent = MessageFormat.format(isUserUnifiedPushValue, this.pushBefore);
        }
        String msg_id = null;
        if (json.containsKey((Object)"extra") && (extraJson = JSON.parseObject((String)(extraStr = json.getString("extra")))) != null && extraJson.containsKey((Object)"msg_id")) {
            msg_id = extraJson.getString("msg_id");
        }
        if (PushMessageInitUtil.isUserAnyOffice) {
            AnyofficeService anyOfficeServer = AnyofficeService.getInstance();
            try {
                anyOfficeServer.sendMsg(pushCotent, username);
            }
            catch (Exception e) {
                Log.error("sendMessage to MQTTServer error:message:{}", (Object)message.toString());
                return;
            }
            return;
        }
        if (pushCotent == null || pushCotent.isEmpty()) {
            Log.info("pushContent is null .message :{} ", (Object)message.toString());
            return;
        }
        String push_link = null;
        if (json.containsKey((Object)"push_link")) {
            push_link = json.getString("push_link");
        }
        String lang = pd.getLanguage();
        String title = null;
        if (JiveGlobals.getBooleanProperty((String)"notice_info", (boolean)false)) {
            title = this.getTitle(message.getFrom().getNode());
        }
        int msgSubType = 1;
        if ("2".equals(targetType)) {
            msgSubType = this.isAtMsg(json, username);
        }
        if (pushToWX) {
            try {
                String userId = this.userManager.getUser(message.getTo().getNode()).getEmail();
                MessagePushYYUtil.msgPush(userId);
                return;
            }
            catch (Exception e) {
                Log.error("MessagePushYYUtil,error:{},e:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        try {
            if ("101".equals(pd.getType())) {
                PushMessageToWeAPPJpushUtil.pushMessageToIos(pd.getType(), pd.getPackageName(), pd.getToken(), title, pushCotent, "9dcb0b7def279f5b2b89d91f", "40d9802cd6e57c17780e9f69", targetType, targetId, secretGroupType, push_link, zh_name, false, isIMMsg, null, msgSubType);
            } else if ("103".equals(pd.getType())) {
                if (title == null || title.isEmpty()) {
                    title = "EMobile7";
                }
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                weAppPushUtil.pushMessageToJPushAndroid(pd.getPackageName(), pd.getToken(), title, pushCotent, targetType, targetId, push_link, "f3f6b85f6261ed0b4e2c74ad", "71f209810b4dc534109c7147", zh_name, isIMMsg, msgSubType);
            } else if ("105".equals(pd.getType())) {
                if (title == null || title.isEmpty()) {
                    title = "EMobile7";
                }
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                if ("0".equals(pd.getMobileVersion())) {
                    weAppPushUtil.pushMessageToHarmonyOS(pd.getPackageName(), pd.getToken(), targetType, targetId, push_link, title, pushCotent, zh_name, isIMMsg, msgSubType);
                } else {
                    weAppPushUtil.pushMessageToHuawei(pd.getPackageName(), pd.getToken(), targetType, targetId, push_link, title, pushCotent, "weaver.fw.com.WelcomeActivity", zh_name, isIMMsg, msgSubType);
                }
            } else if ("104".equals(pd.getType())) {
                if (title == null || title.isEmpty()) {
                    title = "EMobile7";
                }
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                weAppPushUtil.pushMessageToXiaoMi(pd.getPackageName(), pd.getToken(), targetType, targetId, push_link, title, pushCotent, zh_name, isIMMsg, msgSubType);
            } else if ("106".equals(pd.getType())) {
                if (title == null || title.isEmpty()) {
                    title = "EM7\u5185\u6d4b\u7248";
                }
                PushMessageToWeAPPJpushUtil.pushMessageToIos(pd.getType(), pd.getPackageName(), pd.getToken(), title, pushCotent, "08e193076a0d41aa3d350ab3", "35348f37697702a425cde3ec", targetType, targetId, secretGroupType, push_link, zh_name, false, isIMMsg, null, msgSubType);
            } else if ("110".equals(pd.getType())) {
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                PushDbUtil db = new PushDbUtil();
                int badge = db.getBadgeByUserId(message.getTo().getNode());
                weAppPushUtil.pushMessageToApns(pd.getPackageName(), pd.getToken(), targetType, targetId, push_link, title, pushCotent, badge, secretGroupType, "default", false, null, zh_name, isIMMsg, null, msgSubType);
            } else if ("112".equals(pd.getType())) {
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                weAppPushUtil.pushMessageToFireBase(pd.getPackageName(), title, pushCotent, pd.getToken(), zh_name, targetId, isIMMsg, msgSubType);
            } else if ("113".equals(pd.getType())) {
                if (title == null || title.isEmpty()) {
                    title = "EMobile7";
                }
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                weAppPushUtil.pushMessageToViVo(pd.getPackageName(), pd.getToken(), targetType, targetId, push_link, title, pushCotent, zh_name, isIMMsg, msgSubType);
            } else if ("121".equals(pd.getType())) {
                if (title == null || title.isEmpty()) {
                    title = "EMobile7";
                }
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                weAppPushUtil.pushMessageToViVo(pd.getPackageName(), pd.getToken(), targetType, targetId, push_link, title, pushCotent, zh_name, isIMMsg, msgSubType);
            } else if ("114".equals(pd.getType())) {
                if (title == null || title.isEmpty()) {
                    title = "EMobile7";
                }
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                weAppPushUtil.pushMessageToOppo(pd.getPackageName(), pd.getToken(), targetType, targetId, push_link, title, pushCotent, zh_name, isIMMsg, msgSubType);
            } else if ("122".equals(pd.getType())) {
                if (title == null || title.isEmpty()) {
                    title = "EMobile7";
                }
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                weAppPushUtil.pushMessageToOppo(pd.getPackageName(), pd.getToken(), targetType, targetId, push_link, title, pushCotent, zh_name, isIMMsg, msgSubType);
            } else if ("116".equals(pd.getType())) {
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                PushDbUtil db = new PushDbUtil();
                if (title == null || title.isEmpty()) {
                    title = "EM7\u5185\u6d4b\u7248";
                }
                int badge = db.getBadgeByUserId(message.getTo().getNode());
                weAppPushUtil.pushMessageToApns("com.tanhas.emobile7", pd.getToken(), targetType, targetId, push_link, title, pushCotent, badge, secretGroupType, "default", false, "4", zh_name, isIMMsg, null, msgSubType);
            } else if ("117".equals(pd.getType())) {
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                if (title == null || title.isEmpty()) {
                    title = "EMobile7";
                }
                weAppPushUtil.pushMessageToHonor(pd.getPackageName(), pd.getToken(), isIMMsg, title, pushCotent, "weaver.fw.com.WelcomeActivity", zh_name, targetType, targetId, push_link, msgSubType);
            } else if ("118".equals(pd.getType())) {
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                if (title == null || title.isEmpty()) {
                    title = "EMobile7";
                }
                weAppPushUtil.pushMessageToHarmonyOS(pd.getPackageName(), pd.getToken(), targetType, targetId, push_link, title, pushCotent, zh_name, isIMMsg, msgSubType);
            } else if ("111".equals(pd.getType())) {
                String packageName = pd.getPackageName();
                if (packageName == null || packageName.isEmpty() || packageName.length() < 4) {
                    packageName = "com.weaver.emobile7";
                }
                WeAppPushUtil weAppPushUtil = WeAppPushUtil.getInstance();
                PushDbUtil db = new PushDbUtil();
                int badge = db.getBadgeByUserId(message.getTo().getNode());
                weAppPushUtil.pushMessageToApns(packageName, pd.getToken(), targetType, targetId, push_link, title, pushCotent, badge, secretGroupType, "default", false, "5", zh_name, isIMMsg, null, msgSubType);
            } else if ("201".equals(pd.getType()) || "202".equals(pd.getType()) || "203".equals(pd.getType()) || "204".equals(pd.getType()) || "205".equals(pd.getType()) || "206".equals(pd.getType()) || "207".equals(pd.getType()) || "208".equals(pd.getType())) {
                PushMessageWithPackage.pushMessageWithPackage(pd.getType(), pd.getPackageName(), pushCotent, pd.getToken(), targetType, targetId, push_link, zh_name, title, isIMMsg, msgSubType, pd.getMobileVersion());
            } else if ("301".equals(pd.getType()) || "302".equals(pd.getType())) {
                PushMessageForGePush.pushMessageToGePush(pushCotent, pd.getToken(), pd.getType());
            } else if ("401".equals(pd.getType()) || "402".equals(pd.getType())) {
                PushMessageForBingoJpush.pushMessageForBingoJPush(pushCotent, pd.getToken(), pd.getType());
            } else if ("501".equals(pd.getType()) || "502".equals(pd.getType())) {
                TaibaoPushUtil.pushMessageUtil(pushCotent, this.getRealUserId(jid.getNode()), targetId, targetType, push_link, pd.getType());
            } else if ("601".equals(pd.getType())) {
                ZDBankPushUtil.pushMessage(message.getTo().getNode(), pushCotent, isIMMsg);
            } else if ("701".equals(pd.getType()) || "702".equals(pd.getType()) || "703".equals(pd.getType()) || "704".equals(pd.getType()) || "705".equals(pd.getType()) || "706".equals(pd.getType()) || "707".equals(pd.getType())) {
                PushDbUtil db = new PushDbUtil();
                int badge = db.getBadgeByUserId(message.getTo().getNode());
                MPaaSPushUtil.pushMessageToMPaas(pd.getType(), pd.getToken(), pushCotent, targetType, targetId, push_link, badge);
            } else {
                Log.warn("all pass ,jid is: {}, pushdevice type is: {}", (Object)message.getTo(), (Object)pd.getType());
            }
        }
        catch (Exception e) {
            Log.error("push failed, unknown exception, to jid:{}, msgid:{}, err:{}", new Object[]{jid.toString(), message.getID(), e.getMessage()});
        }
    }

    private boolean isNumber(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        boolean result = str.matches("[0-9]+");
        return result;
    }

    private String getRealUserId(String imUserId) {
        String result = null;
        result = imUserId != null && !imUserId.isEmpty() && imUserId.indexOf("|") > 0 ? imUserId.substring(0, imUserId.indexOf("|")) : imUserId;
        return result;
    }

    private String getTitle(String fromJid) {
        if (fromJid != null && (fromJid.startsWith("a_") || fromJid.startsWith("s_"))) {
            return JiveGlobals.getProperty((String)"sysnotice_info");
        }
        return JiveGlobals.getProperty((String)"msgnotice_info");
    }

    private int isAtMsg(JSONObject json, String username) {
        String userId = this.getUserIDByUsername(username);
        try {
            String extra;
            JSONObject extraJ;
            String msg_at_userid = null;
            if (json != null && json.containsKey((Object)"extra") && (extraJ = JSONObject.parseObject((String)(extra = json.getString("extra")))) != null && extraJ.containsKey((Object)"msg_at_userid")) {
                msg_at_userid = extraJ.getString("msg_at_userid");
            }
            if (msg_at_userid == null || msg_at_userid.isEmpty()) {
                return 1;
            }
            if ("msg_at_all".equals(msg_at_userid)) {
                return 2;
            }
            String[] msgAtStr = msg_at_userid.split(",");
            for (int i = 0; i < msgAtStr.length; ++i) {
                String s = msgAtStr[i];
                if (s == null || !s.equals(userId)) continue;
                return 2;
            }
        }
        catch (Exception e) {
            Log.error("msgAtUtil ,userId:{},json:{},error:{},{}", new Object[]{userId, json, e.getMessage(), e});
        }
        return 3;
    }

    private String msgAtUtil(JSONObject json, String username) {
        String userId = this.getUserIDByUsername(username);
        try {
            String extra;
            JSONObject extraJ;
            String msg_at_userid = null;
            if (json != null && json.containsKey((Object)"extra") && (extraJ = JSONObject.parseObject((String)(extra = json.getString("extra")))) != null && extraJ.containsKey((Object)"msg_at_userid")) {
                msg_at_userid = extraJ.getString("msg_at_userid");
            }
            if (msg_at_userid == null || msg_at_userid.isEmpty()) {
                return "0";
            }
            if ("msg_at_all".equals(msg_at_userid)) {
                return "1";
            }
            String[] msgAtStr = msg_at_userid.split(",");
            for (int i = 0; i < msgAtStr.length; ++i) {
                String s = msgAtStr[i];
                if (s == null || !s.equals(userId)) continue;
                return "1";
            }
        }
        catch (Exception e) {
            Log.error("msgAtUtil ,userId:{},json:{},error:{},{}", new Object[]{userId, json, e.getMessage(), e});
        }
        return "0";
    }

    private String getUserIDByUsername(String username) {
        if (username.contains("|")) {
            int index = username.indexOf("|");
            return username.substring(0, index);
        }
        return username;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getPushContentFormFWCMDMSG(JID fromJID, JSONObject json, String language, JID toJID) {
        String pushContent = null;
        String dingContent = null;
        String content = null;
        if (fromJID.getDomain().startsWith("group.")) {
            String groupId = fromJID.getResource();
            try {
                Group group = this.groupManager.getGroup(groupId);
                String secretGroupType = (String)group.getProperties().getOrDefault((Object)"secretGroupType", (Object)"0");
                if ("1".equals(secretGroupType)) return LanguageUtil.getInstance().getLanguage(language, "receive.a.message");
                if ("2".equals(secretGroupType)) {
                    return LanguageUtil.getInstance().getLanguage(language, "receive.a.message");
                }
            }
            catch (GroupNotFoundException e) {
                Log.error("getPushContentFormFWCMDMSG,group not found:{}", (Object)groupId);
            }
        }
        if (json != null && json.containsKey((Object)"content")) {
            content = json.getString("content");
        }
        try {
            String pushContentBefore;
            if (content == null) return null;
            if (content.isEmpty()) {
                return null;
            }
            UserManager userManager = UserManager.getInstance();
            User user = userManager.getUser(fromJID.getNode());
            this.pushBefore = pushContentBefore = LanguageUtil.getInstance().getLanguage(language, "push.notice.ding");
            JSONObject jsonContent = JSON.parseObject((String)content);
            if (jsonContent == null) return null;
            if (!jsonContent.containsKey((Object)"para")) return null;
            String para = jsonContent.getString("para");
            if (para == null) return null;
            if (para.isEmpty()) {
                return null;
            }
            JSONObject jsonPara = JSON.parseObject((String)para);
            if (jsonPara == null) return null;
            if (!jsonPara.containsKey((Object)"ding")) return null;
            String ding = jsonPara.getString("ding");
            JSONObject jsonDing = JSON.parseObject((String)ding);
            String msgcontent = null;
            String sendid = null;
            if (jsonDing == null) return null;
            if (!jsonDing.containsKey((Object)"content")) return null;
            msgcontent = jsonDing.getString("content");
            if (msgcontent == null) return null;
            if (msgcontent.isEmpty()) {
                return null;
            }
            if (jsonDing != null && jsonDing.containsKey((Object)"sendid")) {
                sendid = jsonDing.getString("sendid");
            }
            if (sendid != null && !sendid.isEmpty()) {
                if (sendid.equals(this.getUserIDByUsername(toJID.getNode()))) {
                    Log.info("ding message not push to sender .fromJID :{} ,json :{} ", (Object)fromJID, (Object)json);
                    return null;
                }
                dingContent = MultilingualUtil.formatMultiLang(userManager.getUser((sendid + "|" + ServerInfo.SYSTEM_UDID).toLowerCase()).getName(), language) + ":" + msgcontent;
            } else {
                dingContent = msgcontent;
            }
            pushContent = pushContentBefore + ":" + dingContent;
        }
        catch (Exception e) {
            Log.error("getPushContentFormFWCMDMSG.fromJID:{},json:{},error:{}", new Object[]{fromJID, json, e.getMessage()});
            return null;
        }
        int maxPushContent = JiveGlobals.getIntProperty((String)"maxPushContent", (int)50);
        if (maxPushContent > JiveGlobals.getIntProperty((String)"maxServerAllowedPushContent", (int)300)) {
            maxPushContent = JiveGlobals.getIntProperty((String)"maxServerAllowedPushContent", (int)300);
        }
        if (pushContent == null) return pushContent;
        if (pushContent.length() <= maxPushContent) return pushContent;
        pushContent = pushContent.substring(0, maxPushContent);
        return pushContent + "...";
    }

    private String getEmailPushName() {
        if (emailPushName == null) {
            emailPushName = this.getUDID() + "|mails";
        }
        return emailPushName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String getUDID() {
        block6: {
            block5: {
                con = null;
                pstmt = null;
                rs = null;
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("select * from mobileProperty where name ='rongAppUDIDNew'");
                rs = pstmt.executeQuery();
                if (!rs.next()) ** GOTO lbl17
                propvalue = rs.getString("propvalue");
                if (propvalue == null) break block5;
                var5_7 = propvalue;
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
                return var5_7;
            }
            try {
                break block6;
lbl17:
                // 1 sources

                DbConnectionManager.closeStatement((Statement)pstmt);
                UDID = UDIDUtil.getRandomLowercase(6);
                pstmt = con.prepareStatement("insert into mobileProperty (name,propValue) values (?,?)");
                pstmt.setString(1, "rongAppUDIDNew");
                pstmt.setString(2, UDID);
                pstmt.execute();
                var5_8 = UDID;
            }
            catch (Exception e) {
                try {
                    PushMessageUtil.Log.error("getUDID,error:{}", (Object)e.getMessage());
                }
                catch (Throwable var6_9) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw var6_9;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return var5_8;
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return "";
    }

    private boolean checkMsgIsWorkFlaw(JSONObject json) {
        String shareType;
        String extrastr;
        JSONObject extra;
        String objectName = json.getString("objectName");
        return objectName.equals("FW:CustomShareMsg") && (extra = JSON.parseObject((String)(extrastr = json.getString("extra")))) != null && extra.containsKey((Object)"sharetype") && "workflow".equals(shareType = extra.getString("sharetype"));
    }

    public String getPushContent(JID fromJID, JSONObject json, String language) {
        String pushContent;
        block40: {
            pushContent = "";
            String pushBeforeText = "";
            String content = "";
            try {
                String extrastr;
                JSONObject extra;
                User user = this.userManager.getUser(fromJID.getNode());
                if (user == null) {
                    return null;
                }
                String name = user.getName();
                pushBeforeText = MultilingualUtil.formatMultiLang(name, language);
                if (fromJID.getDomain().startsWith("group.")) {
                    String groupId = fromJID.getResource();
                    try {
                        Group group = this.groupManager.getGroup(groupId);
                        String secretGroupType = (String)group.getProperties().getOrDefault((Object)"secretGroupType", (Object)"0");
                        if ("1".equals(secretGroupType) || "2".equals(secretGroupType)) {
                            return LanguageUtil.getInstance().getLanguage(language, "receive.a.message");
                        }
                        pushBeforeText = pushBeforeText + "(" + group.getDescription() + ")";
                    }
                    catch (GroupNotFoundException e) {
                        Log.error("getPushContent,group not found:{}", (Object)groupId);
                    }
                }
                if (!pushBeforeText.isEmpty()) {
                    this.pushBefore = pushBeforeText;
                    pushBeforeText = pushBeforeText + ":";
                }
                String objectName = json.getString("objectName");
                if (!fromJID.getNode().startsWith("a_") && !fromJID.getNode().startsWith("s_")) {
                    if (objectName.equals("RC:TxtMsg")) {
                        content = json.getString("content");
                    }
                    if (objectName.equals("RC:VcMsg")) {
                        content = LanguageUtil.getInstance().getLanguage(language, "push.notice.Vc");
                    }
                    if (objectName.equals("RC:LBSMsg")) {
                        content = LanguageUtil.getInstance().getLanguage(language, "push.notice.lbs");
                    }
                    if (objectName.equals("RC:ImgMsg")) {
                        content = LanguageUtil.getInstance().getLanguage(language, "push.notice.img");
                    }
                    if (objectName.equals("FW:UniteMsg")) {
                        content = LanguageUtil.getInstance().getLanguage(language, "push.notice.uniteMsg");
                    }
                    if ("RC:ExpMsg".equals(objectName)) {
                        content = LanguageUtil.getInstance().getLanguage(language, "push.notice.ExpMsg");
                    }
                    if ("FW:VoIPMsg".equals(objectName)) {
                        // empty if block
                    }
                    if (objectName.equals("FW:CustomMsg") && (extra = JSON.parseObject((String)(extrastr = json.getString("extra")))).getString("pushType").equals("weaver_shakeMsg")) {
                        content = LanguageUtil.getInstance().getLanguage(language, "push.notice.shake");
                    }
                    if (objectName.equals("FW:richTextMsg")) {
                        content = LanguageUtil.getInstance().getLanguage(language, "push.notice.richText");
                    }
                    if (objectName.equals("FW:attachmentMsg")) {
                        content = LanguageUtil.getInstance().getLanguage(language, "push.notice.attachment");
                    }
                    if (objectName.equals("FW:CustomShareMsg") || objectName.equals("FW:CustomShareMsgVote")) {
                        extrastr = json.getString("extra");
                        extra = JSON.parseObject((String)extrastr);
                        String sharetypename = null;
                        String shareType = null;
                        if (extra != null && extra.containsKey((Object)"sharetypename")) {
                            sharetypename = extra.getString("sharetypename");
                        }
                        if (sharetypename == null || sharetypename.isEmpty()) {
                            if (extra != null && extra.containsKey((Object)"sharetype")) {
                                shareType = extra.getString("sharetype");
                            }
                            content = "workflow".equals(shareType) ? LanguageUtil.getInstance().getLanguage(language, "push.notice.shareWorkflow") + json.getString("content") : ("doc".equals(shareType) ? LanguageUtil.getInstance().getLanguage(language, "push.notice.shareDoc") + json.getString("content") : ("voting".equals(shareType) ? LanguageUtil.getInstance().getLanguage(language, "push.notice.sharetypevote") + json.getString("content") : ("crm".equals(shareType) ? LanguageUtil.getInstance().getLanguage(language, "push.notice.crm") + json.getString("content") : ("meeting".equals(shareType) ? LanguageUtil.getInstance().getLanguage(language, "push.notice.meeting") + json.getString("content") : ("workplan".equals(shareType) ? LanguageUtil.getInstance().getLanguage(language, "push.notice.workplan") + json.getString("content") : json.getString("content"))))));
                        } else {
                            content = "[" + sharetypename + "]" + json.getString("content");
                        }
                    }
                    if (objectName.equals("RC:PublicNoticeMsg")) {
                        content = LanguageUtil.getInstance().getLanguage(language, "push.notice.PublicNotice");
                    }
                    if (objectName.equals("FW:PersonCardMsg")) {
                        content = LanguageUtil.getInstance().getLanguage(language, "push.notice.PersonCard") + json.getString("content");
                    }
                    pushContent = pushBeforeText + content;
                } else {
                    content = json.getString("content");
                    if (content != null && content.length() > 100) {
                        content = content.substring(0, 100);
                    }
                    if (objectName.equals("RC:VcMsg")) {
                        content = LocaleUtils.getLocalizedString((String)"push.notice.Vc", (String)"multirouter");
                    }
                    if (objectName.equals("RC:LBSMsg")) {
                        content = LocaleUtils.getLocalizedString((String)"push.notice.lbs", (String)"multirouter");
                    }
                    if (objectName.equals("FW:UniteMsg")) {
                        content = LocaleUtils.getLocalizedString((String)"push.notice.uniteMsg", (String)"multirouter");
                    }
                    if (objectName.equals("RC:ImgMsg")) {
                        content = LocaleUtils.getLocalizedString((String)"push.notice.img", (String)"multirouter");
                    }
                    if ("RC:ExpMsg".equals(objectName)) {
                        content = LocaleUtils.getLocalizedString((String)"push.notice.ExpMsg", (String)"multirouter");
                    }
                    if (objectName.equals("FW:CustomMsg") && (extra = JSON.parseObject((String)(extrastr = json.getString("extra")))).getString("pushType").equals("weaver_shakeMsg")) {
                        content = LocaleUtils.getLocalizedString((String)"push.notice.shake", (String)"multirouter");
                    }
                    if (objectName.equals("FW:richTextMsg")) {
                        content = LocaleUtils.getLocalizedString((String)"push.notice.richText", (String)"multirouter") + json.getString("content");
                    }
                    if (objectName.equals("FW:attachmentMsg")) {
                        content = LocaleUtils.getLocalizedString((String)"push.notice.attachment", (String)"multirouter");
                    }
                    if (objectName.equals("RC:PublicNoticeMsg")) {
                        content = LocaleUtils.getLocalizedString((String)"push.notice.PublicNotice", (String)"multirouter");
                    }
                    if (objectName.equals("FW:PersonCardMsg")) {
                        content = LocaleUtils.getLocalizedString((String)"push.notice.PersonCard", (String)"multirouter") + json.getString("content") + "]";
                    }
                    pushContent = pushBeforeText + content;
                }
            }
            catch (UserNotFoundException e) {
                String objectName;
                Log.warn("getPushContent,user not found,user:{}", (Object)fromJID.getNode());
                if (json == null || !json.containsKey((Object)"objectName") || !(objectName = json.getString("objectName")).equals("RC:TxtMsg")) break block40;
                pushContent = json.getString("content");
            }
        }
        int maxPushContent = JiveGlobals.getIntProperty((String)"maxPushContent", (int)50);
        if (maxPushContent > JiveGlobals.getIntProperty((String)"maxServerAllowedPushContent", (int)300)) {
            maxPushContent = JiveGlobals.getIntProperty((String)"maxServerAllowedPushContent", (int)300);
        }
        if (pushContent != null && pushContent.length() > maxPushContent) {
            pushContent = pushContent.substring(0, maxPushContent);
            pushContent = pushContent + "...";
        }
        return pushContent;
    }
}

