/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weaver.util.ThreadPoolFactory;
import com.weaver.util.ThreadPrefix;
import com.weaver.util.ThreadUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.plugin.MultiRouterPlugin;
import org.jivesoftware.openfire.plugin.bean.PushDevice;
import org.jivesoftware.openfire.plugin.push.PushDbUtil;
import org.jivesoftware.openfire.plugin.push.PushMessageThread;
import org.jivesoftware.openfire.plugin.util.ConversationUserUtil;
import org.jivesoftware.openfire.plugin.util.MultilingualUtil;
import org.jivesoftware.openfire.plugin.util.PushMessageInitUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class PushUtil {
    private static final Logger Log = LoggerFactory.getLogger(PushUtil.class);
    private UserManager userManager;
    private GroupManager groupManager;

    public PushUtil(UserManager userManager) {
        this.userManager = userManager;
    }

    public PushUtil(UserManager userManager, GroupManager groupManager) {
        this.userManager = userManager;
        this.groupManager = groupManager;
    }

    public void pushMessage(Message message) {
        boolean pushSet = JiveGlobals.getBooleanProperty((String)"pushSet");
        if (pushSet) {
            return;
        }
        if (!PushMessageInitUtil.isPushMessageThreadRunning) {
            return;
        }
        if (!ThreadUtil.checkThreadByName((String)ThreadPrefix.PUSH_THREAD.toString())) {
            this.openPushThread();
        }
        if (MultiRouterPlugin.pushMessage == null || MultiRouterPlugin.pushMessage.size() >= JiveGlobals.getIntProperty((String)"pushMessageQueueLength", (int)10000)) {
            Log.warn("pushMessageQueueLength to more ,message :{}", (Object)message.getID());
            return;
        }
        MultiRouterPlugin.pushMessage.add(message);
    }

    private void openPushThread() {
        ExecutorService fixedThreadPool = ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool();
        for (int i = 0; i < JiveGlobals.getIntProperty((String)"pushMessageThreadCount", (int)40); ++i) {
            fixedThreadPool.execute(new PushMessageThread(ThreadPrefix.PUSH_THREAD.toString() + i + "-" + this.getClass().getSimpleName()));
        }
    }

    public Map<String, String> getPushContent(JID fromJID, JSONObject json, String targetType) {
        String extra;
        JSONObject extraJ;
        String pushContent = "";
        PushDbUtil db = new PushDbUtil();
        PushDevice pd = null;
        pd = JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false) ? db.getRegisterPush(fromJID, fromJID.getResource()) : db.getRegisterPush(fromJID);
        String objectName = json.getString("objectName");
        String msgContent = json.getString("content");
        HashMap<String, String> result = new HashMap<String, String>();
        String sharetypename = null;
        String shareType = null;
        boolean isNeedpushBeforeText = ConversationUserUtil.isNeedUserName(targetType);
        try {
            String extrastr;
            JSONObject extra2;
            String content;
            String name;
            User user = this.userManager.getUser(fromJID.getNode());
            if (user == null) {
                return null;
            }
            String pushBeforeText = name = user.getName();
            String language = null;
            if (pd != null) {
                language = pd.getLanguage();
            }
            pushBeforeText = MultilingualUtil.formatMultiLang(name, language);
            if (objectName.equals("RC:TxtMsg")) {
                content = json.getString("content");
                if (content != null && content.length() > 100) {
                    content = content.substring(0, 100);
                }
                pushContent = isNeedpushBeforeText ? pushBeforeText + ":" + content : content;
            }
            if (objectName.equals("RC:VcMsg")) {
                pushContent = isNeedpushBeforeText ? pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.Vc", (String)"multirouter") : LocaleUtils.getLocalizedString((String)"push.notice.Vc", (String)"multirouter");
                msgContent = LocaleUtils.getLocalizedString((String)"push.notice.Vc", (String)"multirouter");
            }
            if (objectName.equals("RC:LBSMsg")) {
                pushContent = isNeedpushBeforeText ? pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.lbs", (String)"multirouter") : LocaleUtils.getLocalizedString((String)"push.notice.lbs", (String)"multirouter");
                msgContent = LocaleUtils.getLocalizedString((String)"push.notice.lbs", (String)"multirouter");
            }
            if (objectName.equals("FW:UniteMsg")) {
                pushContent = isNeedpushBeforeText ? pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.uniteMsg", (String)"multirouter") : LocaleUtils.getLocalizedString((String)"push.notice.uniteMsg", (String)"multirouter");
                msgContent = LocaleUtils.getLocalizedString((String)"push.notice.uniteMsg", (String)"multirouter");
            }
            if ("RC:ExpMsg".equals(objectName)) {
                pushContent = isNeedpushBeforeText ? pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.ExpMsg", (String)"multirouter") : LocaleUtils.getLocalizedString((String)"push.notice.ExpMsg", (String)"multirouter");
                msgContent = LocaleUtils.getLocalizedString((String)"push.notice.ExpMsg", (String)"multirouter");
            }
            if ("FW:CMDNtf".equals(objectName)) {
                pushContent = pushBeforeText + LocaleUtils.getLocalizedString((String)"push.confirm.ding", (String)"multirouter");
                msgContent = LocaleUtils.getLocalizedString((String)"push.confirm.ding", (String)"multirouter");
            }
            if (objectName.equals("RC:ImgMsg")) {
                pushContent = isNeedpushBeforeText ? pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.img", (String)"multirouter") : LocaleUtils.getLocalizedString((String)"push.notice.img", (String)"multirouter");
                msgContent = LocaleUtils.getLocalizedString((String)"push.notice.img", (String)"multirouter");
            }
            if (objectName.equals("FW:CustomMsg") && (extra2 = JSON.parseObject((String)(extrastr = json.getString("extra")))).getString("pushType").equals("weaver_shakeMsg")) {
                pushContent = isNeedpushBeforeText ? pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.shake", (String)"multirouter") : LocaleUtils.getLocalizedString((String)"push.notice.shake", (String)"multirouter");
                msgContent = LocaleUtils.getLocalizedString((String)"push.notice.shake", (String)"multirouter");
            }
            if (objectName.equals("FW:richTextMsg")) {
                pushContent = isNeedpushBeforeText ? pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.richText", (String)"multirouter") + json.getString("content") : LocaleUtils.getLocalizedString((String)"push.notice.richText", (String)"multirouter") + json.getString("content");
                msgContent = json.getString("content");
            }
            if (objectName.equals("FW:attachmentMsg")) {
                pushContent = isNeedpushBeforeText ? pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.attachment", (String)"multirouter") + json.getString("content") : LocaleUtils.getLocalizedString((String)"push.notice.attachment", (String)"multirouter") + json.getString("content");
                msgContent = json.getString("content");
            }
            if (objectName.equals("FW:CustomShareMsg") || objectName.equals("FW:CustomShareMsgVote")) {
                extrastr = json.getString("extra");
                extra2 = JSON.parseObject((String)extrastr);
                if (extra2 != null && extra2.containsKey((Object)"sharetypename")) {
                    sharetypename = extra2.getString("sharetypename");
                }
                if (extra2 != null && extra2.containsKey((Object)"sharetype")) {
                    shareType = extra2.getString("sharetype");
                }
                pushContent = sharetypename == null || sharetypename.isEmpty() ? ("workflow".equals(shareType) ? (isNeedpushBeforeText ? pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.shareWorkflow", (String)"multirouter") + json.getString("content") : LocaleUtils.getLocalizedString((String)"push.notice.shareWorkflow", (String)"multirouter") + json.getString("content")) : ("doc".equals(shareType) ? (isNeedpushBeforeText ? pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.shareDoc", (String)"multirouter") + json.getString("content") : LocaleUtils.getLocalizedString((String)"push.notice.shareDoc", (String)"multirouter") + json.getString("content")) : ("voting".equals(shareType) ? (isNeedpushBeforeText ? pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.sharetypevote", (String)"multirouter") + json.getString("content") : LocaleUtils.getLocalizedString((String)"push.notice.sharetypevote", (String)"multirouter") + json.getString("content")) : ("crm".equals(shareType) ? (isNeedpushBeforeText ? pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.crm", (String)"multirouter") + json.getString("content") : LocaleUtils.getLocalizedString((String)"push.notice.crm", (String)"multirouter") + json.getString("content")) : ("meeting".equals(shareType) ? (isNeedpushBeforeText ? pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.meeting", (String)"multirouter") + json.getString("content") : LocaleUtils.getLocalizedString((String)"push.notice.meeting", (String)"multirouter") + json.getString("content")) : ("workplan".equals(shareType) ? (isNeedpushBeforeText ? pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.workplan", (String)"multirouter") + json.getString("content") : LocaleUtils.getLocalizedString((String)"push.notice.workplan", (String)"multirouter") + json.getString("content")) : (isNeedpushBeforeText ? pushBeforeText + ":" + json.getString("content") : json.getString("content")))))))) : (isNeedpushBeforeText ? pushBeforeText + ":" + sharetypename + json.getString("content") : "[" + sharetypename + "]" + json.getString("content"));
            }
            if ("FW:CustomShareNtfMsg".equals(objectName)) {
                pushContent = json.getString("content");
            }
            if ("RC:DizNtf".equals(objectName) || "RC:CommNtf".equals(objectName)) {
                pushContent = json.getString("content");
                msgContent = json.getString("content");
            }
            if ("FW:CMDMsg".equals(objectName)) {
                pushContent = this.getPushContentFormFWCMDMSG(fromJID, json, language);
            }
            if ("FW:VoIPMsg".equals(objectName)) {
                pushContent = isNeedpushBeforeText ? pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.VoIPMsg", (String)"multirouter") + json.getString("content") : LocaleUtils.getLocalizedString((String)"push.notice.VoIPMsg", (String)"multirouter") + json.getString("content");
                msgContent = json.toJSONString();
            }
            if ("FW:Extension_Msg".equals(objectName)) {
                pushContent = isNeedpushBeforeText ? pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.Extension_Msg", (String)"multirouter") : LocaleUtils.getLocalizedString((String)"push.notice.Extension_Msg", (String)"multirouter");
                msgContent = LocaleUtils.getLocalizedString((String)"push.notice.Extension_Msg", (String)"multirouter");
            }
            if (objectName.equals("RC:PublicNoticeMsg")) {
                pushContent = isNeedpushBeforeText ? pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.PublicNotice", (String)"multirouter") + json.getString("content") : LocaleUtils.getLocalizedString((String)"push.notice.PublicNotice", (String)"multirouter") + json.getString("content");
                msgContent = json.getString("content");
            }
            if (objectName.equals("FW:PersonCardMsg")) {
                pushContent = isNeedpushBeforeText ? pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.PersonCard", (String)"multirouter") + json.getString("content") : LocaleUtils.getLocalizedString((String)"push.notice.PersonCard", (String)"multirouter") + json.getString("content");
                msgContent = json.getString("content");
            }
            if (pushContent == "" || pushContent.isEmpty()) {
                content = json.getString("content");
                if (content != null && content.length() > 100) {
                    content = content.substring(0, 100);
                }
                pushContent = isNeedpushBeforeText ? pushBeforeText + ":" + content : content;
            }
            if (fromJID.getNode().startsWith("a_") || fromJID.getNode().startsWith("s_")) {
                String extrastr2;
                JSONObject extra3;
                content = json.getString("content");
                if (content != null && content.length() > 100) {
                    content = content.substring(0, 100);
                }
                if (objectName.equals("RC:VcMsg")) {
                    content = LocaleUtils.getLocalizedString((String)"push.notice.Vc", (String)"multirouter");
                }
                if (objectName.equals("RC:LBSMsg")) {
                    content = LocaleUtils.getLocalizedString((String)"push.notice.lbs", (String)"multirouter");
                }
                if (objectName.equals("FW:UniteMsg")) {
                    content = LocaleUtils.getLocalizedString((String)"push.notice.uniteMsg", (String)"multirouter");
                }
                if (objectName.equals("RC:ImgMsg")) {
                    content = LocaleUtils.getLocalizedString((String)"push.notice.img", (String)"multirouter");
                }
                if ("RC:ExpMsg".equals(objectName)) {
                    content = LocaleUtils.getLocalizedString((String)"push.notice.ExpMsg", (String)"multirouter");
                }
                if (objectName.equals("FW:CustomMsg") && (extra3 = JSON.parseObject((String)(extrastr2 = json.getString("extra")))).getString("pushType").equals("weaver_shakeMsg")) {
                    content = LocaleUtils.getLocalizedString((String)"push.notice.shake", (String)"multirouter");
                }
                if (objectName.equals("FW:richTextMsg")) {
                    content = LocaleUtils.getLocalizedString((String)"push.notice.richText", (String)"multirouter") + json.getString("content");
                }
                if (objectName.equals("FW:attachmentMsg")) {
                    content = LocaleUtils.getLocalizedString((String)"push.notice.attachment", (String)"multirouter");
                }
                if (objectName.equals("RC:PublicNoticeMsg")) {
                    content = LocaleUtils.getLocalizedString((String)"push.notice.PublicNotice", (String)"multirouter");
                }
                if (objectName.equals("FW:PersonCardMsg")) {
                    content = LocaleUtils.getLocalizedString((String)"push.notice.PersonCard", (String)"multirouter") + json.getString("content") + "]";
                }
                pushContent = content;
            }
        }
        catch (UserNotFoundException e) {
            Log.error("getPushContent,user {} not found.,error:{} ", (Object)fromJID.getNode(), (Object)e);
        }
        int maxPushContent = 50;
        if (pushContent != null && pushContent.length() > maxPushContent) {
            pushContent = pushContent.substring(0, maxPushContent);
            pushContent = pushContent + "...";
        }
        if (msgContent != null && msgContent.length() > maxPushContent) {
            msgContent = msgContent.substring(0, maxPushContent);
            msgContent = msgContent + "...";
        }
        result.put("pushContent", pushContent);
        result.put("objectName", objectName);
        result.put("msgContent", msgContent);
        result.put("sharetypename", sharetypename);
        result.put("sharetype", shareType);
        String msg_at_userid = "";
        if (json != null && json.containsKey((Object)"extra") && (extraJ = JSONObject.parseObject((String)(extra = json.getString("extra")))) != null && extraJ.containsKey((Object)"msg_at_userid")) {
            msg_at_userid = extraJ.getString("msg_at_userid");
        }
        result.put("msg_at_userid", msg_at_userid);
        return result;
    }

    private String getPushContentFormFWCMDMSG(JID fromJID, JSONObject json, String language) {
        String pushContent = null;
        String dingContent = null;
        String content = null;
        if (json != null && json.containsKey((Object)"content")) {
            content = json.getString("content");
        }
        try {
            if (content == null || content.isEmpty()) {
                return null;
            }
            JSONObject jsonContent = JSON.parseObject((String)content);
            if (jsonContent != null && jsonContent.containsKey((Object)"para")) {
                String ding;
                JSONObject jsonDing;
                String para = jsonContent.getString("para");
                if (para == null || para.isEmpty()) {
                    return null;
                }
                JSONObject jsonPara = JSON.parseObject((String)para);
                if (jsonPara != null && jsonPara.containsKey((Object)"ding") && (jsonDing = JSON.parseObject((String)(ding = jsonPara.getString("ding")))) != null && jsonDing.containsKey((Object)"displayedContent") && ((dingContent = jsonDing.getString("displayedContent")) == null || dingContent.isEmpty())) {
                    return null;
                }
            }
            pushContent = LocaleUtils.getLocalizedString((String)"push.notice.ding", (String)"multirouter") + ":" + dingContent;
        }
        catch (Exception e) {
            Log.error("getPushContentFormFWCMDMSG.fromJID:{},json:{},error:{}", new Object[]{fromJID, json, e.getMessage()});
            return null;
        }
        if (pushContent != null && pushContent.length() > 100) {
            pushContent = pushContent.substring(0, 100);
        }
        return pushContent;
    }
}

