/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import java.util.Collection;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.roster.Roster;
import org.jivesoftware.openfire.roster.RosterManager;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;
import org.xmpp.packet.Roster;

public class RosterUtil {
    private RosterManager rosterManager = XMPPServer.getInstance().getRosterManager();
    private static final Logger Log = LoggerFactory.getLogger(RosterUtil.class);

    public void buildRoster(JID fromJid, JID toJid) {
        try {
            Presence presence;
            Collection sessions;
            Roster.Item item;
            org.xmpp.packet.Roster rosterpacket;
            if (fromJid.getNode().equals(toJid.getNode())) {
                return;
            }
            Roster roster = this.rosterManager.getRoster(fromJid.getNode());
            try {
                roster.getRosterItem(toJid);
            }
            catch (UserNotFoundException e) {
                rosterpacket = new org.xmpp.packet.Roster();
                item = rosterpacket.addItem(toJid, "", null, Roster.Subscription.both, null);
                roster.createRosterItem(item);
                sessions = XMPPServer.getInstance().getSessionManager().getSessions(fromJid.getNode());
                for (ClientSession clientSession : sessions) {
                    presence = clientSession.getPresence();
                    presence.setTo(toJid.asBareJID());
                    clientSession.process((Packet)presence);
                }
            }
            roster = this.rosterManager.getRoster(toJid.getNode());
            try {
                roster.getRosterItem(fromJid);
            }
            catch (UserNotFoundException e) {
                rosterpacket = new org.xmpp.packet.Roster();
                item = rosterpacket.addItem(fromJid, "", null, Roster.Subscription.both, null);
                roster.createRosterItem(item);
                sessions = XMPPServer.getInstance().getSessionManager().getSessions(toJid.getNode());
                for (ClientSession clientSession : sessions) {
                    presence = clientSession.getPresence();
                    presence.setTo(fromJid.asBareJID());
                    clientSession.process((Packet)presence);
                }
            }
        }
        catch (Exception e) {
            Log.error("buildRoster,fromJid={},toJId={},error={}", new Object[]{fromJid.toString(), toJid.toString(), e.getMessage()});
        }
    }
}

