/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.gexin.fastjson.JSON;
import com.weaver.util.ServerInfo;
import com.weaver.util.cluster.ClusterPropBeanUtil;
import com.weaver.util.cluster.ClusterRedisUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;

public class UpdateSubTitleUtil {
    private static final Logger Log = LoggerFactory.getLogger(UpdateSubTitleUtil.class);

    public static void sendConopMsg(String userid, String targetid, String content, String lasttime) {
        Message msg = UpdateSubTitleUtil.makeMessage(targetid, content, lasttime);
        String username = userid + "|" + ServerInfo.SYSTEM_UDID;
        Collection sessions = SessionManager.getInstance().getSessions(username);
        boolean pcOnline = false;
        boolean padOnline = false;
        boolean mobileOnline = false;
        msg.setFrom(new JID(username, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
        for (ClientSession clientSession : sessions) {
            Message sendMessage = msg.createCopy();
            sendMessage.setTo(clientSession.getAddress());
            clientSession.process((Packet)sendMessage);
            Log.info("UpdateSubTitleUtil,sendConopMsg,sendMsg,to:{},sendMessage:{}", new Object[]{clientSession.getAddress(), msg, sendMessage.toString()});
            if ("pc".equals(clientSession.getAddress().getResource())) {
                pcOnline = true;
            }
            if ("mobile".equals(clientSession.getAddress().getResource())) {
                padOnline = true;
            }
            if (!"pad".equals(clientSession.getAddress().getResource())) continue;
            mobileOnline = true;
        }
        ClusterPropBeanUtil cluster = ClusterPropBeanUtil.getInstance();
        if (cluster.isUseCluster()) {
            JID padJID;
            JID mobileJId;
            Message sendMessage;
            JID pcJId;
            String clusterNode;
            ClusterRedisUtil clusterRedisUtil = ClusterRedisUtil.getInstance();
            if (!pcOnline && (clusterNode = clusterRedisUtil.getUserResourceNode(pcJId = new JID(username, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true))) != null && !clusterNode.isEmpty()) {
                sendMessage = msg.createCopy();
                msg.setTo(pcJId);
                Log.info("UpdateSubTitleUtil,sendConopMsg,sendMsg,cluster,to:{},sendMessage:{}", new Object[]{pcJId, msg, sendMessage.toString()});
                clusterRedisUtil.saveToRedis(clusterNode, sendMessage);
            }
            if (!mobileOnline && (clusterNode = clusterRedisUtil.getUserResourceNode(mobileJId = new JID(username, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true))) != null && !clusterNode.isEmpty()) {
                sendMessage = msg.createCopy();
                msg.setTo(mobileJId);
                Log.info("UpdateSubTitleUtil,sendConopMsg,sendMsg,cluster,to:{},sendMessage:{}", new Object[]{mobileJId, msg, sendMessage.toString()});
                clusterRedisUtil.saveToRedis(clusterNode, sendMessage);
            }
            if (!padOnline && JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false) && (clusterNode = clusterRedisUtil.getUserResourceNode(padJID = new JID(username, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pad", true))) != null && !clusterNode.isEmpty()) {
                sendMessage = msg.createCopy();
                msg.setTo(padJID);
                Log.info("UpdateSubTitleUtil,sendConopMsg,sendMsg,cluster,to:{},sendMessage:{}", new Object[]{padJID, msg, sendMessage.toString()});
                clusterRedisUtil.saveToRedis(clusterNode, sendMessage);
            }
        }
    }

    private static Message makeMessage(String targetid, String content, String lasttime) {
        Message message = new Message();
        HashMap<String, Object> body = new HashMap<String, Object>();
        message.setType(Message.Type.chat);
        message.setID(UUID.randomUUID().toString());
        body.put("objectName", "FW:Conop");
        body.put("content", "");
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("targetid", targetid);
        extra.put("optype", "uptsubtle");
        extra.put("opvalue", content);
        extra.put("lasttime", lasttime);
        body.put("extra", extra);
        message.setBody(JSON.toJSONString(body));
        return message;
    }
}

