/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weaver.cache.redis.RedisPoolMgr;
import com.weaver.util.ServerInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.plugin.cache.MsgReadUtil;
import org.jivesoftware.openfire.plugin.util.ConverIDUtil;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfre.plugin.msgcollect.MsgCollectUtil;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WithdrawDelMsgThread
extends Thread {
    private String msgid;
    private String notiType;
    private String userId;
    public static final String HISTORY_MSG = "history:msg:";
    public static final String HISTORY_MSG_SYNC = "sync:history:msg:";
    private static final String HISTORY_TO_DB_QUEUE = "history:queue";
    private static final String HISTORY_CONVERSATION = "history:conv:";
    private static final Logger Log = LoggerFactory.getLogger(WithdrawDelMsgThread.class);

    public WithdrawDelMsgThread(String msgid, String notiType, String userId) {
        this.msgid = msgid;
        this.notiType = notiType;
        this.userId = userId;
    }

    @Override
    public void run() {
        Map<String, Object> msgMap = this.getMsgObjectById(this.msgid);
        String fromUserId = (String)msgMap.get("fromUserId");
        String targetId = (String)msgMap.get("targetId");
        String targetType = (String)msgMap.get("targetType");
        List userList = (List)msgMap.get("userRightList");
        this.deleteMsgFromRedis(this.msgid, userList, targetId, targetType, fromUserId);
        this.deleteMsgFromDb(this.msgid);
        MsgCollectUtil.deleteMsgCollect(this.msgid);
        this.updateCon(targetId, targetType, userList, fromUserId);
    }

    private void updateCon(String targetid, String targetType, List<String> userList, String fromUserId) {
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        ArrayList list = new ArrayList(redisPoolMgr.zrevrangeByScore(this.getConversationIDKey(targetid, this.userId, Integer.parseInt(targetType), fromUserId), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()), 0, 1));
        if (list != null && !list.isEmpty()) {
            list.remove("history:msg:0");
        }
        if (list != null && !list.isEmpty()) {
            Map historyMap = redisPoolMgr.hgetall((String)list.get(0));
            for (String userId : userList) {
                int unreadCount;
                Set<String> readUsers;
                if (list == null || list.size() <= 0) continue;
                String targetId = targetid;
                if (!"2".equals(targetType)) {
                    targetId = ConverIDUtil.genaralTargetId(targetid, fromUserId);
                }
                String redisConverKey = "conversation:itmes:" + targetId + ":" + userId;
                Map converMap = redisPoolMgr.hgetall(redisConverKey);
                String lastMsgSendId = (String)historyMap.get("fromUserId");
                String converMapMsgId = (String)converMap.get("msgid");
                if (this.msgid.equals(converMapMsgId)) {
                    String sendTime = (String)historyMap.get("sendTime");
                    String objectName = (String)historyMap.get("objectName");
                    String msgcontent = this.getConversationMsgContent(lastMsgSendId, (String)historyMap.get("content"), objectName);
                    String content = this.getConversationContent(lastMsgSendId, (String)historyMap.get("content"), objectName);
                    redisPoolMgr.hset(redisConverKey, "lasttime", sendTime);
                    redisPoolMgr.hset(redisConverKey, "msgcontent", msgcontent);
                    redisPoolMgr.hset(redisConverKey, "sendId", lastMsgSendId);
                    redisPoolMgr.hset(redisConverKey, "msgid", (String)historyMap.get("timestamp"));
                    redisPoolMgr.hset(redisConverKey, "content", content);
                    redisPoolMgr.hset(redisConverKey, "objectName", objectName);
                    String extraStr = (String)historyMap.get("extra");
                    String sharetypename = null;
                    String shareType = null;
                    JSONObject extra = JSON.parseObject((String)extraStr);
                    if (extra != null && extra.containsKey((Object)"sharetypename")) {
                        sharetypename = extra.getString("sharetypename");
                    }
                    if (extra != null && extra.containsKey((Object)"sharetype")) {
                        shareType = extra.getString("sharetype");
                    }
                    if (sharetypename == null) {
                        redisPoolMgr.hdel(redisConverKey, "sharetypename");
                    } else {
                        redisPoolMgr.hset(redisConverKey, "sharetypename", sharetypename);
                    }
                    if (shareType == null) {
                        redisPoolMgr.hdel(redisConverKey, "shareType");
                    } else {
                        redisPoolMgr.hset(redisConverKey, "shareType", shareType);
                    }
                    this.updateConversation(targetid, userId, msgcontent, content, objectName, sharetypename, shareType, converMapMsgId, sendTime);
                }
                if (userId.equals(fromUserId) || (readUsers = MsgReadUtil.getInstance().getMsgReadById(this.msgid)) == null || readUsers.contains(userId) || (unreadCount = Integer.parseInt((String)converMap.get("unreadcount"))) <= 0) continue;
                redisPoolMgr.hset(redisConverKey, "unreadcount", String.valueOf(--unreadCount));
            }
        } else {
            DatabaseUtil db = new DatabaseUtil();
            String targetId = targetid;
            if (!"2".equals(targetType)) {
                targetId = ConverIDUtil.genaralTargetId(targetid, fromUserId);
            }
            for (String userid : userList) {
                db.deleteOFConversation(userid, targetId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConversation(String targetId, String userId, String msgContent, String content, String objectName, String sharetypename, String sharetype, String msgId, String lasttime) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" UPDATE social_IMRecentConver set msgContent = ?,content= ?,objectName= ?, sharetypename= ?,sharetype= ?,lasttime= ? where userId = ? and targetId = ? and msgId = ?  ");
            pstmt.setString(1, msgContent);
            pstmt.setString(2, content);
            pstmt.setString(3, objectName);
            pstmt.setString(4, sharetypename);
            pstmt.setString(5, sharetype);
            pstmt.setString(6, lasttime);
            pstmt.setString(7, userId);
            pstmt.setString(8, targetId);
            pstmt.setString(9, msgId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("updateConversation ,error :{} ,e :{},targetId :{} ,userId :{} ", new Object[]{e.getMessage(), e, targetId, userId});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    private String getConversationContent(String sendId, String msgcontent, String objectName) {
        String pushContent;
        try {
            String ding;
            JSONObject jsonJSON;
            String para;
            JSONObject paraJSON;
            JSONObject msgcontentJSON;
            pushContent = msgcontent;
            if (objectName.equals("RC:VcMsg")) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.Vc", (String)"multirouter");
            }
            if (objectName.equals("RC:LBSMsg")) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.lbs", (String)"multirouter");
            }
            if (objectName.equals("FW:UniteMsg")) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.uniteMsg", (String)"multirouter");
            }
            if ("RC:ExpMsg".equals(objectName)) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.ExpMsg", (String)"multirouter");
            }
            if (objectName.equals("RC:ImgMsg")) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.img", (String)"multirouter");
            }
            if (objectName.equals("FW:CustomMsg")) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.shake", (String)"multirouter");
            }
            if (objectName.equals("FW:attachmentMsg")) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.attachment", (String)"multirouter") + msgcontent;
            }
            if (objectName.equals("FW:CustomShareMsg") || objectName.equals("FW:CustomShareMsgVote")) {
                pushContent = msgcontent;
            }
            if ("FW:VoIPMsg".equals(objectName)) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.VoIPMsg", (String)"multirouter") + msgcontent;
            }
            if ("FW:Extension_Msg".equals(objectName)) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.Extension_Msg", (String)"multirouter");
            }
            if (objectName.equals("RC:PublicNoticeMsg")) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.PublicNotice", (String)"multirouter") + msgcontent;
            }
            if (objectName.equals("FW:PersonCardMsg")) {
                pushContent = LocaleUtils.getLocalizedString((String)"push.notice.PersonCard", (String)"multirouter") + msgcontent;
            }
            if ("FW:CMDMsg".equals(objectName) && (msgcontentJSON = JSON.parseObject((String)msgcontent)) != null && msgcontentJSON.containsKey((Object)"para") && (paraJSON = JSON.parseObject((String)(para = msgcontentJSON.getString("para")))) != null && paraJSON.containsKey((Object)"ding") && (jsonJSON = JSON.parseObject((String)(ding = paraJSON.getString("ding")))) != null && jsonJSON.containsKey((Object)"content")) {
                pushContent = jsonJSON.getString("content");
            }
        }
        catch (Exception e) {
            Log.error("getConversationMsgContent,error:{},senderId:{},objectName:{},msgContent:{}", new Object[]{e.getMessage(), sendId, objectName, msgcontent});
            pushContent = msgcontent;
        }
        return pushContent;
    }

    private String getConversationMsgContent(String sendId, String msgcontent, String objectName) {
        String pushContent;
        try {
            String ding;
            JSONObject jsonJSON;
            String para;
            JSONObject paraJSON;
            JSONObject msgcontentJSON;
            User user = UserManager.getInstance().getUser(sendId + "|" + ServerInfo.SYSTEM_UDID.toLowerCase());
            String pushBeforeText = user.getName() + "";
            pushContent = pushBeforeText + ":" + msgcontent;
            if (objectName.equals("RC:VcMsg")) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.Vc", (String)"multirouter");
            }
            if (objectName.equals("RC:LBSMsg")) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.lbs", (String)"multirouter");
            }
            if (objectName.equals("FW:UniteMsg")) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.uniteMsg", (String)"multirouter");
            }
            if ("RC:ExpMsg".equals(objectName)) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.ExpMsg", (String)"multirouter");
            }
            if (objectName.equals("RC:ImgMsg")) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.img", (String)"multirouter");
            }
            if (objectName.equals("FW:CustomMsg")) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.shake", (String)"multirouter");
            }
            if (objectName.equals("FW:attachmentMsg")) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.attachment", (String)"multirouter") + msgcontent;
            }
            if (objectName.equals("FW:CustomShareMsg") || objectName.equals("FW:CustomShareMsgVote")) {
                pushContent = pushBeforeText + ":" + msgcontent;
            }
            if ("FW:VoIPMsg".equals(objectName)) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.VoIPMsg", (String)"multirouter") + msgcontent;
            }
            if ("FW:Extension_Msg".equals(objectName)) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.Extension_Msg", (String)"multirouter");
            }
            if (objectName.equals("RC:PublicNoticeMsg")) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.PublicNotice", (String)"multirouter") + msgcontent;
            }
            if (objectName.equals("FW:PersonCardMsg")) {
                pushContent = pushBeforeText + ":" + LocaleUtils.getLocalizedString((String)"push.notice.PersonCard", (String)"multirouter") + msgcontent;
            }
            if ("FW:CMDMsg".equals(objectName) && (msgcontentJSON = JSON.parseObject((String)msgcontent)) != null && msgcontentJSON.containsKey((Object)"para") && (paraJSON = JSON.parseObject((String)(para = msgcontentJSON.getString("para")))) != null && paraJSON.containsKey((Object)"ding") && (jsonJSON = JSON.parseObject((String)(ding = paraJSON.getString("ding")))) != null && jsonJSON.containsKey((Object)"content")) {
                pushContent = pushBeforeText + ":" + jsonJSON.getString("content");
            }
        }
        catch (Exception e) {
            Log.error("getConversationMsgContent,error:{},senderId:{},objectName:{},msgContent:{}", new Object[]{e.getMessage(), sendId, objectName, msgcontent});
            pushContent = msgcontent;
        }
        return pushContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteMsgFromDb(String msgId) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("delete from Social_historyMsgRight where  msgId = ? ");
            pstmt.setString(1, msgId);
            pstmt.executeUpdate();
            DbConnectionManager.closeStatement((Statement)pstmt);
            pstmt = con.prepareStatement("delete from Social_historyMsgRecentlyRight where msgId = ? ");
            pstmt.setString(1, msgId);
            pstmt.executeUpdate();
            DbConnectionManager.closeStatement((Statement)pstmt);
            pstmt = con.prepareStatement("delete from HistoryMsg where msgId = ? ");
            pstmt.setString(1, msgId);
            pstmt.executeUpdate();
            DbConnectionManager.closeStatement((Statement)pstmt);
            pstmt = con.prepareStatement("delete from historyMsgRecently where msgId = ? ");
            pstmt.setString(1, msgId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("deleteMsgFromDb error ,e :{} ,error:{},msgId:{}", new Object[]{e.getMessage(), e, msgId});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    private void deleteMsgFromRedis(String msgId, List<String> userList, String targetId, String targetType, String fromUserId) {
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        String msgkey = this.getMsgKey(this.msgid, targetId, Integer.parseInt(targetType));
        String msgSyncKey = this.getMsgSyncKey(this.msgid, targetId, Integer.parseInt(targetType));
        HashSet<String> zaddKeys = new HashSet<String>();
        for (String userid : userList) {
            zaddKeys.add(this.getConversationIDKey(targetId, userid, Integer.parseInt(targetType), fromUserId));
        }
        redisPoolMgr.batchZrem(new ArrayList(zaddKeys), msgkey);
        redisPoolMgr.del(msgkey);
        redisPoolMgr.zrem(HISTORY_TO_DB_QUEUE, msgSyncKey);
        redisPoolMgr.del(msgSyncKey);
    }

    private String getConversationIDKey(String targetId, String userId, int targetType, String fromUserId) {
        StringBuilder sbld = new StringBuilder(HISTORY_CONVERSATION);
        if (targetType != 2) {
            targetId = ConverIDUtil.genaralTargetId(targetId, fromUserId);
        }
        sbld.append(targetId);
        sbld.append(":");
        sbld.append(userId);
        return sbld.toString();
    }

    private String getMsgSyncKey(String msgid, String targetId, Integer targetType) {
        StringBuilder key = new StringBuilder(HISTORY_MSG_SYNC);
        key.append(msgid);
        if (targetType > 100) {
            key.append(":");
            key.append(targetId);
        }
        return key.toString();
    }

    private String getMsgKey(String msgid, String targetId, Integer targetType) {
        StringBuilder key = new StringBuilder(HISTORY_MSG);
        key.append(msgid);
        if (targetType > 100) {
            key.append(":");
            key.append(targetId);
        }
        return key.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getMsgObjectById(String msgId) {
        Map msgMap;
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (redisPoolMgr != null && (msgMap = redisPoolMgr.hgetall(HISTORY_MSG + msgId)) != null && !msgMap.isEmpty()) {
            String targetType;
            String targetId;
            String fromUserId = (String)msgMap.get("fromUserId");
            if (fromUserId != null && !fromUserId.isEmpty()) {
                resultMap.put("fromUserId", fromUserId);
            }
            if ((targetId = (String)msgMap.get("targetid")) != null && !targetId.isEmpty()) {
                resultMap.put("targetId", targetId);
            }
            if ((targetType = (String)msgMap.get("targetType")) != null && !targetType.isEmpty()) {
                try {
                    int a = Integer.parseInt(targetType) + 1;
                    resultMap.put("targetType", String.valueOf(a));
                }
                catch (Exception e) {
                    resultMap = null;
                }
            }
            List<String> userRightList = Arrays.asList(((String)msgMap.get("userRight")).split(","));
            resultMap.put("userRightList", userRightList);
        }
        if (resultMap == null || resultMap.isEmpty()) {
            resultMap = new HashMap();
            Connection con = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(" select fromuserId,targetId,targetType from historyMsg where msgid = ? ");
                pstmt.setString(1, msgId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String fromuserId = rs.getString("fromuserId");
                    String targetId = rs.getString("targetId");
                    String targetType = rs.getString("targetType");
                    resultMap.put("fromUserId", fromuserId);
                    resultMap.put("targetId", targetId);
                    resultMap.put("targetType", targetType);
                    List<String> userRightList = this.getUserMsgIdRight(msgId);
                    resultMap.put("userRightList", userRightList);
                }
            }
            catch (SQLException e) {
                try {
                    Log.error("getMsgIdObject error : {} ,msgid :{},e :{}", new Object[]{e.getMessage(), msgId, e});
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getUserMsgIdRight(String msgId) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<String> userRight = new ArrayList<String>();
        HashSet<String> set = new HashSet<String>();
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("select userId from Social_historyMsgRight where msgId = ? ");
            pstmt.setString(1, msgId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                set.add(rs.getString("userId"));
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getUserMsgIdRight,msgId:{},error:{}", (Object)msgId, (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        userRight.addAll(set);
        return userRight;
    }
}

