/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util.deleteHistorMsg;

import com.weaver.cache.redis.RedisPoolMgr;
import com.weaver.util.WeiSouPropertiesUtil;
import com.weaver.util.subtable.historymsg.MsgIndexUpdateUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteHistoryMsgThread
extends Thread {
    private static final Logger Log = LoggerFactory.getLogger(DeleteHistoryMsgThread.class);
    private String taskId;
    private List<String> userList;
    private final String DELETEHISTORYMSGTASKKEY = "deleteHistoryMsgTaskId:";
    private final int DELETEHISTORYMSGTASKKEYEXPIRE = 86400;

    public DeleteHistoryMsgThread(String taskId, List<String> userList) {
        this.taskId = taskId;
        this.userList = userList;
    }

    @Override
    public void run() {
        RedisPoolMgr redisPoolMgr;
        boolean deleteAllUser = false;
        if (this.userList == null || this.userList.isEmpty()) {
            this.userList = this.getUserList();
            deleteAllUser = true;
        }
        if ((redisPoolMgr = RedisPoolMgr.getInstance()) != null) {
            redisPoolMgr.set("deleteHistoryMsgTaskId:" + this.taskId, String.valueOf(this.userList.size()), 86400);
        }
        this.deleteHistoryMsgFromRedis(this.userList);
        this.deleteHistoryMsgFromDB(this.userList, deleteAllUser);
    }

    private void deleteHistoryMsgFromRedis(List<String> userList) {
        Log.info("deleteHistoryMsgFromRedis,userList:{}", userList);
        int i = 0;
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr != null) {
            for (String userId : userList) {
                Set historyConvKeys = redisPoolMgr.Keys("history:conv:*" + userId);
                redisPoolMgr.batchDel(historyConvKeys);
                redisPoolMgr.del("conversation:top:" + userId);
                redisPoolMgr.del("conversation:right:" + userId);
                if (++i % 10 != 0 && i != userList.size()) continue;
                redisPoolMgr.set("deleteHistoryMsgTaskId:" + this.taskId + "RedisTask", String.valueOf(userList.size()), 86400);
            }
        }
    }

    private void deleteHistoryMsg(List<String> userList) {
        Log.info("deleteHistoryMsg,userList:{}", userList);
        int size = userList.size();
        int i = size / 10;
        for (int j = 0; j <= i; ++j) {
            ArrayList<String> dList = new ArrayList<String>();
            for (int k = 0; k < 10; ++k) {
                if (j * 10 + k >= size) continue;
                dList.add(userList.get(j * 10 + k));
            }
            this.deleteHistory(userList);
            RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
            if (redisPoolMgr == null) continue;
            if ((j + 1) * 10 < size) {
                redisPoolMgr.set("deleteHistoryMsgTaskId:" + this.taskId + "DBTask", String.valueOf((j + 1) * 10), 86400);
                continue;
            }
            redisPoolMgr.set("deleteHistoryMsgTaskId:" + this.taskId + "DBTask", String.valueOf(size), 86400);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteHistory(List<String> userList) {
        Log.info("deleteHistory,userList:{}", userList);
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        SimpleDateFormat SDF_ALL_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String updateTime = SDF_ALL_TIME_FORMAT.format(new Date());
        String longTime = String.valueOf(System.currentTimeMillis());
        try {
            con = DbConnectionManager.getConnection();
            WeiSouPropertiesUtil w = WeiSouPropertiesUtil.getInstance();
            if (w.isWeiSouEnable()) {
                if (JiveGlobals.getBooleanProperty((String)"subtable.historyMsg", (boolean)false)) {
                    MsgIndexUpdateUtil msg = new MsgIndexUpdateUtil();
                    for (String userId : userList) {
                        msg.updateMsgIndex("7", null, userId);
                    }
                } else {
                    pstmt = con.prepareStatement(" update historyMsg set updatetime = ? where msgId in (select msgId from Social_historyMsgRight where userId = ? ) ");
                    for (String userId : userList) {
                        pstmt.setString(1, updateTime);
                        pstmt.setString(2, userId);
                        pstmt.addBatch();
                    }
                    pstmt.executeBatch();
                    pstmt.clearBatch();
                }
            }
            DbConnectionManager.closeStatement(pstmt);
            pstmt = con.prepareStatement(" delete from Social_historyMsgRight where userid = ? ");
            for (String userId : userList) {
                pstmt.setString(1, userId);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            pstmt.clearBatch();
            DbConnectionManager.closeStatement((Statement)pstmt);
            pstmt = con.prepareStatement("  update social_IMRecentConver set isdel = 1 where userid = ? ");
            for (String userId : userList) {
                pstmt.setString(1, userId);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            pstmt.clearBatch();
            DbConnectionManager.closeStatement((Statement)pstmt);
            pstmt = con.prepareStatement(" delete from Social_historyMsgRecentlyRight where userid = ? ");
            for (String userId : userList) {
                pstmt.setString(1, longTime);
                pstmt.setString(2, userId);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            pstmt.clearBatch();
        }
        catch (Exception e) {
            try {
                Log.error("deleteHistory,error :{} ,userList:{}", (Object)e.getMessage(), userList);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteHistoryMsgFromDB(List<String> userList, boolean deleteAllUser) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block19: {
            Log.info("deleteFromHistoryMsgFromDB,userList:{},deleteAllUser:{}", userList, (Object)deleteAllUser);
            con = null;
            pstmt = null;
            rs = null;
            SimpleDateFormat SDF_ALL_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            String updateTime = SDF_ALL_TIME_FORMAT.format(new Date());
            String longTime = String.valueOf(System.currentTimeMillis());
            try {
                con = DbConnectionManager.getConnection();
                if (deleteAllUser) {
                    pstmt = con.prepareStatement(" delete from Social_historyMsgRight where 1 = 1");
                    pstmt.execute();
                    WeiSouPropertiesUtil w = WeiSouPropertiesUtil.getInstance();
                    if (w.isWeiSouEnable()) {
                        if (JiveGlobals.getBooleanProperty((String)"subtable.historyMsg", (boolean)false)) {
                            MsgIndexUpdateUtil msg = new MsgIndexUpdateUtil();
                            msg.updateMsgIndex("8", null, "deleteAllMsg");
                        } else {
                            DbConnectionManager.closeStatement((Statement)pstmt);
                            pstmt = con.prepareStatement(" update historyMsg set updatetime = ? ");
                            pstmt.setString(1, updateTime);
                            pstmt.execute();
                        }
                    }
                    DbConnectionManager.closeStatement((Statement)pstmt);
                    pstmt = con.prepareStatement(" update social_IMRecentConver set isdel = 1");
                    pstmt.execute();
                    DbConnectionManager.closeStatement((Statement)pstmt);
                    pstmt = con.prepareStatement(" delete from Social_historyMsgRecentlyRight where 1 = 1 ");
                    pstmt.setString(1, longTime);
                    pstmt.execute();
                    RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
                    if (redisPoolMgr != null) {
                        redisPoolMgr.set("deleteHistoryMsgTaskId:" + this.taskId + "DBTask", String.valueOf(userList.size()), 86400);
                    }
                    break block19;
                }
                if (userList.size() <= 10) {
                    WeiSouPropertiesUtil w = WeiSouPropertiesUtil.getInstance();
                    if (w.isWeiSouEnable()) {
                        if (JiveGlobals.getBooleanProperty((String)"subtable.historyMsg", (boolean)false)) {
                            MsgIndexUpdateUtil msg = new MsgIndexUpdateUtil();
                            for (String userId : userList) {
                                msg.updateMsgIndex("7", null, userId);
                            }
                        } else {
                            pstmt = con.prepareStatement(" update historyMsg set updatetime = ? where msgId in (select msgId from Social_historyMsgRight where userId = ? ) ");
                            for (String userId : userList) {
                                pstmt.setString(1, updateTime);
                                pstmt.setString(2, userId);
                                pstmt.addBatch();
                            }
                            pstmt.executeBatch();
                            pstmt.clearBatch();
                        }
                    }
                    DbConnectionManager.closeStatement((Statement)pstmt);
                    pstmt = con.prepareStatement(" delete from Social_historyMsgRight where userid = ? ");
                    for (String userId : userList) {
                        pstmt.setString(1, userId);
                        pstmt.addBatch();
                    }
                    pstmt.executeBatch();
                    pstmt.clearBatch();
                    DbConnectionManager.closeStatement((Statement)pstmt);
                    pstmt = con.prepareStatement("  update social_IMRecentConver set isdel = 1 where userid = ? ");
                    for (String userId : userList) {
                        pstmt.setString(1, userId);
                        pstmt.addBatch();
                    }
                    pstmt.executeBatch();
                    pstmt.clearBatch();
                    DbConnectionManager.closeStatement((Statement)pstmt);
                    pstmt = con.prepareStatement(" delete from Social_historyMsgRecentlyRight where userid = ?");
                    for (String userId : userList) {
                        pstmt.setString(1, longTime);
                        pstmt.setString(2, userId);
                        pstmt.addBatch();
                    }
                    pstmt.executeBatch();
                    pstmt.clearBatch();
                    RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
                    if (redisPoolMgr != null) {
                        redisPoolMgr.set("deleteHistoryMsgTaskId:" + this.taskId + "DBTask", String.valueOf(userList.size()), 86400);
                    }
                    break block19;
                }
                this.deleteHistoryMsg(userList);
            }
            catch (Exception e) {
                block20: {
                    try {
                        Log.error("deleteHistoryMsgFromDB,error :{} ,userList:{},deleteAllUser:{}", new Object[]{e.getMessage(), userList, deleteAllUser});
                        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
                        if (redisPoolMgr == null) break block20;
                        redisPoolMgr.set("deleteHistoryMsgTaskId:" + this.taskId + "DBTask", String.valueOf(userList.size()), 86400);
                    }
                    catch (Throwable throwable) {
                        DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                        throw throwable;
                    }
                }
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
            }
        }
        DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getUserList() {
        ArrayList<String> list = new ArrayList<String>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("select DISTINCT userid from social_IMRecentConver ");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String userId = rs.getString("userid");
                if (userId == null || userId.isEmpty()) continue;
                list.add(userId);
            }
        }
        catch (Exception e) {
            try {
                Log.error("getUserList error : {} ", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return list;
    }
}

