/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util.deleteHistorMsg;

import com.alibaba.fastjson.JSON;
import com.weaver.util.ServerInfo;
import com.weaver.util.WeiSouPropertiesUtil;
import com.weaver.util.cluster.ClusterPropBeanUtil;
import com.weaver.util.cluster.ClusterRedisUtil;
import com.weaver.util.subtable.historymsg.MsgIndexUpdateUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.jivesoftware.openfire.plugin.util.JIDUtil;
import org.jivesoftware.openfire.plugin.util.deleteHistorMsg.DeleteHistoryMsgThread;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfre.plugin.msgcollect.MsgCollectUtil;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;

public class DeleteHistoryMsgUtil {
    private static final Logger Log = LoggerFactory.getLogger(DeleteHistoryMsgUtil.class);
    private static final String INSERT_INTO_OF_DELETEHISTORYMSG = "insert into ofDeleteHistoryMsg  (operator,operatorTime,msgid,msgcontent,operatorIP,fromUserId,targetType,opeartorDevice)  VALUES(?,?,?,?,?,?,?,?)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveDeleteHistoryMsg(String operator, String msgid, String msgcontent, String operatorIP, String fromUserId, String targetType, String opeartorDevice) {
        boolean result = true;
        SimpleDateFormat SDF_ALL_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String operatorTime = SDF_ALL_TIME_FORMAT.format(new Date());
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(INSERT_INTO_OF_DELETEHISTORYMSG);
            pstmt.setString(1, operator);
            pstmt.setString(2, operatorTime);
            pstmt.setString(3, msgid);
            pstmt.setString(4, msgcontent);
            pstmt.setString(5, operatorIP);
            pstmt.setString(6, fromUserId);
            pstmt.setString(7, targetType);
            pstmt.setString(8, opeartorDevice);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("deleteHistoryMsg,error:{}", (Object)e.getMessage());
                result = false;
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        return result;
    }

    public String deleteHistoryMsgUtil(List<String> userIdList) {
        String taskId = UUID.randomUUID().toString();
        Log.info("deleteHistoryMsgUtil,taskId:{},userIdList:{}", (Object)taskId, userIdList);
        DeleteHistoryMsgThread deleteHistoryMsgThread = new DeleteHistoryMsgThread(taskId, userIdList);
        deleteHistoryMsgThread.start();
        return taskId;
    }

    public boolean deleteHistoryMsg(String msgId, String fromUserId, String targetId, String targetType, String requestIp) {
        boolean result = true;
        UserManager userManager = UserManager.getInstance();
        SessionManager sessionManager = SessionManager.getInstance();
        DatabaseUtil db = new DatabaseUtil();
        if ("1".equals(targetType)) {
            String fromUserName = fromUserId + "|" + ServerInfo.SYSTEM_UDID;
            String toUserName = targetId + "|" + ServerInfo.SYSTEM_UDID;
            try {
                User fromUser = userManager.getUser(fromUserName);
                User toUser = userManager.getUser(toUserName);
                Collection fromUserSessions = sessionManager.getSessions(fromUser.getUsername());
                boolean senderPcOnline = false;
                boolean senderMobileOnline = false;
                for (ClientSession clientSession : fromUserSessions) {
                    if (clientSession == null || !clientSession.canFloodOfflineMessages()) continue;
                    Message senMessage = this.getMessage(msgId, toUser.getUsername());
                    JID jid = clientSession.getAddress();
                    senMessage.setFrom(jid.asBareJID());
                    senMessage.setTo(jid);
                    Log.info("deleteHistoryMsg,sendMessage:{}", (Object)senMessage.toString());
                    if ("pc".equals(clientSession.getAddress().getResource())) {
                        senderPcOnline = true;
                    }
                    if ("mobile".equals(clientSession.getAddress().getResource())) {
                        senderMobileOnline = true;
                    }
                    clientSession.process((Packet)senMessage);
                }
                boolean receivePcOnline = false;
                boolean receiveMobileOnline = false;
                Collection toUserSessions = sessionManager.getSessions(toUser.getUsername());
                for (ClientSession clientSession : toUserSessions) {
                    if (clientSession == null || !clientSession.canFloodOfflineMessages()) continue;
                    Message senMessage = this.getMessage(msgId, fromUser.getUsername());
                    JID jid = clientSession.getAddress();
                    senMessage.setFrom(jid.asBareJID());
                    senMessage.setTo(jid);
                    if ("pc".equals(clientSession.getAddress().getResource())) {
                        receivePcOnline = true;
                    }
                    if ("mobile".equals(clientSession.getAddress().getResource())) {
                        receiveMobileOnline = true;
                    }
                    Log.info("deleteHistoryMsg,sendMessage:{}", (Object)senMessage.toString());
                    clientSession.process((Packet)senMessage);
                }
                ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
                if (clusterPropBeanUtil.isUseCluster()) {
                    JID mobileJID;
                    String mobileClusterNode;
                    Message senMessage;
                    JID pcJID;
                    String pcClusterNode;
                    ClusterRedisUtil clusterRedisUtil = ClusterRedisUtil.getInstance();
                    if (!senderPcOnline && (pcClusterNode = clusterRedisUtil.getUserResourceNode(pcJID = new JID(fromUser.getUsername(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true))) != null && !pcClusterNode.isEmpty()) {
                        senMessage = this.getMessage(msgId, toUser.getUsername());
                        senMessage.setFrom(pcJID.asBareJID());
                        senMessage.setTo(pcJID);
                        clusterRedisUtil.saveToRedis(pcClusterNode, senMessage);
                    }
                    if (!senderMobileOnline && (mobileClusterNode = clusterRedisUtil.getUserResourceNode(mobileJID = new JID(fromUser.getUsername(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true))) != null && !mobileClusterNode.isEmpty()) {
                        senMessage = this.getMessage(msgId, toUser.getUsername());
                        senMessage.setFrom(mobileJID.asBareJID());
                        senMessage.setTo(mobileJID);
                        clusterRedisUtil.saveToRedis(mobileClusterNode, senMessage);
                    }
                    if (!receivePcOnline && (pcClusterNode = clusterRedisUtil.getUserResourceNode(pcJID = new JID(toUser.getUsername(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true))) != null && !pcClusterNode.isEmpty()) {
                        senMessage = this.getMessage(msgId, fromUser.getUsername());
                        senMessage.setFrom(pcJID.asBareJID());
                        senMessage.setTo(pcJID);
                        clusterRedisUtil.saveToRedis(pcClusterNode, senMessage);
                    }
                    if (!receiveMobileOnline && (mobileClusterNode = clusterRedisUtil.getUserResourceNode(mobileJID = new JID(toUser.getUsername(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true))) != null && !mobileClusterNode.isEmpty()) {
                        senMessage = this.getMessage(msgId, fromUser.getUsername());
                        senMessage.setFrom(mobileJID.asBareJID());
                        senMessage.setTo(mobileJID);
                        clusterRedisUtil.saveToRedis(mobileClusterNode, senMessage);
                    }
                }
            }
            catch (Exception e) {
                Log.error("deleteHistoryMsg,error:{},msgId:{},fromUserId:{},targetId:{},targetType:{}", new Object[]{e.getMessage(), msgId, fromUserId, targetId, targetType});
                return false;
            }
            db.deleteHistoryMsg(fromUserId, msgId, "sysadmin", requestIp, "sysadmin", targetType);
            db.deleteHistoryMsg(targetId, msgId, "sysadmin", requestIp, "sysadmin", targetType);
        } else if ("2".equals(targetType)) {
            try {
                GroupManager groupManager = GroupManager.getInstance();
                Group group = groupManager.getGroup(targetId);
                Collection groupUsers = group.getAll();
                for (JID jid : groupUsers) {
                    boolean pcOnline = false;
                    boolean mobileOnline = false;
                    Collection toUserSessions = sessionManager.getSessions(jid.getNode());
                    for (ClientSession clientSession : toUserSessions) {
                        Message senMessage = this.getMessage(msgId, targetId);
                        if (clientSession == null || !clientSession.canFloodOfflineMessages()) continue;
                        JID toJID = clientSession.getAddress();
                        senMessage.setFrom(toJID.asBareJID());
                        senMessage.setTo(toJID);
                        if ("pc".equals(clientSession.getAddress().getResource())) {
                            pcOnline = true;
                        }
                        if ("mobile".equals(clientSession.getAddress().getResource())) {
                            mobileOnline = true;
                        }
                        Log.info("deleteHistoryMsg,sendMessage:{}", (Object)senMessage.toString());
                        clientSession.process((Packet)senMessage);
                    }
                    ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
                    if (clusterPropBeanUtil.isUseCluster()) {
                        JID mobileJID;
                        String mobileClusterNode;
                        Message senMessage;
                        JID pcJID;
                        String pcClusterNode;
                        ClusterRedisUtil clusterRedisUtil = ClusterRedisUtil.getInstance();
                        if (!pcOnline && (pcClusterNode = clusterRedisUtil.getUserResourceNode(pcJID = new JID(jid.getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true))) != null && !pcClusterNode.isEmpty()) {
                            senMessage = this.getMessage(msgId, targetId);
                            senMessage.setFrom(pcJID.asBareJID());
                            senMessage.setTo(pcJID);
                            clusterRedisUtil.saveToRedis(pcClusterNode, senMessage);
                        }
                        if (!mobileOnline && (mobileClusterNode = clusterRedisUtil.getUserResourceNode(mobileJID = new JID(jid.getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true))) != null && !mobileClusterNode.isEmpty()) {
                            senMessage = this.getMessage(msgId, targetId);
                            senMessage.setFrom(mobileJID.asBareJID());
                            senMessage.setTo(mobileJID);
                            clusterRedisUtil.saveToRedis(mobileClusterNode, senMessage);
                        }
                    }
                    db.deleteHistoryMsg(JIDUtil.conNodeToID(jid.getNode()), msgId, "sysadmin", requestIp, "sysadmin", targetType);
                }
            }
            catch (Exception e) {
                Log.error("deleteHistoryMsg,error:{},msgId:{},fromUserId:{},targetId:{},targetType:{}", new Object[]{e.getMessage(), msgId, fromUserId, targetId, targetType});
                return false;
            }
        }
        this.deleteMsgById(msgId);
        MsgCollectUtil.deleteMsgCollect(msgId);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteMsgById(String msgId) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            String tableName = MsgIndexUpdateUtil.getTableNameByMsgId((String)msgId);
            String sql = " update " + tableName + " set isdel = 1,updatetime = ? where msgId = ? ";
            SimpleDateFormat SDF_ALL_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            String updateTime = SDF_ALL_TIME_FORMAT.format(new Date());
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sql);
            pstmt.setString(1, updateTime);
            pstmt.setString(2, msgId);
            pstmt.execute();
            DbConnectionManager.closeStatement((Statement)pstmt);
            pstmt = con.prepareStatement(" delete from social_HistoryMsgright where msgId = ? ");
            pstmt.setString(1, msgId);
            pstmt.execute();
            DbConnectionManager.closeStatement((Statement)pstmt);
            pstmt = con.prepareStatement(" delete from historymsgrecently where msgId = ? ");
            pstmt.setString(1, msgId);
            pstmt.execute();
            DbConnectionManager.closeStatement((Statement)pstmt);
            pstmt = con.prepareStatement(" delete from social_HistoryMsgrecentlyright where msgId = ? ");
            pstmt.setString(1, msgId);
            pstmt.execute();
            WeiSouPropertiesUtil w = WeiSouPropertiesUtil.getInstance();
            if (w.isWeiSouEnable() && JiveGlobals.getBooleanProperty((String)"subtable.historyMsg", (boolean)false)) {
                MsgIndexUpdateUtil msg = new MsgIndexUpdateUtil();
                msg.updateMsgIndex("9", null, msgId);
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        catch (SQLException e) {
            Log.error("deleteMsgById,msgId:{},error:{}", (Object)msgId, (Object)e.getMessage());
        }
        finally {
            DbConnectionManager.closeConnection(pstmt, con);
        }
    }

    private Message getMessage(String msgId, String toUser) {
        Message msg = new Message();
        msg.setType(Message.Type.chat);
        msg.setID(UUID.randomUUID().toString());
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("objectName", "FW:Conop");
        bodyMap.put("content", "");
        HashMap<String, String> extraMap = new HashMap<String, String>();
        extraMap.put("optype", "delmsg");
        extraMap.put("opvalue", msgId);
        extraMap.put("targetid", toUser);
        bodyMap.put("extra", extraMap);
        msg.setBody(JSON.toJSONString(bodyMap).toString());
        return msg;
    }
}

