/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util.deleteHistorMsg;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weaver.cache.redis.RedisPoolMgr;
import com.weaver.msg.encrypt.EncryptUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.plugin.util.MsgDataMaskUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weaver.fullsearch.interfaces.service.MegSearch;

public class SearchHistoryUtil {
    private static final Logger Log = LoggerFactory.getLogger(SearchHistoryUtil.class);

    private String[] getSqlForSearchHistoryMsg(String startTime, String endTime, String fromUserIds, String searchMsg, String groupName, String orderType, String className, String toUserIds, String pageSize, String pageNumber, String groupId) {
        String sql = "";
        String sqlCount = "";
        String backSql = " fromUserId,targetId,targetType,className,imageUri,dateTime,extra,fullAmount,msgId,MsgContent,b.description as groupName";
        String sqlFrom = " historyMsg a left join ofgroup b on a.targetId = b.groupName ";
        String sqlWhere = " targetType in ('1','2') and ( a.isdel != 1 or a.isdel is null )";
        String sqlOrderBy = "";
        if (startTime == null || endTime == null) {
            return null;
        }
        sqlWhere = sqlWhere + " and dateTime >= ? and dateTime <= ?";
        if (fromUserIds != null && fromUserIds.contains(",")) {
            String[] fromUserId = fromUserIds.split(",");
            sqlWhere = sqlWhere + " and fromUserId in (";
            for (String userId : fromUserId) {
                sqlWhere = sqlWhere + "?,";
            }
            if (sqlWhere.endsWith(",")) {
                sqlWhere = sqlWhere.substring(0, sqlWhere.length() - 1);
            }
            sqlWhere = sqlWhere + " )";
        } else if (fromUserIds != null && !fromUserIds.isEmpty() && !fromUserIds.contains(",")) {
            sqlWhere = sqlWhere + " and fromUserId = ?";
        }
        if (toUserIds != null && toUserIds.contains(",")) {
            String[] toUserId = toUserIds.split(",");
            sqlWhere = sqlWhere + " and targetId in (";
            for (String userId : toUserId) {
                sqlWhere = sqlWhere + "?,";
            }
            if (sqlWhere.endsWith(",")) {
                sqlWhere = sqlWhere.substring(0, sqlWhere.length() - 1);
            }
            sqlWhere = sqlWhere + " )";
        } else if (toUserIds != null && !toUserIds.isEmpty() && !toUserIds.contains(",")) {
            sqlWhere = sqlWhere + " and targetId = ? ";
        }
        if (searchMsg != null && !searchMsg.isEmpty()) {
            sqlWhere = sqlWhere + " and msgContent like ? ";
        }
        sqlWhere = className != null && !className.isEmpty() ? sqlWhere + " and classname = ? " : (searchMsg != null && !searchMsg.isEmpty() ? sqlWhere + " and classname IN ('RC:TxtMsg','FW:attachmentMsg','FW:CustomShareMsg') " : sqlWhere + " and classname IN ('RC:TxtMsg','RC:ImgMsg','RC:VcMsg','RC:LBSMsg','FW:attachmentMsg','FW:PersonCardMsg','FW:richTextMsg','FW:LinkMsg','FW:NewsMsg','FW:CustomShareMsg','FW:VoIPMsg','FW:Extension_Msg','RC:PublicNoticeMsg','FW:UniteMsg')");
        if (groupName != null && !groupName.isEmpty()) {
            sqlWhere = sqlWhere + "and b.description like ? ";
        }
        if (groupId != null && !groupId.isEmpty()) {
            sqlWhere = sqlWhere + " and a.groupId = ? ";
        }
        sqlOrderBy = orderType != null && "2".equals(orderType) ? " order by dateTime " : " order by dateTime Desc";
        sqlCount = "select count(1) as totalCount from" + sqlFrom + " where" + sqlWhere;
        if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
            sql = "select ROW_NUMBER() OVER(" + sqlOrderBy + ") AS rn," + backSql + " from" + sqlFrom + " where" + sqlWhere;
        } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.dm.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.st.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.postgresql)) {
            sql = "select " + backSql + " from" + sqlFrom + " where" + sqlWhere + sqlOrderBy;
        }
        String sqlByPage = "";
        int pageNo = Integer.parseInt(pageNumber);
        int pageS = Integer.parseInt(pageSize);
        if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
            sqlByPage = "SELECT * FROM (" + sql + ") AS pageTable WHERE rn BETWEEN " + ((pageNo - 1) * pageS + 1) + " AND " + pageNo * pageS;
        } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
            sqlByPage = "SELECT * FROM (SELECT rownum as rn, pageTable.* FROM (" + sql + ")pageTable) WHERE rn BETWEEN " + ((pageNo - 1) * pageS + 1) + " AND " + pageNo * pageS;
        } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
            sqlByPage = sql + " LIMIT " + (pageNo - 1) * pageS + "," + pageS;
        } else if (DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
            sqlByPage = sql + " LIMIT " + pageS + " offset " + (pageNo - 1) * pageS;
        }
        return new String[]{sqlCount, sqlByPage};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGroup(String groupName) {
        String groups = null;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            stmt = con.prepareStatement(" select groupname from ofgroup where description like ? ");
            stmt.setString(1, "%" + groupName + "%");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String n = rs.getString("groupname");
                groups = groups + "," + n;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)stmt, (Connection)con);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbConnectionManager.closeConnection(rs, (Statement)stmt, (Connection)con);
        }
        if (groups.startsWith(",")) {
            groups = groups.substring(1, groups.length());
        }
        if (groups.endsWith(",")) {
            groups = groups.substring(0, groups.length() - 1);
        }
        return groups;
    }

    public Map<String, Object> searchHistoryMsgFromWeiSou(String startTime, String endTime, String fromUserIds, String searchMsg, String groupName, String orderType, String className, String toUserIds, String pageSize, String pageNumber, String groupId) {
        String groupids;
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("schemaType", "MSGSEARCH");
        if (null != pageNumber) {
            paramMap.put("pageNumber", pageNumber);
        }
        if (null != pageSize) {
            paramMap.put("pageSize", pageSize);
        }
        if (fromUserIds != null && !fromUserIds.isEmpty()) {
            paramMap.put("fromUserId", fromUserIds);
        }
        if (groupName != null && !groupName.isEmpty() && (groupids = this.getGroup(groupName)) != null && !groupids.isEmpty()) {
            paramMap.put("groupId", groupids);
        }
        if (groupId != null && !groupId.isEmpty()) {
            paramMap.put("groupId", groupId);
        }
        if (toUserIds != null && !toUserIds.isEmpty()) {
            paramMap.put("targetId", toUserIds);
        }
        if (StringUtils.isNotBlank((CharSequence)startTime)) {
            paramMap.put("startTime", startTime);
        }
        if (StringUtils.isNotBlank((CharSequence)endTime)) {
            paramMap.put("endTime", endTime);
        }
        if (StringUtils.isNotBlank((CharSequence)searchMsg)) {
            paramMap.put("keyword", searchMsg);
        }
        String msgType = null;
        msgType = searchMsg != null && !searchMsg.isEmpty() ? "RC:TxtMsg,FW:attachmentMsg,FW:CustomShareMsg" : "RC:TxtMsg,RC:ImgMsg,RC:VcMsg,RC:LBSMsg,FW:attachmentMsg,FW:PersonCardMsg,FW:richTextMsg,FW:LinkMsg,FW:NewsMsg,FW:CustomShareMsg,FW:VoIPMsg,FW:Extension_Msg,RC:PublicNoticeMsg,FW:UniteMsg";
        paramMap.put("Classname", msgType);
        HashMap<String, String> sortMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)orderType) && orderType.equals("1")) {
            sortMap.put("ID", "true");
        } else {
            sortMap.put("ID", "false");
        }
        HashMap aggMap = new HashMap();
        Map weiSouMap = MegSearch.search(paramMap, sortMap, aggMap);
        ArrayList historyMsgList = new ArrayList();
        if (weiSouMap != null && weiSouMap.containsKey("result")) {
            List listResult = (List)weiSouMap.get("result");
            for (Map map : listResult) {
                JSONObject fullAmountJson;
                HashMap<String, CharSequence> msgMap = new HashMap<String, CharSequence>();
                String fromUserId = map.get("fromUserId").toString();
                String className1 = map.get("objectName").toString();
                String imageUrl = (String)map.get("imageUrl");
                String dateTime = (String)map.get("dateTime");
                String msgContent = (String)map.get("content");
                String groupname = null;
                String targetType = (String)map.get("targetType");
                String t = (String)map.get("groupId");
                if ("2".equals(targetType)) {
                    try {
                        groupname = GroupManager.getInstance().getGroup(t).getDescription();
                    }
                    catch (GroupNotFoundException e) {
                        e.printStackTrace();
                    }
                } else {
                    t = (String)map.get("targetid");
                }
                String extra = (String)map.get("extra");
                String fullAmount = "";
                String msgId = (String)map.get("msgId");
                msgMap.put("fromUserId", StringUtils.defaultIfEmpty((CharSequence)fromUserId, (CharSequence)""));
                msgMap.put("groupId", StringUtils.defaultIfEmpty((CharSequence)t, (CharSequence)""));
                msgMap.put("msgType", StringUtils.defaultIfEmpty((CharSequence)className1, (CharSequence)""));
                msgMap.put("imageUrl", StringUtils.defaultIfEmpty((CharSequence)imageUrl, (CharSequence)""));
                msgMap.put("dateTime", StringUtils.defaultIfEmpty((CharSequence)dateTime, (CharSequence)""));
                if (!(className1.equals("RC:ImgMsg") || className1.equals("RC:LBSMsg") || className1.equals("RC:VcMsg"))) {
                    msgContent = MsgDataMaskUtil.getInstance().msgDataMask(msgContent);
                }
                msgMap.put("msgContent", StringUtils.defaultIfEmpty((CharSequence)msgContent, (CharSequence)""));
                msgMap.put("groupName", StringUtils.defaultIfEmpty((CharSequence)groupname, (CharSequence)""));
                msgMap.put("targetType", StringUtils.defaultIfEmpty((CharSequence)targetType, (CharSequence)""));
                msgMap.put("extra", StringUtils.defaultIfEmpty((CharSequence)extra, (CharSequence)""));
                if (className1.equals("RC:LBSMsg") && (fullAmountJson = JSONObject.parseObject((String)fullAmount)).containsKey((Object)"poi")) {
                    String poi = fullAmountJson.getString("poi");
                    poi = MsgDataMaskUtil.getInstance().msgDataMask(poi);
                    fullAmountJson.put("poi", (Object)poi);
                    fullAmount = fullAmountJson.toString();
                }
                msgMap.put("fullAmount", StringUtils.defaultIfEmpty((CharSequence)fullAmount, (CharSequence)""));
                msgMap.put("msgId", StringUtils.defaultIfEmpty((CharSequence)msgId, (CharSequence)""));
                historyMsgList.add(msgMap);
            }
        }
        result.put("msgList", historyMsgList);
        result.put("pageNumber", weiSouMap.get("pageNumber"));
        result.put("pageSize", weiSouMap.get("pageSize"));
        result.put("totalCount", weiSouMap.get("count"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> searchHistoryMsg(String startTime, String endTime, String fromUserIds, String searchMsg, String groupName, String orderType, String className, String toUserIds, String pageSize, String pageNumber, String groupId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] sqls = this.getSqlForSearchHistoryMsg(startTime, endTime, fromUserIds, searchMsg, groupName, orderType, className, toUserIds, pageSize, pageNumber, groupId);
        String sqlCount = sqls[0];
        Log.info("searchHistoryMsg sqlCount,:{}", (Object)sqlCount);
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sqlCount);
            int i = 0;
            pstmt.setString(++i, startTime);
            pstmt.setString(++i, endTime);
            if (fromUserIds != null && fromUserIds.contains(",")) {
                String[] fromUserId;
                for (String userId : fromUserId = fromUserIds.split(",")) {
                    pstmt.setString(++i, userId);
                }
            } else if (fromUserIds != null && !fromUserIds.isEmpty() && !fromUserIds.contains(",")) {
                pstmt.setString(++i, fromUserIds);
            }
            if (toUserIds != null && toUserIds.contains(",")) {
                String[] toUserId;
                for (String userId : toUserId = toUserIds.split(",")) {
                    pstmt.setString(++i, userId);
                }
            } else if (toUserIds != null && !toUserIds.isEmpty() && !toUserIds.contains(",")) {
                pstmt.setString(++i, toUserIds);
            }
            if (searchMsg != null && !searchMsg.isEmpty()) {
                pstmt.setString(++i, "%" + searchMsg + "%");
            }
            if (className != null && !className.isEmpty()) {
                pstmt.setString(++i, className);
            }
            if (groupName != null && !groupName.isEmpty()) {
                pstmt.setString(++i, "%" + groupName + "%");
            }
            if (groupId != null && !groupId.isEmpty()) {
                pstmt.setString(++i, groupId);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String totalCount = rs.getString("totalCount");
                result.put("totalCount", totalCount);
            }
            DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
            String sql = sqls[1];
            Log.info("searchHistoryMsg sql,:{}", (Object)sql);
            pstmt = con.prepareStatement(sql);
            int j = 0;
            pstmt.setString(++j, startTime);
            pstmt.setString(++j, endTime);
            if (fromUserIds != null && fromUserIds.contains(",")) {
                String[] fromUserId;
                String[] stringArray = fromUserId = fromUserIds.split(",");
                int userId = stringArray.length;
                for (int k = 0; k < userId; ++k) {
                    String userId2 = stringArray[k];
                    pstmt.setString(++j, userId2);
                }
            } else if (fromUserIds != null && !fromUserIds.isEmpty() && !fromUserIds.contains(",")) {
                pstmt.setString(++j, fromUserIds);
            }
            if (toUserIds != null && toUserIds.contains(",")) {
                String[] toUserId;
                for (String userId2 : toUserId = toUserIds.split(",")) {
                    pstmt.setString(++j, userId2);
                }
            } else if (toUserIds != null && !toUserIds.isEmpty() && !toUserIds.contains(",")) {
                pstmt.setString(++j, toUserIds);
            }
            if (searchMsg != null && !searchMsg.isEmpty()) {
                pstmt.setString(++j, "%" + searchMsg + "%");
            }
            if (className != null && !className.isEmpty()) {
                pstmt.setString(++j, className);
            }
            if (groupName != null && !groupName.isEmpty()) {
                pstmt.setString(++j, "%" + groupName + "%");
            }
            if (groupId != null && !groupId.isEmpty()) {
                pstmt.setString(++j, groupId);
            }
            rs = pstmt.executeQuery();
            ArrayList historyMsgList = new ArrayList();
            while (rs.next()) {
                JSONObject fullAmountJson;
                HashMap<String, CharSequence> msgMap = new HashMap<String, CharSequence>();
                String fromUserId = rs.getString("fromUserId");
                String groupIdstt = rs.getString("targetId");
                String msgType = rs.getString("className");
                String imageUrl = rs.getString("imageUri");
                String dateTime = rs.getString("dateTime");
                String msgContent = rs.getString("MsgContent");
                String groupname = rs.getString("groupName");
                String targetType = rs.getString("targetType");
                String extra = rs.getString("extra");
                String fullAmount = rs.getString("fullAmount");
                if (EncryptUtil.isEncryptEnable()) {
                    msgContent = EncryptUtil.decrypt((String)msgContent);
                    extra = EncryptUtil.decrypt((String)extra);
                    fullAmount = EncryptUtil.decrypt((String)fullAmount);
                }
                String msgId = rs.getString("msgId");
                msgMap.put("fromUserId", StringUtils.defaultIfEmpty((CharSequence)fromUserId, (CharSequence)""));
                msgMap.put("groupId", StringUtils.defaultIfEmpty((CharSequence)groupIdstt, (CharSequence)""));
                msgMap.put("msgType", StringUtils.defaultIfEmpty((CharSequence)msgType, (CharSequence)""));
                msgMap.put("imageUrl", StringUtils.defaultIfEmpty((CharSequence)imageUrl, (CharSequence)""));
                msgMap.put("dateTime", StringUtils.defaultIfEmpty((CharSequence)dateTime, (CharSequence)""));
                if (!(msgType.equals("RC:ImgMsg") || msgType.equals("RC:LBSMsg") || msgType.equals("RC:VcMsg"))) {
                    msgContent = MsgDataMaskUtil.getInstance().msgDataMask(msgContent);
                }
                msgMap.put("msgContent", StringUtils.defaultIfEmpty((CharSequence)msgContent, (CharSequence)""));
                msgMap.put("groupName", StringUtils.defaultIfEmpty((CharSequence)groupname, (CharSequence)""));
                msgMap.put("targetType", StringUtils.defaultIfEmpty((CharSequence)targetType, (CharSequence)""));
                msgMap.put("extra", StringUtils.defaultIfEmpty((CharSequence)extra, (CharSequence)""));
                if (msgType.equals("RC:LBSMsg") && (fullAmountJson = JSONObject.parseObject((String)fullAmount)).containsKey((Object)"poi")) {
                    String poi = fullAmountJson.getString("poi");
                    poi = MsgDataMaskUtil.getInstance().msgDataMask(poi);
                    fullAmountJson.put("poi", (Object)poi);
                    fullAmount = fullAmountJson.toString();
                }
                msgMap.put("fullAmount", StringUtils.defaultIfEmpty((CharSequence)fullAmount, (CharSequence)""));
                msgMap.put("msgId", StringUtils.defaultIfEmpty((CharSequence)msgId, (CharSequence)""));
                historyMsgList.add(msgMap);
            }
            result.put("msgList", historyMsgList);
            result.put("pageSize", pageSize);
            result.put("pageNumber", pageNumber);
        }
        catch (Exception e) {
            try {
                Log.error("searchHistoryMsg error :{} ,startTime:{},endTime:{},fromUserIds:{},searchMsg:{},groupName:{},orderType:{},pageSize:{},pageNumber:{}", new Object[]{e.getMessage(), startTime, endTime, fromUserIds, searchMsg, groupName, orderType, pageSize, pageNumber});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return result;
    }

    public Map<String, Object> searchUniteMsg(String uniteMsgId) {
        List<String> msgIdList = SearchHistoryUtil.getUniteMsgIds(uniteMsgId);
        ArrayList<Map<String, String>> msgList = new ArrayList<Map<String, String>>();
        for (String msgId : msgIdList) {
            Map<String, String> resultMap = this.getMsgById(msgId);
            if (resultMap == null || resultMap.isEmpty()) {
                Log.warn("searchUniteMsg msg is del or null,msgId:{}", (Object)msgId);
                continue;
            }
            msgList.add(resultMap);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("msgList", msgList);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getMsgById(String msgId) {
        HashMap<String, String> result = new HashMap<String, String>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("select * from historyMsg where msgId = ? and classname IN ('RC:TxtMsg','FW:attachmentMsg','FW:CustomShareMsg','RC:TxtMsg','RC:ImgMsg','RC:VcMsg','RC:LBSMsg','FW:attachmentMsg','FW:PersonCardMsg','FW:richTextMsg','FW:LinkMsg','FW:NewsMsg','FW:CustomShareMsg','FW:VoIPMsg','FW:Extension_Msg','RC:PublicNoticeMsg','FW:UniteMsg') and (isdel != 1 or isdel is null)  ");
            pstmt.setString(1, msgId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String fromUserId = rs.getString("fromUserId");
                String groupId = rs.getString("targetId");
                String msgType = rs.getString("className");
                String imageUrl = rs.getString("imageUri");
                String dateTime = rs.getString("dateTime");
                String msgContent = rs.getString("MsgContent");
                String targetType = rs.getString("targetType");
                String extra = rs.getString("extra");
                String fullAmount = rs.getString("fullAmount");
                if (EncryptUtil.isEncryptEnable()) {
                    msgContent = EncryptUtil.decrypt((String)msgContent);
                    extra = EncryptUtil.decrypt((String)extra);
                    fullAmount = EncryptUtil.decrypt((String)fullAmount);
                }
                String groupName = "";
                if ("2".equals(targetType)) {
                    GroupManager groupManager = GroupManager.getInstance();
                    try {
                        Group group = groupManager.getGroup(groupId);
                        groupName = group.getDescription();
                    }
                    catch (GroupNotFoundException e) {
                        Log.error("searchGroup group not found. groupId:{},msgId:{}", (Object)groupId, (Object)msgId);
                    }
                }
                result.put("fromUserId", (String)StringUtils.defaultIfEmpty((CharSequence)fromUserId, (CharSequence)""));
                result.put("groupId", (String)StringUtils.defaultIfEmpty((CharSequence)groupId, (CharSequence)""));
                result.put("msgType", (String)StringUtils.defaultIfEmpty((CharSequence)msgType, (CharSequence)""));
                result.put("imageUrl", (String)StringUtils.defaultIfEmpty((CharSequence)imageUrl, (CharSequence)""));
                result.put("dateTime", (String)StringUtils.defaultIfEmpty((CharSequence)dateTime, (CharSequence)""));
                result.put("msgContent", (String)StringUtils.defaultIfEmpty((CharSequence)msgContent, (CharSequence)""));
                result.put("groupName", (String)StringUtils.defaultIfEmpty((CharSequence)groupName, (CharSequence)""));
                result.put("targetType", (String)StringUtils.defaultIfEmpty((CharSequence)targetType, (CharSequence)""));
                result.put("extra", (String)StringUtils.defaultIfEmpty((CharSequence)extra, (CharSequence)""));
                result.put("fullAmount", (String)StringUtils.defaultIfEmpty((CharSequence)fullAmount, (CharSequence)""));
                result.put("msgId", msgId);
            }
        }
        catch (Exception e) {
            try {
                Log.error("getMsgById.error:{} ,msgId:{}", (Object)e.getMessage(), (Object)msgId);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getUniteMsgIds(String uniteMsgId) {
        ArrayList<String> list = new ArrayList<String>();
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        String strValue = null;
        if (redisPoolMgr != null) {
            strValue = redisPoolMgr.get("uinteMsg:" + uniteMsgId);
        }
        if (strValue == null || strValue.isEmpty()) {
            Connection con = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("select * from ofunitemsginfo where uniteMsgId = ? ");
                pstmt.setString(1, uniteMsgId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    strValue = rs.getString("msgIds");
                }
            }
            catch (SQLException e) {
                try {
                    Log.error("getUniteMsgIds .error :{} ,uniteMsgId : {}", (Object)e.getMessage(), (Object)uniteMsgId);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        JSONArray jsonList = JSONArray.parseArray((String)strValue);
        for (Object s : jsonList) {
            list.add((String)s);
        }
        return list;
    }
}

