/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfre.plugin.msgcollect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfre.plugin.msgcollect.MsgCollectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public class MsgCollectIQHandler
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(MsgCollectIQHandler.class);
    private String namespace = "http://weaver.com.cn/msg/collect";
    private IQHandlerInfo info = new IQHandlerInfo("query", this.namespace);

    public MsgCollectIQHandler() {
        super("MsgCollectIQHandler");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        JID fromJID = packet.getFrom();
        if (fromJID == null) {
            Log.debug("invalid iq request, from is null, id:{}", (Object)packet.getID());
            return null;
        }
        long startTime = System.currentTimeMillis();
        String username = fromJID.getNode();
        Map<Object, Object> result = new HashMap<String, String>();
        IQ reply = IQ.createResultIQ((IQ)packet);
        Element elereply = reply.getElement();
        Element ele = elereply.addElement("query");
        String data = packet.getElement().elementText("query");
        JSONObject json = JSON.parseObject((String)data);
        if (IQ.Type.get.equals((Object)packet.getType())) {
            String className = null;
            if (json != null && json.containsKey((Object)"className")) {
                className = json.getString("className");
            }
            String msgContent = null;
            if (json != null && json.containsKey((Object)"msgContent")) {
                msgContent = json.getString("msgContent");
            }
            int pageSize = 10;
            if (json != null && json.containsKey((Object)"pageSize")) {
                pageSize = json.getIntValue("pageSize");
            }
            int pageNumber = 1;
            if (json != null && json.containsKey((Object)"pageNumber")) {
                pageNumber = json.getIntValue("pageNumber");
            }
            int orderBy = 0;
            if (json != null && json.containsKey((Object)"orderBy")) {
                orderBy = json.getIntValue("orderBy");
            }
            Long searchStartTime = null;
            if (json != null && json.containsKey((Object)"startTime")) {
                searchStartTime = json.getLong("startTime");
            }
            Long searchEndTime = null;
            if (json != null && json.containsKey((Object)"endTime")) {
                searchEndTime = json.getLong("endTime");
            }
            result = MsgCollectUtil.getMsgCollectFromDb(username, className, msgContent, pageSize, pageNumber, searchStartTime, searchEndTime, orderBy, fromJID.getResource());
        } else if (IQ.Type.set.equals((Object)packet.getType())) {
            String method = null;
            if (json != null && json.containsKey((Object)"method")) {
                method = json.getString("method");
            }
            if ("saveMsgCollect".equals(method)) {
                String msgId = null;
                if (json != null && json.containsKey((Object)"msgId")) {
                    msgId = json.getString("msgId");
                }
                String className = null;
                if (json != null && json.containsKey((Object)"className")) {
                    className = json.getString("className");
                }
                String msgContent = null;
                if (json != null && json.containsKey((Object)"msgContent")) {
                    msgContent = json.getString("msgContent");
                }
                String collectSource = null;
                if (json != null && json.containsKey((Object)"collectSource")) {
                    collectSource = json.getString("collectSource");
                }
                if (msgContent == null || className == null || msgId == null || collectSource == null) {
                    Log.error("MsgCollect saveMsgCollect ERROR param error,msgContent:{},className:{},msgId:{},collectSource:{}", new Object[]{msgContent, className, msgId, collectSource});
                } else {
                    MsgCollectUtil.saveMsgCollect(username, msgId, msgContent, className, collectSource);
                    result.put("username", username);
                    result.put("msgContent", msgContent);
                    result.put("msgId", msgId);
                    result.put("className", className);
                    result.put("collectSource", collectSource);
                }
            } else if ("deleteMsgCollect".equals(method)) {
                String msgIds = null;
                if (json != null && json.containsKey((Object)"msgIds")) {
                    msgIds = json.getString("msgIds");
                }
                if (msgIds == null || msgIds.isEmpty()) {
                    Log.error("MsgCollect deleteMsgCollect ERROR param error,msgIds:{}", (Object)msgIds);
                } else {
                    MsgCollectUtil.deleteMsgCollect(username, msgIds);
                    result.put("username", username);
                    result.put("msgIds", msgIds);
                }
            }
        }
        ele.addText(JSON.toJSONString(result).toString());
        long endTime = System.currentTimeMillis();
        Log.info("MsgCollect.success:fromUserId:{},params:{},result:{},cost:{} ms", new Object[]{fromJID, json, JSON.toJSONString(result).toString(), endTime - startTime});
        return reply;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }
}

