/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfre.plugin.msgcollect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weaver.cust.qmx.QMXUtil;
import com.weaver.msg.encrypt.EncryptUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.jivesoftware.openfire.plugin.util.DingUtil;
import org.jivesoftware.openfire.plugin.util.JIDUtil;
import org.jivesoftware.util.PersistableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgCollectUtil {
    private static final Logger Log = LoggerFactory.getLogger(MsgCollectUtil.class);
    public static final List<String> GRAY_BAR_TYPE = new ArrayList<String>();
    public static final List<String> FULL_AMOUNT_TYPE;

    public static String[] getMsgCollectSqlByDb(String username, String className, String msgContent, int pageSize, int pageNumber, Long startTime, Long endTime, int orderBy) {
        String[] sqls = null;
        String sqlBack = " a.username,a.createtime,a.collectSource,b.msgId,b.fromUserId,b.classname,b.msgContent,b.targetType,b.targetId,b.imageUri,b.extra,b.fullAmount,b.dateTime ";
        String sqlFrom = " ofMsgCollect a inner join historyMsg b on a.msgId = b.msgId ";
        String sqlWhere = " a.username = ? and (b.isdel is null or b.isdel = '0') ";
        String sqlOrderBy = "";
        sqlOrderBy = orderBy == 0 ? " order by a.createtime desc " : " order by a.createTime ";
        if (className != null && !className.isEmpty()) {
            sqlWhere = sqlWhere + " and a.className = ? ";
        }
        if (msgContent != null && !msgContent.isEmpty()) {
            sqlWhere = sqlWhere + " and a.msgContent like ? ";
            sqlWhere = sqlWhere + "  AND a.className IN ('RC:TxtMsg','FW:attachmentMsg','FW:CustomShareMsg') ";
        }
        if (startTime != null && startTime > 0L) {
            sqlWhere = sqlWhere + " and a.createTime > ? ";
        }
        if (endTime != null && endTime > 0L) {
            sqlWhere = sqlWhere + " and a.createTime < ? ";
        }
        String sqlCount = "select Count(1) as totalCount from " + sqlFrom + " where " + sqlWhere;
        String sql = "SELECT " + sqlBack + " FROM " + sqlFrom + " WHERE " + sqlWhere + sqlOrderBy;
        String sqlByPage = "";
        if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
            sqlByPage = "SELECT  * FROM (SELECT ROW_NUMBER() OVER(" + sqlOrderBy + ")AS rn," + sqlBack + " FROM " + sqlFrom + " WHERE " + sqlWhere + ")AS pageTable WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
        } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
            sqlByPage = "SELECT * FROM (SELECT rownum as rn, pageTable.* FROM (" + sql + ")pageTable) WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
        } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
            sqlByPage = sql + " LIMIT " + (pageNumber - 1) * pageSize + "," + pageSize;
        } else if (DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
            sqlByPage = sql + " LIMIT " + pageSize + " offset " + (pageNumber - 1) * pageSize;
        }
        sqls = new String[]{sqlCount, sqlByPage};
        return sqls;
    }

    private static String[] getMsgCollectSql(String username, String className, String msgContent, int pageSize, int pageNumber, Long startTime, Long endTime, int orderBy) {
        String[] sqls = null;
        String sqlBack = " username,msgId,createtime,collectSource ";
        String sqlFrom = " ofMsgCollect ";
        String sqlWhere = " username = ? ";
        String sqlOrderBy = "";
        sqlOrderBy = orderBy == 0 ? " order by createtime desc " : " order by createTime ";
        if (className != null && !className.isEmpty()) {
            sqlWhere = sqlWhere + " and className = ? ";
        }
        if (msgContent != null && !msgContent.isEmpty()) {
            sqlWhere = sqlWhere + " and msgContent like ? ";
            sqlWhere = sqlWhere + "  AND className IN ('RC:TxtMsg','FW:attachmentMsg','FW:CustomShareMsg') ";
        }
        if (startTime != null && startTime > 0L) {
            sqlWhere = sqlWhere + " and createTime > ? ";
        }
        if (endTime != null && endTime > 0L) {
            sqlWhere = sqlWhere + " and createTime < ? ";
        }
        String sqlCount = "select Count(1) as totalCount from " + sqlFrom + " where " + sqlWhere;
        String sql = "SELECT " + sqlBack + " FROM " + sqlFrom + " WHERE " + sqlWhere + sqlOrderBy;
        String sqlByPage = "";
        if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
            sqlByPage = "SELECT  * FROM (SELECT ROW_NUMBER() OVER(" + sqlOrderBy + ")AS rn," + sqlBack + " FROM " + sqlFrom + " WHERE " + sqlWhere + ")AS pageTable WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
        } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
            sqlByPage = "SELECT * FROM (SELECT rownum as rn, pageTable.* FROM (" + sql + ")pageTable) WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
        } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
            sqlByPage = sql + " LIMIT " + (pageNumber - 1) * pageSize + "," + pageSize;
        } else if (DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
            sqlByPage = sql + " LIMIT " + pageSize + " offset " + (pageNumber - 1) * pageSize;
        }
        sqls = new String[]{sqlCount, sqlByPage};
        return sqls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getMsgCollectFromDb(String username, String className, String msgContent, int pageSize, int pageNumber, Long startTime, Long endTime, int orderBy, String fromResource) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] sqls = MsgCollectUtil.getMsgCollectSqlByDb(username, className, msgContent, pageSize, pageNumber, startTime, endTime, orderBy);
        String sqlCount = sqls[0];
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int totalCount = 0;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sqlCount);
            int i = 0;
            pstmt.setString(++i, username);
            if (className != null && !className.isEmpty()) {
                pstmt.setString(++i, className);
            }
            if (msgContent != null && !msgContent.isEmpty()) {
                pstmt.setString(++i, "%" + msgContent + "%");
            }
            if (startTime != null && startTime > 0L) {
                pstmt.setLong(++i, startTime);
            }
            if (endTime != null && endTime > 0L) {
                pstmt.setLong(++i, endTime);
            }
            long startCount = System.currentTimeMillis();
            rs = pstmt.executeQuery();
            Log.info("getMsgCollect sql Count cost :{} ms", (Object)(System.currentTimeMillis() - startCount));
            if (rs.next()) {
                totalCount = rs.getInt("totalCount");
                result.put("totalCount", totalCount);
                result.put("pageSize", pageSize);
                result.put("pageNumber", pageNumber);
            }
            if (totalCount > 0) {
                SimpleDateFormat SDF_SIMPLE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                SimpleDateFormat SDF_ALL = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                String sqlByPage = sqls[1];
                Log.info("getMsgCollect sqlByPage : {}", (Object)sqlByPage);
                pstmt = con.prepareStatement(sqlByPage);
                int j = 0;
                pstmt.setString(++j, username);
                if (className != null && !className.isEmpty()) {
                    pstmt.setString(++j, className);
                }
                if (msgContent != null && !msgContent.isEmpty()) {
                    pstmt.setString(++j, "%" + msgContent + "%");
                }
                if (startTime != null && startTime > 0L) {
                    pstmt.setLong(++j, startTime);
                }
                if (endTime != null && endTime > 0L) {
                    pstmt.setLong(++j, endTime);
                }
                DatabaseUtil db = new DatabaseUtil();
                String userId = JIDUtil.conNodeToID(username);
                ArrayList msgList = new ArrayList();
                long startPage = System.currentTimeMillis();
                rs = pstmt.executeQuery();
                Log.info("getMsgCollect sql page cost :{} ms", (Object)(System.currentTimeMillis() - startPage));
                while (rs.next()) {
                    int ding_id;
                    DingUtil dingUtil;
                    String msgId = rs.getString("msgId");
                    String collectTime = rs.getString("createtime");
                    String collectSource = rs.getString("collectSource");
                    HashMap<String, String> msgInfo = new HashMap<String, String>();
                    msgInfo.put("fromUserId", rs.getString("fromUserId"));
                    msgInfo.put("targetId", rs.getString("targetId"));
                    String objectName = rs.getString("classname");
                    JSONObject opBody = new JSONObject();
                    opBody.put("objectName", (Object)objectName);
                    opBody.put("msgType", (Object)MsgCollectUtil.getMsgTypeByObjectname(rs.getString("classname")));
                    opBody.put("targetid", (Object)rs.getString("targetId"));
                    opBody.put("targetType", (Object)Integer.toString(rs.getInt("targetType") - 1));
                    opBody.put("toUserid", (Object)rs.getString("fromUserId"));
                    opBody.put("chatdivid", (Object)rs.getString("targetId"));
                    opBody.put("timestamp", (Object)rs.getString("msgId"));
                    String msgContentBd = rs.getString("msgContent");
                    if (EncryptUtil.isEncryptEnable()) {
                        msgContentBd = EncryptUtil.decrypt((String)msgContentBd);
                    }
                    opBody.put("content", (Object)msgContentBd);
                    if ("FW:CMDMsg".equals(objectName) && !(dingUtil = new DingUtil()).chechUserDing(userId, ding_id = dingUtil.getDingIdByMessageContent(msgContentBd))) {
                        String newContent = dingUtil.getDingContent(msgContentBd);
                        opBody.put("content", (Object)newContent);
                        opBody.put("objectName", (Object)"RC:TxtMsg");
                    }
                    opBody.put("imgUrl", (Object)rs.getString("imageUri"));
                    String extra = rs.getString("extra");
                    if (EncryptUtil.isEncryptEnable()) {
                        extra = EncryptUtil.decrypt((String)extra);
                    }
                    opBody.put("extra", (Object)extra);
                    if (DatabaseUtil.GRAY_BAR_TYPE.contains(objectName) || DatabaseUtil.FULL_AMOUNT_TYPE.contains(objectName)) {
                        String fullAmount = rs.getString("fullAmount");
                        if (EncryptUtil.isEncryptEnable()) {
                            fullAmount = EncryptUtil.decrypt((String)fullAmount);
                        }
                        if (fullAmount != null && !fullAmount.isEmpty()) {
                            JSONObject fullAmountObj = JSONObject.parseObject((String)fullAmount);
                            for (String key : fullAmountObj.keySet()) {
                                if (opBody.containsKey((Object)key)) continue;
                                opBody.put(key, (Object)fullAmountObj.getString(key));
                            }
                        }
                    }
                    if (QMXUtil.isEnable((String)username) && "mobile".equals(fromResource)) {
                        if ("RC:ImgMsg".equals(objectName)) {
                            opBody.put("objectName", (Object)"RC:TxtMsg");
                            opBody.put("content", (Object)QMXUtil.imgContent);
                            opBody.put("imgUrl", (Object)"");
                            JSONObject jsonExtra = JSONObject.parseObject((String)extra);
                            jsonExtra.put("imgUrl", (Object)"");
                            jsonExtra.put("fileid", (Object)"");
                            opBody.put("extra", (Object)JSON.toJSONString((Object)jsonExtra));
                        }
                        if ("FW:attachmentMsg".equals(objectName)) {
                            opBody.put("objectName", (Object)"RC:TxtMsg");
                            opBody.put("content", (Object)QMXUtil.fileContent);
                            opBody.put("imgUrl", (Object)"");
                            JSONObject jsonExtra = JSONObject.parseObject((String)extra);
                            jsonExtra.put("imgUrl", (Object)"");
                            jsonExtra.put("fileid", (Object)"");
                            opBody.put("extra", (Object)JSON.toJSONString((Object)jsonExtra));
                        }
                    }
                    msgInfo.put("opBody", opBody.toString());
                    String dateTime = rs.getString("dateTime");
                    Long tempTime = StringUtils.isNumeric((CharSequence)dateTime) ? Long.parseLong(dateTime) : (dateTime.length() == 19 ? SDF_SIMPLE.parse(dateTime).getTime() : SDF_ALL.parse(dateTime).getTime());
                    msgInfo.put("sendTime", String.valueOf(tempTime));
                    opBody.put("sendTime", (Object)String.valueOf(tempTime));
                    if (msgInfo == null || msgInfo.isEmpty()) continue;
                    HashMap<String, Object> msgData = new HashMap<String, Object>();
                    msgData.put("msgId", msgId);
                    msgData.put("collectTime", collectTime);
                    msgData.put("collectSource", collectSource);
                    if (msgInfo != null && msgInfo.containsKey("targetId")) {
                        String targetId = (String)msgInfo.get("targetId");
                        msgInfo.put("secretGroupType", MsgCollectUtil.getSecretGroupType(targetId));
                    }
                    msgData.put("msgInfo", msgInfo);
                    msgList.add(msgData);
                }
                result.put("msgList", msgList);
            }
            result.put("className", className);
            result.put("msgContent", msgContent);
        }
        catch (Exception e) {
            try {
                Log.error("getMsgCollectByDb,error,username:{},msgContent:{},className:{},ERROR:{}", new Object[]{username, msgContent, className, e.getMessage()});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return result;
    }

    private static int getMsgTypeByObjectname(String objectName) {
        int result = 6;
        if ("RC:TxtMsg".equals(objectName)) {
            result = 1;
        } else if ("RC:ImgMsg".equals(objectName)) {
            result = 2;
        } else if ("RC:VcMsg".equals(objectName)) {
            result = 3;
        } else if ("RC:LBSMsg".equals(objectName)) {
            result = 8;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getMsgCollect(String username, String className, String msgContent, int pageSize, int pageNumber, Long startTime, Long endTime, int orderBy, String fromResource) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] sqls = MsgCollectUtil.getMsgCollectSql(username, className, msgContent, pageSize, pageNumber, startTime, endTime, orderBy);
        String sqlCount = sqls[0];
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int totalCount = 0;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sqlCount);
            int i = 0;
            pstmt.setString(++i, username);
            if (className != null && !className.isEmpty()) {
                pstmt.setString(++i, className);
            }
            if (msgContent != null && !msgContent.isEmpty()) {
                pstmt.setString(++i, "%" + msgContent + "%");
            }
            if (startTime != null && startTime > 0L) {
                pstmt.setLong(++i, startTime);
            }
            if (endTime != null && endTime > 0L) {
                pstmt.setLong(++i, endTime);
            }
            long startCount = System.currentTimeMillis();
            rs = pstmt.executeQuery();
            Log.info("getMsgCollect sql Count cost :{} ms", (Object)(System.currentTimeMillis() - startCount));
            while (rs.next()) {
                totalCount = rs.getInt("totalCount");
                result.put("totalCount", totalCount);
                result.put("pageSize", pageSize);
                result.put("pageNumber", pageNumber);
            }
            if (totalCount > 0) {
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                String sqlByPage = sqls[1];
                Log.info("getMsgCollect sqlByPage : {}", (Object)sqlByPage);
                pstmt = con.prepareStatement(sqlByPage);
                int j = 0;
                pstmt.setString(++j, username);
                if (className != null && !className.isEmpty()) {
                    pstmt.setString(++j, className);
                }
                if (msgContent != null && !msgContent.isEmpty()) {
                    pstmt.setString(++j, "%" + msgContent + "%");
                }
                if (startTime != null && startTime > 0L) {
                    pstmt.setLong(++j, startTime);
                }
                if (endTime != null && endTime > 0L) {
                    pstmt.setLong(++j, endTime);
                }
                DatabaseUtil db = new DatabaseUtil();
                String userId = JIDUtil.conNodeToID(username);
                ArrayList msgList = new ArrayList();
                long startPage = System.currentTimeMillis();
                rs = pstmt.executeQuery();
                Log.info("getMsgCollect sql page cost :{} ms", (Object)(System.currentTimeMillis() - startPage));
                while (rs.next()) {
                    String msgId = rs.getString("msgId");
                    String collectTime = rs.getString("createtime");
                    String collectSource = rs.getString("collectSource");
                    Map<String, String> msgInfo = db.getMsgById(msgId, userId, true, fromResource);
                    if (msgInfo != null && !msgInfo.isEmpty()) {
                        HashMap<String, Object> msgData = new HashMap<String, Object>();
                        msgData.put("msgId", msgId);
                        msgData.put("collectTime", collectTime);
                        msgData.put("collectSource", collectSource);
                        if (msgInfo != null && msgInfo.containsKey("targetId")) {
                            String targetId = msgInfo.get("targetId");
                            msgInfo.put("secretGroupType", MsgCollectUtil.getSecretGroupType(targetId));
                        }
                        msgData.put("msgInfo", msgInfo);
                        msgList.add(msgData);
                        continue;
                    }
                    result.put("totalCount", --totalCount);
                    MsgCollectUtil.deleteMsgCollect(username, msgId);
                }
                result.put("msgList", msgList);
            }
            result.put("className", className);
            result.put("msgContent", msgContent);
        }
        catch (Exception e) {
            try {
                Log.error("getMsgCollect,error,username:{},msgContent:{},className:{},ERROR:{}", new Object[]{username, msgContent, className, e.getMessage()});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return result;
    }

    private static String getSecretGroupType(String targetId) {
        String secretGroupType = "0";
        try {
            GroupManager groupManager = GroupManager.getInstance();
            Group group = groupManager.getGroup(targetId);
            PersistableMap groupPropMap = group.getProperties();
            if (groupPropMap != null && groupPropMap.containsKey((Object)"secretGroupType")) {
                secretGroupType = (String)groupPropMap.get((Object)"secretGroupType");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return secretGroupType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteMsgCollect(String username, String msgIds) {
        Log.info("deleteMsgCollection,username:{},msgIds:{}", (Object)username, (Object)msgIds);
        String[] msgIdArr = null;
        msgIdArr = msgIds != null && msgIds.contains(",") ? msgIds.split(",") : new String[]{msgIds};
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("delete from ofMsgCollect where username = ? and msgId = ? ");
            for (String msgId : msgIdArr) {
                pstmt.setString(1, username);
                pstmt.setString(2, msgId);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            pstmt.clearBatch();
        }
        catch (SQLException e) {
            try {
                Log.error("deleteMsgCollection,username:{},msgIds:{},error:{}", new Object[]{username, msgIds, e.getMessage()});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteMsgCollect(String msgId) {
        Log.info("deleteMsgCollection,msgId:{}", (Object)msgId);
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("delete from ofMsgCollect where  msgId = ? ");
            pstmt.setString(1, msgId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("deleteMsgCollection,msgIds:{},error:{}", (Object)msgId, (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveMsgCollect(String username, String msgId, String msgContent, String className, String collectSource) {
        Log.info("saveMsgCollect,username:{},msgId:{},msgContent:{},className:{}", new Object[]{username, msgId, msgContent, className});
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("delete from ofMsgCollect where  msgId = ?  and username = ? ");
            pstmt.setString(1, msgId);
            pstmt.setString(2, username);
            pstmt.executeUpdate();
            DbConnectionManager.closeStatement((Statement)pstmt);
            pstmt = con.prepareStatement("insert into ofMsgCollect (username,msgId,msgContent,className,createTime,collectSource) values(?,?,?,?,?,?)");
            pstmt.setString(1, username);
            pstmt.setString(2, msgId);
            pstmt.setString(3, msgContent);
            pstmt.setString(4, className);
            pstmt.setLong(5, System.currentTimeMillis());
            pstmt.setString(6, collectSource);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("saveMsgCollect error,username:{},msgId:{},msgContent:{},className:{},error:{}", new Object[]{username, msgId, msgContent, className, e.getMessage()});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    static {
        GRAY_BAR_TYPE.add("RC:DizNtf");
        GRAY_BAR_TYPE.add("RC:InfoNtf");
        GRAY_BAR_TYPE.add("FW:InfoNtf");
        GRAY_BAR_TYPE.add("RC:InfoNtfVote");
        FULL_AMOUNT_TYPE = new ArrayList<String>();
        FULL_AMOUNT_TYPE.add("RC:VcMsg");
        FULL_AMOUNT_TYPE.add("RC:LBSMsg");
    }
}

