/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.trace.Trace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.relation.InvalidRelationTypeException;
import javax.management.relation.RelationType;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;

public class RelationTypeSupport
implements RelationType {
    private static final long oldSerialVersionUID = -8179019472410837190L;
    private static final long newSerialVersionUID = 4611072955724144607L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("myTypeName", class$java$lang$String == null ? (class$java$lang$String = RelationTypeSupport.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("myRoleName2InfoMap", class$java$util$HashMap == null ? (class$java$util$HashMap = RelationTypeSupport.class$("java.util.HashMap")) : class$java$util$HashMap), new ObjectStreamField("myIsInRelServFlg", Boolean.TYPE)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("typeName", class$java$lang$String == null ? (class$java$lang$String = RelationTypeSupport.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("roleName2InfoMap", class$java$util$Map == null ? (class$java$util$Map = RelationTypeSupport.class$("java.util.Map")) : class$java$util$Map), new ObjectStreamField("isInRelationService", Boolean.TYPE)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private String typeName = null;
    private Map roleName2InfoMap = new HashMap();
    private boolean isInRelationService = false;
    private static String localClassName;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$Map;

    public RelationTypeSupport(String string, RoleInfo[] roleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        if (string == null || roleInfoArray == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("Constructor: entering", string);
        }
        this.initMembers(string, roleInfoArray);
        if (this.isTraceOn()) {
            this.trace("Constructor: exiting", null);
        }
    }

    protected RelationTypeSupport(String string) {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("Protected constructor: entering", string);
        }
        this.typeName = string;
        if (this.isTraceOn()) {
            this.trace("Protected constructor: exiting", null);
        }
    }

    public String getRelationTypeName() {
        return this.typeName;
    }

    public List getRoleInfos() {
        return new ArrayList(this.roleName2InfoMap.values());
    }

    public RoleInfo getRoleInfo(String string) throws IllegalArgumentException, RoleInfoNotFoundException {
        RoleInfo roleInfo;
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("getRoleInfo: entering", string);
        }
        if ((roleInfo = (RoleInfo)this.roleName2InfoMap.get(string)) == null) {
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = "No role info for role ";
            stringBuffer.append(string3);
            stringBuffer.append(string);
            throw new RoleInfoNotFoundException(stringBuffer.toString());
        }
        if (this.isTraceOn()) {
            this.trace("getRoleInfo: exiting", null);
        }
        return roleInfo;
    }

    protected void addRoleInfo(RoleInfo roleInfo) throws IllegalArgumentException, InvalidRelationTypeException {
        if (roleInfo == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isDebugOn()) {
            this.debug("addRoleInfo: entering", roleInfo.toString());
        }
        if (this.isInRelationService) {
            String string = "Relation type cannot be updated as it is declared in the Relation Service.";
            throw new RuntimeException(string);
        }
        String string = roleInfo.getName();
        if (this.roleName2InfoMap.containsKey(string)) {
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = "Two role infos provided for role ";
            stringBuffer.append(string2);
            stringBuffer.append(string);
            throw new InvalidRelationTypeException(stringBuffer.toString());
        }
        this.roleName2InfoMap.put(string, new RoleInfo(roleInfo));
        if (this.isDebugOn()) {
            this.debug("addRoleInfo: exiting", null);
        }
    }

    void setRelationServiceFlag(boolean bl) {
        this.isInRelationService = bl;
    }

    private void initMembers(String string, RoleInfo[] roleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        if (string == null || roleInfoArray == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isDebugOn()) {
            this.debug("initMembers: entering", string);
        }
        this.typeName = string;
        RelationTypeSupport.checkRoleInfos(roleInfoArray);
        for (int i = 0; i < roleInfoArray.length; ++i) {
            RoleInfo roleInfo = roleInfoArray[i];
            this.roleName2InfoMap.put(new String(roleInfo.getName()), new RoleInfo(roleInfo));
        }
        if (this.isDebugOn()) {
            this.debug("initMembers: exiting", null);
        }
    }

    static void checkRoleInfos(RoleInfo[] roleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        if (roleInfoArray == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (roleInfoArray.length == 0) {
            String string = "No role info provided.";
            throw new InvalidRelationTypeException(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < roleInfoArray.length; ++i) {
            String string;
            RoleInfo roleInfo = roleInfoArray[i];
            if (roleInfo == null) {
                string = "Null role info provided.";
                throw new InvalidRelationTypeException(string);
            }
            string = roleInfo.getName();
            if (arrayList.contains(string)) {
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = "Two role infos provided for role ";
                stringBuffer.append(string2);
                stringBuffer.append(string);
                throw new InvalidRelationTypeException(stringBuffer.toString());
            }
            arrayList.add(string);
        }
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    private void trace(String string, String string2) {
        Trace.send(1, 64, localClassName, string, string2);
        Trace.send(1, 64, "", "", "\n");
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    private void debug(String string, String string2) {
        Trace.send(2, 64, localClassName, string, string2);
        Trace.send(2, 64, "", "", "\n");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (compat) {
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            this.typeName = (String)getField.get("myTypeName", null);
            if (getField.defaulted("myTypeName")) {
                throw new NullPointerException("myTypeName");
            }
            this.roleName2InfoMap = (Map)getField.get("myRoleName2InfoMap", null);
            if (getField.defaulted("myRoleName2InfoMap")) {
                throw new NullPointerException("myRoleName2InfoMap");
            }
            this.isInRelationService = getField.get("myIsInRelServFlg", false);
            if (getField.defaulted("myIsInRelServFlg")) {
                throw new NullPointerException("myIsInRelServFlg");
            }
        } else {
            objectInputStream.defaultReadObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField putField = objectOutputStream.putFields();
            putField.put("myTypeName", this.typeName);
            putField.put("myRoleName2InfoMap", (HashMap)this.roleName2InfoMap);
            putField.put("myIsInRelServFlg", this.isInRelationService);
            objectOutputStream.writeFields();
        } else {
            objectOutputStream.defaultWriteObject();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction getPropertyAction = new GetPropertyAction("jmx.serial.form");
            String string = (String)AccessController.doPrivileged(getPropertyAction);
            compat = string != null && string.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -8179019472410837190L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = 4611072955724144607L;
        }
        localClassName = "RelationTypeSupport";
    }
}

