/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.http.client;

import com.gexin.fastjson.JSON;
import com.gexin.fastjson.parser.Feature;
import com.gexin.fastjson.serializer.SerializerFeature;
import com.gexin.rp.sdk.base.uitls.GZipUtils;
import com.gexin.rp.sdk.http.HttpManager;
import com.gexin.rp.sdk.http.utils.GTConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;

public class GtHttpClient {
    private int httpSoTimeOut;
    private int httpConnectTimeOut;
    private int maxHttpTryTime = 3;
    private Logger logger = Logger.getLogger(HttpManager.class.getName());
    private static boolean isLog = GTConfig.isNeedLog();

    public GtHttpClient(int httpConnectTimeOut, int httpSoTimeOut, int maxHttpTryTime) {
        if (httpConnectTimeOut <= 0) {
            throw new IllegalArgumentException("httpConnectTimeOut must be greater than 0.");
        }
        if (httpSoTimeOut <= 0) {
            throw new IllegalArgumentException("httpSoTimeOut must be greater than 0.");
        }
        if (maxHttpTryTime <= 0) {
            throw new IllegalArgumentException("maxHttpTryTime must be greater than 1.");
        }
        this.httpSoTimeOut = httpSoTimeOut;
        this.httpConnectTimeOut = httpConnectTimeOut;
        this.maxHttpTryTime = maxHttpTryTime;
    }

    public Map<String, Object> executePostJson(String url, Map<String, Object> postJson, boolean postGZip, boolean acceptGZip) throws ProtocolException, IOException, Exception {
        byte[] postData = JSON.toJSONBytes(postJson, (SerializerFeature[])new SerializerFeature[0]);
        byte[] responseData = this.executePostBytes(url, postData, postGZip, acceptGZip, (String)postJson.get("action"));
        return (Map)JSON.parseObject((byte[])responseData, Map.class, (Feature[])new Feature[0]);
    }

    public String executePostString(String url, String postData, boolean postGZip, boolean acceptGZip) throws UnsupportedEncodingException, ProtocolException, IOException, Exception {
        byte[] postDataBytes = postData.getBytes("UTF-8");
        byte[] responseDataBytes = this.executePostBytes(url, postDataBytes, postGZip, acceptGZip, null);
        return new String(responseDataBytes, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] executePostBytes(String url, byte[] postData, boolean postGZip, boolean acceptGZip, String action) throws ProtocolException, IOException, Exception {
        HttpURLConnection connection = this.getHttpURLConnection(url);
        try {
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Type", "text/html;charset=UTF-8");
            if (action != null) {
                connection.setRequestProperty("Gt-Action", action);
            }
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setConnectTimeout(this.httpConnectTimeOut);
            connection.setReadTimeout(this.httpSoTimeOut);
            if (postGZip) {
                postData = GZipUtils.compress((byte[])postData);
                connection.setRequestProperty("Content-Encoding", "gzip");
                connection.setRequestProperty("Content-Length", String.valueOf(postData.length));
            }
            if (acceptGZip) {
                connection.setRequestProperty("Accept-Encoding", "gzip");
            }
            byte[] response = null;
            int tryTime = 0;
            while (tryTime < this.maxHttpTryTime) {
                try {
                    response = GtHttpClient.executePost(connection, postData);
                    break;
                }
                catch (IOException e) {
                    if (++tryTime < this.maxHttpTryTime) continue;
                    throw e;
                }
            }
            if (acceptGZip) {
                byte[] byArray = GZipUtils.decompress(response);
                return byArray;
            }
            byte[] byArray = response;
            return byArray;
        }
        finally {
            connection.disconnect();
        }
    }

    private HttpURLConnection getHttpURLConnection(String urlString) throws MalformedURLException, IOException {
        if (!urlString.toLowerCase().startsWith("http://")) {
            throw new IllegalArgumentException("url(" + urlString + ") must start with \"http://\"");
        }
        URL url = new URL(urlString);
        return (HttpURLConnection)url.openConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] executePost(HttpURLConnection connection, byte[] postData) throws IOException {
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(connection.getOutputStream());
            bos.write(postData);
            bos.flush();
        }
        finally {
            if (bos != null) {
                bos.close();
            }
        }
        int code = connection.getResponseCode();
        if (code == 200) {
            BufferedInputStream bis = null;
            try {
                bis = new BufferedInputStream(connection.getInputStream());
                byte[] result = new byte[bis.available()];
                bis.read(result);
                byte[] byArray = result;
                return byArray;
            }
            finally {
                if (bis != null) {
                    bis.close();
                }
            }
        }
        throw new HttpRetryException("Http Response Error.", code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeHead(String url) throws MalformedURLException, IOException, Exception {
        HttpURLConnection connection = this.getHttpURLConnection(url);
        try {
            connection.setRequestMethod("HEAD");
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Type", "text/html;charset=UTF-8");
            connection.setDoOutput(false);
            connection.setDoInput(true);
            connection.setConnectTimeout(this.httpConnectTimeOut);
            connection.setReadTimeout(this.httpSoTimeOut);
            int tryTime = 0;
            while (tryTime < this.maxHttpTryTime) {
                int code;
                block8: {
                    try {
                        connection.connect();
                        code = connection.getResponseCode();
                        if (code != 200) break block8;
                        boolean bl = true;
                        return bl;
                    }
                    catch (Exception e) {
                        if (++tryTime < this.maxHttpTryTime) continue;
                        throw e;
                    }
                }
                throw new HttpRetryException("Response Code Error", code, url);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            connection.disconnect();
        }
    }
}

