/*
 * Decompiled with CFR 0.152.
 */
package share.jwt.sdk.util;

import com.xiaoleilu.hutool.bean.BeanUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import share.jwt.sdk.entity.AppInfo;
import share.jwt.sdk.entity.LoginUserInfo;

public class JwtTokenUtil {
    public static String getUserIdFromToken(String token, String publicKey) {
        return JwtTokenUtil.getClaimFromToken(token, publicKey).getSubject();
    }

    public static LoginUserInfo getUserInfoFromToken(String token, String publicKey) {
        try {
            Claims claimFromToken = JwtTokenUtil.getClaimFromToken(token, publicKey);
            return (LoginUserInfo)BeanUtil.mapToBean((Map)((LinkedHashMap)claimFromToken.get((Object)"loginUserInfo")), LoginUserInfo.class, (boolean)false);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<AppInfo> getAppInfoList(String token, String publicKey) {
        try {
            Claims claimFromToken = JwtTokenUtil.getClaimFromToken(token, publicKey);
            return (List)claimFromToken.get((Object)"appList");
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date getIssuedAtDateFromToken(String token, String publicKey) {
        return JwtTokenUtil.getClaimFromToken(token, publicKey).getIssuedAt();
    }

    public static Date getExpirationDateFromToken(String token, String publicKey) {
        return JwtTokenUtil.getClaimFromToken(token, publicKey).getExpiration();
    }

    public String getAudienceFromToken(String token, String publicKey) {
        return JwtTokenUtil.getClaimFromToken(token, publicKey).getAudience();
    }

    public String getPrivateClaimFromToken(String token, String key, String publicKey) {
        return JwtTokenUtil.getClaimFromToken(token, publicKey).get((Object)key).toString();
    }

    public static Claims getClaimFromToken(String token, String publicKey) {
        return (Claims)Jwts.parser().setSigningKey(publicKey).parseClaimsJws(token).getBody();
    }

    public static Boolean checkToken(String token, String publicKey) throws JwtException {
        try {
            Jwts.parser().setSigningKey(publicKey).parseClaimsJws(token).getBody();
            return true;
        }
        catch (JwtException e) {
            return false;
        }
    }

    public static Boolean isTokenExpired(String token, String publicKey) {
        try {
            Date expiration = JwtTokenUtil.getExpirationDateFromToken(token, publicKey);
            return expiration.before(new Date());
        }
        catch (ExpiredJwtException expiredJwtException) {
            return true;
        }
    }
}

