/*
 * Decompiled with CFR 0.152.
 */
package share.jwt.sdk.util;

import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Sha1Util {
    public static String SHA1(String decrypt) throws DigestException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(decrypt.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexString.append(0);
                }
                hexString.append(shaHex);
            }
            return hexString.toString().toUpperCase();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new DigestException("\u7b7e\u540d\u9519\u8bef\uff01");
        }
    }

    public static String SHA1(Map<String, Object> maps) throws DigestException {
        String decrypt = Sha1Util.getOrderByLexicographic(maps);
        return Sha1Util.SHA1(decrypt);
    }

    private static String getOrderByLexicographic(Map<String, Object> maps) {
        return Sha1Util.splitParams(Sha1Util.lexicographicOrder(Sha1Util.getParamsName(maps)), maps);
    }

    private static List<String> getParamsName(Map<String, Object> maps) {
        ArrayList<String> paramNames = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : maps.entrySet()) {
            paramNames.add(entry.getKey());
        }
        return paramNames;
    }

    private static List<String> lexicographicOrder(List<String> paramNames) {
        Collections.sort(paramNames);
        return paramNames;
    }

    private static String splitParams(List<String> paramNames, Map<String, Object> maps) {
        StringBuilder paramStr = new StringBuilder();
        for (String paramName : paramNames) {
            paramStr.append(paramName);
            for (Map.Entry<String, Object> entry : maps.entrySet()) {
                if (!paramName.equals(entry.getKey())) continue;
                paramStr.append(String.valueOf(entry.getValue()));
            }
        }
        return paramStr.toString();
    }
}

