/*
 * Decompiled with CFR 0.152.
 */
package share.jwt.sdk.util;

import com.xiaoleilu.hutool.json.JSONArray;
import com.xiaoleilu.hutool.json.JSONObject;
import java.security.DigestException;
import java.util.Map;
import java.util.TreeMap;
import share.jwt.sdk.util.Sha1Util;
import share.jwt.sdk.util.ToolUtil;

public class SignUtil {
    public static String generateSign(String privateKey, Long timeStamp, Map<String, Object> params) {
        if (ToolUtil.isEmpty(privateKey) || timeStamp != null) {
            params.put("_privateKey", privateKey);
            params.put("_timestamp", timeStamp);
        }
        if (ToolUtil.isEmpty(params)) {
            throw new IllegalArgumentException("\u7b7e\u540d\u53c2\u6570\u4e3a\u7a7a!params=" + params);
        }
        StringBuffer buf = new StringBuffer();
        TreeMap<String, Object> requestData = new TreeMap<String, Object>(params);
        for (Map.Entry<String, Object> entry : requestData.entrySet()) {
            if (entry.getValue() == null || entry.getValue() instanceof JSONObject || entry.getValue() instanceof JSONArray) continue;
            buf = buf.append((Object)entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        try {
            return Sha1Util.SHA1(buf.toString()).toUpperCase();
        }
        catch (DigestException e) {
            return null;
        }
    }
}

