/*
 * Decompiled with CFR 0.152.
 */
package share.jwt.sdk.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class ToolUtil {
    public static final int SALT_LENGTH = 6;

    public static String getRandomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static String md5Hex(String password, String salt) {
        return ToolUtil.md5Hex(password + salt);
    }

    public static String md5Hex(String str) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] bs = md5.digest(str.getBytes());
            StringBuffer md5StrBuff = new StringBuffer();
            for (int i = 0; i < bs.length; ++i) {
                if (Integer.toHexString(0xFF & bs[i]).length() == 1) {
                    md5StrBuff.append("0").append(Integer.toHexString(0xFF & bs[i]));
                    continue;
                }
                md5StrBuff.append(Integer.toHexString(0xFF & bs[i]));
            }
            return md5StrBuff.toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u52a0\u5bc6\u5f02\u5e38");
        }
    }

    public static boolean isNotEmpty(Object o) {
        return !ToolUtil.isEmpty(o);
    }

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        return o instanceof String ? o.toString().trim().equals("") : (o instanceof List ? ((List)o).size() == 0 : (o instanceof Map ? ((Map)o).size() == 0 : (o instanceof Set ? ((Set)o).size() == 0 : (o instanceof Object[] ? ((Object[])o).length == 0 : (o instanceof int[] ? ((int[])o).length == 0 : o instanceof long[] && ((long[])o).length == 0)))));
    }

    public static boolean isOneEmpty(Object ... os) {
        for (Object o : os) {
            if (!ToolUtil.isEmpty(o)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllEmpty(Object ... os) {
        for (Object o : os) {
            if (ToolUtil.isEmpty(o)) continue;
            return false;
        }
        return true;
    }

    public static String removeWhiteSpace(String value) {
        if (ToolUtil.isEmpty(value)) {
            return "";
        }
        return value.replaceAll("\\s*", "");
    }

    public static String getIP() {
        try {
            StringBuilder IFCONFIG = new StringBuilder();
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || !inetAddress.isSiteLocalAddress()) continue;
                    IFCONFIG.append(inetAddress.getHostAddress().toString() + "\n");
                }
            }
            return IFCONFIG.toString();
        }
        catch (SocketException ex) {
            ex.printStackTrace();
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static String getExceptionMsg(Throwable e) {
        StringWriter sw = new StringWriter();
        try {
            e.printStackTrace(new PrintWriter(sw));
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return sw.getBuffer().toString().replaceAll("\\$", "T");
    }
}

