/**************************************
https:	"https://localhost:20214/wvbp"
http:	"http://localhost:20213/wvbp" 
**************************************/

var caSdk = {
    policyDefault: {
        // DTE Key
        DTE256SKF: {
            ispadding: 1,
            DevName: 'DTE256SKF_defaultname',
            AppName: 'SKF_DEFAULTAPP',
            ContainerName: 'ExchContainer',
            Sec: '',
            SM3UserID: '1234567812345678',
            IV: 'c8987fb1822fff3a',
            IVLen: 16,
            DeviceType: 1,
        },
        // 龙脉 Key
        LTE256SKF: {
            ispadding: 1,
            DevName: 'LTE256SKF_defaultname',
            AppName: 'WStUsbKey',
            ContainerName: 'ExchContainer',
            Sec: '',
            SM3UserID: '1234567812345678',
            IV: 'c8987fb1822fff3a',
            IVLen: 16,
            DeviceType: 1,
        },
        // 海泰 Key
        HTE256SKF: {
            ispadding: 1,
            DevName: 'HTE256SKF_defaultname',
            AppName: 'WestoneApp',
            ContainerName: 'ExchContainer',
            Sec: '',
            SM3UserID: '1234567812345678',
            IV: 'c8987fb1822fff3a',
            IVLen: 16,
            DeviceType: 1,
        }        
    },
    config: {
        url: 'http://localhost:20213/wvbp', // 默认为http
        urlPoll: "http://localhost:20213/wvbp_poll",
        policyName: '', // 默认设备策略
        devName: '',
        policyValue: {}, // 默认设备
        devListHash:null
    },
    enumDev: function() {
        return enumDev();
    },
    exportUserCert: function(device) {
        return exportUserCert(device);
    },
    changePin: function(device, pin, newPin) {
        return changePin(device, pin, newPin);
    },
    getCertInfo: function(base64EncodeCert, type) {
        return getCertInfo(base64EncodeCert, type);
    },
    signValueData: function(device, inData, pin) {
        return signValueData(device, inData, pin);
    },
    signVerifyData: function(Base64SignCert, OrigData, SignValue) {
        return signVerifyData(Base64SignCert, OrigData, SignValue);
    },
    exportUserList: function(device) {
        return GetUserList(device);
    },
    listenDevChangeEvent: function() {
        return listenDevChangeEvent();
    },
}

// 枚举USBkey设备
function enumDev() {
    var requestData = JSON.stringify({
        mdlId: 'wvbpCryptModule',
        reqId: '1111',
        data: {
            action: 'SOFE_EnumDev',
        },
    });
    var xhr = new XMLHttpRequest();
    xhr.open('post', caSdk.config.url, false);
    xhr.send(requestData);
    if (xhr.readyState == 4 && xhr.status == 200) {
        var responseData = JSON.parse(xhr.responseText);
        return responseData.data.data.split(',');
    }
}

// 设置设备参数
function setConfigPara() {
    var requestData = JSON.stringify({
        mdlId: 'wvbpCryptModule',
        reqId: '1111',
        data: {
            action: 'SOFE_SetConfigPara',
            params: [caSdk.config.policyName, caSdk.config.policyValue],
        },
    });
    var xhr = new XMLHttpRequest();
    xhr.open('post', caSdk.config.url, false);
    xhr.send(requestData);
    if (xhr.readyState == 4 && xhr.status == 200) {
        return xhr.responseText;
    }
}

// 初始化插件
function init() {
    setConfigPara();
    var requestData = JSON.stringify({
        mdlId: 'wvbpCryptModule',
        reqId: '1111',
        data: {
            action: 'SOFE_Init',
            device: caSdk.config.devName,
            policy: caSdk.config.policyName,
            params: [caSdk.config.policyName],
        },
    });
    var xhr = new XMLHttpRequest();
    xhr.open('post', caSdk.config.url, false);
    xhr.send(requestData);
    if (xhr.readyState == 4 && xhr.status == 200) {
        // deleteConfigPara()
        return xhr.responseText;
    }
}

// 删除参数策略
function deleteConfigPara() {
    var requestData = JSON.stringify({
        mdlId: 'wvbpCryptModule',
        reqId: '1111',
        data: {
            action: 'SOFE_DeleteConfigPara',
            params: [caSdk.config.policyName],
        },
    });
    var xhr = new XMLHttpRequest();
    xhr.open('post', caSdk.config.url, false);
    xhr.send(requestData);
    if (xhr.readyState == 4 && xhr.status == 200) {
        return xhr.responseText;
    }
}

// 设置签名算法
function setSignMethod() {
    var requestData = JSON.stringify({
        mdlId: 'wvbpCryptModule',
        reqId: '1111',
        data: {
            action: 'SOF_SetSignMethod',
            policy: caSdk.config.policyName,
            device: caSdk.config.devName,
            params: [131585],
        },
    });
    var xhr = new XMLHttpRequest();
    xhr.open('post', caSdk.config.url, false);
    xhr.send(requestData);
    if (xhr.readyState == 4 && xhr.status == 200) {
        return xhr.responseText;
    }
}

// key登录
function login(pin) {
    var requestData = JSON.stringify({
        mdlId: 'wvbpCryptModule',
        reqId: '1111',
        data: {
            action: 'SOF_Login',
            policy: caSdk.config.policyName,
            device: caSdk.config.devName,
            params: [caSdk.config.policyValue.ContainerName, pin],
        },
    });
    var xhr = new XMLHttpRequest();
    xhr.open('post', caSdk.config.url, false);
    xhr.send(requestData);
    if (xhr.readyState == 4 && xhr.status == 200) {
        result = JSON.parse(xhr.responseText);
        if (
            result.code != 0 ||
            result.data.code != 0 ||
            result.data.data == ''
        ) {
            return GetLastError();
        }
        return result.data.data;
    }
}

// 修改PIN
function changePin(device, pin, newPin) {
    caSdk.config.devName = device;
    var devicePolicy = device.split('_')[0];
    caSdk.config.policyName = devicePolicy;
    caSdk.config.policyValue = caSdk.policyDefault[devicePolicy];
    init();
    var requestData = JSON.stringify({
        mdlId: "wvbpCryptModule",
        reqId: "1111",
        data: {
            action: "SOF_ChangePassWd",
            policy: caSdk.config.policyName,
            device: caSdk.config.devName,
            params: [caSdk.config.policyValue.ContainerName, pin, newPin],
        }
    });
    var xhr = new XMLHttpRequest();
    xhr.open("post", caSdk.config.url, false);
    xhr.send(requestData);
    if (xhr.readyState == 4 && xhr.status == 200) {
        result = JSON.parse(xhr.responseText);
        if (
            result.code != 0 ||
            result.data.code != 0 ||
            result.data.data == ''
        ) {
            return false
        }
        return true
    }
}


// 导出用户证书
function exportUserCert(device) {
    caSdk.config.devName = device;
    var devicePolicy = device.split('_')[0];
    caSdk.config.policyName = devicePolicy;
    caSdk.config.policyValue = caSdk.policyDefault[devicePolicy];
    init();
    var requestData;
    var result;
    requestData = JSON.stringify({
        mdlId: 'wvbpCryptModule',
        reqId: '1111',
        data: {
            action: 'SOF_ExportUserCert',
            policy: caSdk.config.policyName,
            device: caSdk.config.devName,
            params: [caSdk.config.policyValue.ContainerName],
        },
    });
    var xhr = new XMLHttpRequest();
    xhr.open('post', caSdk.config.url, false);
    xhr.send(requestData);
    if (xhr.readyState == 4 && xhr.status == 200) {
        result = JSON.parse(xhr.responseText);
        if (
            result.code != 0 ||
            result.data.code != 0 ||
            result.data.data == ''
        ) {
            return false
        }
        return result.data.data;
    }
}

// 解析证书信息
function getCertInfo(base64EncodeCert, type) {
    var requestData;
    var result;
    requestData = JSON.stringify({
        mdlId: 'wvbpCryptModule',
        reqId: '1111',
        data: {
            action: 'SOF_GetCertInfo',
            policy: caSdk.config.policyName,
            device: caSdk.config.devName,
            params: [base64EncodeCert, type],
        },
    })
    var xhr = new XMLHttpRequest();
    xhr.open('post', caSdk.config.url, false);
    xhr.send(requestData);
    if (xhr.readyState == 4 && xhr.status == 200) {
        result = JSON.parse(xhr.responseText);
        if (
            result.code != 0 ||
            result.data.code != 0 ||
            result.data.data == ''
        ) {
            return false
        }
        return result.data.data;
    }
}

// 对数据签名
function signValueData(device, OrigData, pin) {
    caSdk.config.devName = device;
    var devicePolicy = device.split('_')[0];
    caSdk.config.policyName = devicePolicy;
    caSdk.config.policyValue = caSdk.policyDefault[devicePolicy];
    init();
    var loginResult = login(pin);
    if (loginResult === true) {
        setSignMethod();
        var requestData;
        var result;
        requestData = JSON.stringify({
            mdlId: 'wvbpCryptModule',
            reqId: '1111',
            data: {
                action: 'SOF_SignData',
                policy: caSdk.config.policyName,
                device: caSdk.config.devName,
                params: [caSdk.config.policyValue.ContainerName, OrigData],
            },
        });
        var xhr = new XMLHttpRequest();
        xhr.open('post', caSdk.config.url, false);
        xhr.send(requestData);
        if (xhr.readyState == 4 && xhr.status == 200) {
            result = JSON.parse(xhr.responseText);
            if (
                result.code != 0 ||
                result.data.code != 0 ||
                result.data.data == ''
            ) {
                return false
            }
            return { code: 0, data: result.data.data };
        }
    } else {
        return loginResult;
    }
}

// 对数据验签
function signVerifyData(Base64SignCert, OrigData, SignValue) {
    requestData = JSON.stringify({
        mdlId: 'wvbpCryptModule',
        reqId: '1111',
        data: {
            action: 'SOF_VerifySignedData',
            policy: caSdk.config.policyName,
            device: caSdk.config.devName,
            params: [Base64SignCert, OrigData, SignValue],
        },
    })
    var xhr = new XMLHttpRequest();
    xhr.open('post', caSdk.config.url, false);
    xhr.send(requestData);
    if (xhr.readyState == 4 && xhr.status == 200) {
        result = JSON.parse(xhr.responseText)
        if (
            result.code != 0 ||
            result.data.code != 0 ||
            result.data.data == ''
        ) {
            return false
        }
        return result.data.data
    }
}

function GetUserList(device) {
    caSdk.config.devName = device;
    var devicePolicy = device.split('_')[0];
    caSdk.config.policyName = devicePolicy;
    caSdk.config.policyValue = caSdk.policyDefault[devicePolicy];

    init();
    var requestData;
    var result;
    requestData = JSON.stringify({
        mdlId: 'wvbpCryptModule',
        reqId: '1111',
        data: {
            action: 'SOF_GetUserList',
            policy: caSdk.config.policyName,
            device: caSdk.config.devName,
        },
    })
    var xhr = new XMLHttpRequest();
    xhr.open('post', caSdk.config.url, false);
    xhr.send(requestData);
    if (xhr.readyState == 4 && xhr.status == 200) {
        result = JSON.parse(xhr.responseText);
        if (
            result.code != 0 ||
            result.data.code != 0 ||
            result.data.data == ''
        ) {
            return false
        }
        return result.data.data;
    }
}

// 获取最终错误码
function GetLastError() {
    var requestData;
    var result;
    requestData = JSON.stringify({
        mdlId: "wvbpCryptModule",
        reqId: "1111",
        data: {
            action: "SOF_GetLastError",
            policy: caSdk.config.policyName,
            device: caSdk.config.devName,
            params: [],
        }
    });
    var xhr = new XMLHttpRequest();
    xhr.open("post", caSdk.config.url, false);
    xhr.send(requestData);
    if (xhr.readyState == 4 && xhr.status == 200) {
        result = JSON.parse(xhr.responseText)
        if (
            result.code != 0 ||
            result.data.code != 0 ||
            result.data.data == ''
        ) {
            return false
        }
        if (result.data.data == '167772195') {
            return { code: -1, msg: '设备已移除,请刷新设备列表' };
        } else if (result.data.data == '167772196') {
            return GetPinRetryCount()
        } else if (result.data.data == '167772197') {
            return { code: -1, msg: 'key已被锁死,请联系管理员' };
        } else if (result.data.data == '167772198') {
            return { code: -1, msg: 'PIN无效,请重新输入' };
        } else if (result.data.data == '167772199') {
            return { code: -1, msg: 'pin码错误，长度不正确' };
        } else if (result.data.data === '167772206') {
            return { code: -1, msg: '应用不存在,请检查key中应用是否正确' };
        } else {
            return { code: -1, msg: '登录key失败,请检查pin码或刷新设备列表!' };
        }
    }
}

// pin码错误返回
function GetPinRetryCount() {
    var requestData = JSON.stringify({
        mdlId: "wvbpCryptModule",
        reqId: "1111",
        data: {
            action: "SOF_GetPinRetryCount",
            policy: caSdk.config.policyName,
            device: caSdk.config.devName,
            params: [caSdk.config.policyValue.ContainerName],
        }
    });
    var xhr = new XMLHttpRequest();
    xhr.open("post", caSdk.config.url, false);
    xhr.send(requestData);
    if (xhr.readyState == 4 && xhr.status == 200) {
        result = JSON.parse(xhr.responseText)
        if (result.data.data > 0) {
            return { code: -1, msg: 'pin码不正确,请重新输入,剩余' + result.data.data + '次机会重试' };            
        }
    }
}

// 监听设备
function listenDevChangeEvent() {  
    var requestData = JSON.stringify({  
        mdlId:"wvbpCryptModule",  
        reqId:"1111",  
        data: {  
            action: "listenDevChangeEvent",  
            params: [caSdk.config.devListHash],  
        }  
    });  
    var xhr = new XMLHttpRequest();  
    xhr.open("post", caSdk.config.urlPoll);  
    xhr.timeout = 60*1000;  
    xhr.send(requestData);  
    return new Promise((resolve) => {
        xhr.onreadystatechange = function () {  
            if (xhr.readyState == 4 && xhr.status == 200) {  
                var responseData = JSON.parse(xhr.responseText);  
                if(responseData.data != null && responseData.data.data != null && responseData.data.data.devListHash != null){						
                    if (responseData.data.data.devListHash == caSdk.config.devListHash || caSdk.config.devListHash == null) {                                              
                      resolve("unchange");  
                    } else {
					  resolve("change");
					  return;              
					}                   
                    caSdk.config.devListHash = responseData.data.data.devListHash;  
                }   
            }  
        }  
        xhr.ontimeout = function(e){  
            console.log("time out, ", e);  
            listenDevChangeEvent();  
        }  
    })
}