const fileInput = document.getElementById('problemScreenshot');
const thumbnailContainer = document.getElementById('thumbnailContainer');
const complaintForm = document.getElementById('complaintForm');
const complaintType = document.getElementById('complaintType');
const complaintTypeError = document.getElementById('complaintTypeError');
//const chatRecord = document.getElementById('chatRecord');
//const chatRecordError = document.getElementById('chatRecordError');
const problemDescription = document.getElementById('problemDescription');
const problemDescriptionError = document.getElementById('problemDescriptionError');

fileInput.addEventListener('change', function (e) {
  const files = e.target.files;
  thumbnailContainer.innerHTML = '';
  for (let i = 0; i < files.length; i++) {
    const file = files[i];
    if (file.type.startsWith('image/')) {
      const reader = new FileReader();
      reader.onload = function (event) {
        const img = document.createElement('img');
        img.src = event.target.result;
        img.className = 'thumbnail';
        const deleteBtn = document.createElement('button');
        deleteBtn.className = 'deleteBtn';
        deleteBtn.textContent = 'X';
        deleteBtn.addEventListener('click', function () {
          img.remove();
        });
        img.appendChild(deleteBtn);
        thumbnailContainer.appendChild(img);
      };
      reader.readAsDataURL(file);
    }
  }
});

complaintForm.addEventListener('submit', function (e) {
  e.preventDefault();
	
  let hasError = false;
  const complaintTypeValue = complaintType.value;
  //const chatRecordValue = chatRecord.value;
  const problemDescriptionValue = problemDescription.value;

  if (complaintTypeValue === '') {
    complaintTypeError.textContent = '投诉类型是必填项';
    hasError = true;
  } else {
    complaintTypeError.textContent = '';
  }

  /* if (chatRecordValue === '') {
    chatRecordError.textContent = '聊天记录是必填项';
    hasError = true;
  } else {
    chatRecordError.textContent = '';
  }*/

  if (problemDescriptionValue === '') {
    problemDescriptionError.textContent = '问题描述是必填项';
    hasError = true;
  } else {
    problemDescriptionError.textContent = '';
  }

  if (hasError) {
    return ;
  }
  
  const formData = new FormData();
  formData.append('complaintType', complaintTypeValue);
  // formData.append('chatRecord', chatRecordValue);
  formData.append('problemDescription', problemDescriptionValue);

  const files = fileInput.files;
  for (let i = 0; i < files.length; i++) {
    formData.append('medias', files[i]);
  }

  fetch('/emp/api/complaint/client/record', {
    method: 'POST',
    body: formData
  })
  .then(response => {
    if (response) {
	  alert('提交成功');
	  if (window.em && window.em.checkJsApi('closeWindow')) {
          window.em.closeWindow();
      }
    } else {
      alert('网络请求出错');
    }
  });
});