CREATE TABLE em_sys_baseuser_device (
  id varchar(32) NOT NULL PRIMARY KEY,
  device_name varchar(50),
  client_type tinyint DEFAULT 0,
  device_id varchar(500),
  device_model varchar(500),
  os_version varchar(500),
  binding tinyint DEFAULT NULL,
  last_time TIMESTAMP DEFAULT NULL,
  status tinyint DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_baseuser_device IS '用户设备信息记录表'
;
COMMENT ON COLUMN em_sys_baseuser_device.id IS '主键'
;
COMMENT ON COLUMN em_sys_baseuser_device.device_name IS '设备名称'
;
COMMENT ON COLUMN em_sys_baseuser_device.client_type IS '设备类型：1-PC客户端，2-ios，3-android，4-web'
;
COMMENT ON COLUMN em_sys_baseuser_device.device_id IS '设备标识'
;
COMMENT ON COLUMN em_sys_baseuser_device.device_model IS '设备型号'
;
COMMENT ON COLUMN em_sys_baseuser_device.os_version IS '操作系统信息'
;
COMMENT ON COLUMN em_sys_baseuser_device.binding IS '是否绑定：1-是，0-否'
;
COMMENT ON COLUMN em_sys_baseuser_device.last_time IS '最后登录时间'
;
COMMENT ON COLUMN em_sys_baseuser_device.status IS '状态：1-正常，3-删除'
;
COMMENT ON COLUMN em_sys_baseuser_device.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_baseuser_device.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_baseuser_device.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_baseuser_device.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_baseuser_device.tenant_id IS '企业租户ID'
;