ALTER TABLE em_agent_base ADD    agent_cate tinyint DEFAULT 1
;
ALTER TABLE em_agent_base MODIFY agent_type tinyint DEFAULT 1 
;
ALTER TABLE em_agent_base ADD     home_type tinyint DEFAULT 1 
;
ALTER TABLE em_agent_base ADD     logo_pc  varchar(255) DEFAULT null 
;
alter table em_agent_base rename column open_agent_id to agentid
;
COMMENT ON COLUMN em_agent_base.agent_cate IS '应用种类1:自建应用 2：集成应用'
;
COMMENT ON COLUMN em_agent_base.agent_type IS '应用类型 1：主页型 2：消息型 3：分享型'
;
COMMENT ON COLUMN em_agent_base.home_type IS '应用主页类型:1-打开页面，2-打开第三方APP'
;
COMMENT ON COLUMN em_agent_base.logo_pc IS 'pc端显示图标，不填默认和移动端图标，logo'
;

UPDATE em_agent_base set agent_cate = 1
;
UPDATE em_agent_base set home_type = agent_type
;
UPDATE em_agent_base set agent_type = 2 where enable_msg = 1
;
UPDATE em_agent_base set agent_type = 3 where isshowinmsg = 1
;
UPDATE em_agent_base set agent_type = 1 where enable_home = 1
;
UPDATE em_agent_base set logo = msg_extend_logo where msg_extend_logo is not null and msg_extend_logo<>''
;
UPDATE em_agent_base set logo_pc = msg_extend_logo_pc where msg_extend_logo_pc is not null and msg_extend_logo_pc<>''
;
alter table em_agent_base drop column msg_extend_logo
;
alter table em_agent_base drop column msg_extend_logo_pc
;
alter table em_agent_base drop column enable_msg
;
alter table em_agent_base drop column isshowinmsg
;
alter table em_agent_base drop column enable_home
;
alter table em_agent_base drop column setting_url
;
alter table em_agent_base drop column server_agent_id
;

COMMENT ON COLUMN em_agent_base.associate_outsysid IS '授权相关：应用关联的集成系统'
;
COMMENT ON COLUMN em_agent_base.auth_type IS '授权相关：单点登录方式 1：oauth2 2：SHA1 3：ecology'
;
COMMENT ON COLUMN em_agent_base.auth_access_token IS '授权相关：单点登录秘钥，当auth_type为2时使用'
;
COMMENT ON COLUMN em_agent_base.redirect_domain IS '授权相关：可信域名'
;
COMMENT ON COLUMN em_agent_base.auth_userid_field IS '授权相关：单点登录用户标识字段，当auth_type为2时使用，其中1标识基础用户ID，2标识通讯录userid，3标识通讯录手机号，其他表示自定义字段ID'
;
COMMENT ON COLUMN em_agent_base.auth_outsysid IS '授权相关：单点登录集成系统ID，当auth_type为3时使用，对应em_integrate_outsys_info表的id'
;

COMMENT ON COLUMN em_agent_base.home_type IS '主页信息：应用主页类型:1-打开页面，2-打开第三方APP'
;
COMMENT ON COLUMN em_agent_base.isshowinportal IS '主页信息：是否显示在门户的其他应用分组中 1-显示，0-不显示'
;
COMMENT ON COLUMN em_agent_base.isshowinstore IS '主页信息：是否显示在应用商店中，即所有应用列表中 1-显示，0-不显示'
;
COMMENT ON COLUMN em_agent_base.home_url IS '主页信息：应用主页地址'
;
COMMENT ON COLUMN em_agent_base.home_url_pc IS '主页信息：PC版应用主页地址'
;
COMMENT ON COLUMN em_agent_base.count_url IS '主页信息：统计提示信息数量url地址'
;
COMMENT ON COLUMN em_agent_base.manage_url IS '主页信息：后台管理主页'
;
COMMENT ON COLUMN em_agent_base.ios_pkgname IS '主页信息：第三方APPiOS应用scheme'
;
COMMENT ON COLUMN em_agent_base.ios_downloadurl IS '主页信息：第三方APPiOS应用下载地址'
;
COMMENT ON COLUMN em_agent_base.and_pkgname IS '主页信息：第三方APPAndroid应用包名'
;
COMMENT ON COLUMN em_agent_base.and_downloadurl IS '主页信息：第三方APPAndroid应用下载地址'
;
COMMENT ON COLUMN em_agent_base.app_auth IS '主页信息：第三方APP访问验证参数'
;
COMMENT ON COLUMN em_agent_base.app_gopage IS '主页信息：第三方APP访问直接打开的地址'
;
COMMENT ON COLUMN em_agent_base.msg_url IS '消息信息(消息分享)：消息链接地址'
;
COMMENT ON COLUMN em_agent_base.share_url IS '消息信息(消息分享)：消息分享地址'
;
COMMENT ON COLUMN em_agent_base.dialog_url IS '消息信息：消息主页地址：用户在消息会话列表中点击此应用会话时打开的页面地址，不设置则进入系统默认的消息页面'
;
COMMENT ON COLUMN em_agent_base.status_url IS '消息信息：消息状态接口地址：推送到此应用的消息的状态获取接口地址，例如流程的已处理未处理'
;
COMMENT ON COLUMN em_agent_base.attention_url IS '消息信息：消息提醒设置地址：用户个性化设置消息提醒的页面地址'
;
COMMENT ON COLUMN em_agent_base.msg_extend_url IS '消息分享：消息扩展链接地址'
;
COMMENT ON COLUMN em_agent_base.msg_extend_name IS '消息分享：消息扩展名称，不设置则与应用名称相同'
;
COMMENT ON COLUMN em_agent_base.msg_extend_showorder IS '消息分享：消息扩展排序'
;
COMMENT ON COLUMN em_agent_base.msg_extend_ishead IS '消息分享：应用消息拓展，添加是否显示头'
;
COMMENT ON COLUMN em_agent_base.msg_extend_wwidth IS '消息分享：应用消息拓展，显示窗口宽度'
;
COMMENT ON COLUMN em_agent_base.msg_extend_wheight IS '消息分享：应用消息拓展，显示窗口高度'
;
COMMENT ON COLUMN em_agent_base.msg_extend_ispreload IS '消息分享：消息是否显示预加载'
;