CREATE TABLE em_sys_watermark_setting (
  id varchar(32) NOT NULL  PRIMARY KEY,
  enable_msg_list tinyint DEFAULT NULL ,
  enable_msg_window tinyint DEFAULT NULL ,
  enable_msg_prop tinyint DEFAULT NULL ,
  enable_contact_home tinyint DEFAULT NULL ,
  enable_contact_list tinyint DEFAULT NULL ,
  enable_contact_view tinyint DEFAULT NULL ,
  enable_webview_default tinyint DEFAULT NULL,
  spacing_val int DEFAULT NULL,
  density_val int DEFAULT NULL ,
  content_val1 varchar(100) DEFAULT NULL ,
  font_size1 int DEFAULT NULL ,
  content_val2 varchar(100) DEFAULT NULL ,
  font_size2 int DEFAULT NULL,
  content_val3 varchar(100) DEFAULT NULL,
  font_size3 int DEFAULT NULL,
  status tinyint DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL ,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL ,
  tenant_id varchar(32) DEFAULT NULL
)
;
INSERT INTO em_sys_watermark_setting VALUES ('1', 0, 1, 0, 0, 0, 1, 0, 5, 2, '${username},${mobileL4}', 14, '${date}', 14, null, null, 1, '1', sysdate, null, null, '1')
;
COMMENT ON TABLE em_sys_watermark_setting IS '系统水印设置'
;
COMMENT ON COLUMN em_sys_watermark_setting.enable_msg_list IS '消息会话列表是否启用水印：0-禁用、1-启用'
;
COMMENT ON COLUMN em_sys_watermark_setting.enable_msg_window IS '消息会话窗口是否启用水印：0-禁用、1-启用'
;
COMMENT ON COLUMN em_sys_watermark_setting.enable_msg_prop IS '消息会话属性是否启用水印：0-禁用、1-启用'
;
COMMENT ON COLUMN em_sys_watermark_setting.enable_contact_home IS '通讯录主页是否启用水印：0-禁用、1-启用'
;
COMMENT ON COLUMN em_sys_watermark_setting.enable_contact_list IS  '通讯录列表是否启用水印：0-禁用、1-启用'
;
COMMENT ON COLUMN em_sys_watermark_setting.enable_contact_view IS  '通讯录详情是否启用水印：0-禁用、1-启用'
;
COMMENT ON COLUMN em_sys_watermark_setting.enable_webview_default IS  '加载页面默认是否启用水印：0-禁用、1-启用'
;
COMMENT ON COLUMN em_sys_watermark_setting.spacing_val IS '水印间距值，单位PX'
;
COMMENT ON COLUMN em_sys_watermark_setting.density_val IS '水印密度值，分1、2、3三个等级，数值越大密度越大'
;
COMMENT ON COLUMN em_sys_watermark_setting.content_val1 IS '第一行水印内容，多个标记用逗号分隔，其中变化值用特殊变量表示，如${username}表示用户名、${loginid}表示登录名、${mobile}表示手机号、${mobileL4}表示手机号后四位、${time}表示当前时间等'
;
COMMENT ON COLUMN em_sys_watermark_setting.font_size1 IS '第一行字体大小，单位PX'
;
COMMENT ON COLUMN em_sys_watermark_setting.content_val2 IS '第二行水印内容，多个标记用逗号分隔，其中变化值用特殊变量表示，如${username}表示用户名、${loginid}表示登录名、${mobile}表示手机号、${mobileL4}表示手机号后四位、${time}表示当前时间等'
;
COMMENT ON COLUMN em_sys_watermark_setting.font_size2 IS '第二行字体大小，单位PX'
;
COMMENT ON COLUMN em_sys_watermark_setting.content_val3 IS '第三行水印内容，多个标记用逗号分隔，其中变化值用特殊变量表示，如${username}表示用户名、${loginid}表示登录名、${mobile}表示手机号、${mobileL4}表示手机号后四位、${time}表示当前时间等'
;
COMMENT ON COLUMN em_sys_watermark_setting.font_size3 IS '第三行字体大小，单位PX'
;
COMMENT ON COLUMN em_sys_watermark_setting.status IS '状态：1-正常、3-删除'
;
COMMENT ON COLUMN em_sys_watermark_setting.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_watermark_setting.create_user_id IS  '创建时间'
;
COMMENT ON COLUMN em_sys_watermark_setting.create_time IS  '修改人'
;
COMMENT ON COLUMN em_sys_watermark_setting.update_time IS  '修改时间'
;
COMMENT ON COLUMN em_sys_watermark_setting.tenant_id IS  '企业租户ID'
;