CREATE TABLE em_cp_corp (
  id varchar(32) NOT NULL PRIMARY KEY,
  corp_name varchar(50) DEFAULT NULL,
  open_corp_id varchar(100) DEFAULT NULL,
  corp_secret varchar(100) DEFAULT NULL,
  cp_type tinyint DEFAULT NULL,
  api_url_base varchar(200) DEFAULT NULL,
  api_url_user varchar(200) DEFAULT NULL,
  api_url_msg varchar(200) DEFAULT NULL,
  api_url_token varchar(200) DEFAULT NULL,
  customer_name varchar(200) DEFAULT NULL,
  industry varchar(200) DEFAULT NULL,
  corp_desc varchar(500) DEFAULT NULL,
  status tinyint DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_corp IS '企业号基本信息表'
;
COMMENT ON COLUMN em_cp_corp.id  IS '主键ID'
;
COMMENT ON COLUMN em_cp_corp.corp_name  IS '企业号名称'
;
COMMENT ON COLUMN em_cp_corp.open_corp_id  IS '企业号CORPID'
;
COMMENT ON COLUMN em_cp_corp.corp_secret  IS '企业号秘钥'
;
COMMENT ON COLUMN em_cp_corp.cp_type  IS '企业号类型：1-企业微信、2-钉钉、3-简聊、4-蓝信、5-工作宝、8-金蝶云之家'
;
COMMENT ON COLUMN em_cp_corp.api_url_base  IS '企业号基础接口api地址'
;
COMMENT ON COLUMN em_cp_corp.api_url_user  IS '企业号获取用户信息接口api地址'
;
COMMENT ON COLUMN em_cp_corp.api_url_msg  IS '企业号消息推送接口api地址'
;
COMMENT ON COLUMN em_cp_corp.api_url_token  IS '企业号获取token接口api地址'
;
COMMENT ON COLUMN em_cp_corp.customer_name  IS '客户名称'
;
COMMENT ON COLUMN em_cp_corp.industry  IS '行业类型'
;
COMMENT ON COLUMN em_cp_corp.corp_desc  IS '企业号描述信息'
;
COMMENT ON COLUMN em_cp_corp.status  IS '状态：1-正常、3-删除'
;
COMMENT ON COLUMN em_cp_corp.create_user_id  IS '创建人'
;
COMMENT ON COLUMN em_cp_corp.create_time  IS '创建时间'
;
COMMENT ON COLUMN em_cp_corp.update_user_id  IS '修改人'
;
COMMENT ON COLUMN em_cp_corp.update_time  IS '修改时间'
;
COMMENT ON COLUMN em_cp_corp.tenant_id  IS '企业租户ID'
;
CREATE OR REPLACE INDEX em_cp_corp_tenant_id_index ON em_cp_corp(tenant_id)
;


CREATE TABLE em_cp_agent (
  id varchar(32) NOT NULL PRIMARY KEY,
  cp_corp_id varchar(32) DEFAULT NULL,
  agent_name varchar(50) DEFAULT NULL,
  open_agent_id varchar(50) DEFAULT NULL,
  agent_secret varchar(100) DEFAULT NULL,
  agent_desc varchar(500) DEFAULT NULL,
  callback_token varchar(500) DEFAULT NULL,
  callback_aeskey varchar(500) DEFAULT NULL,
  redirect_domain varchar(500) DEFAULT NULL,
  report_location_flag tinyint DEFAULT 0,
  report_user tinyint DEFAULT 0,
  report_msg tinyint DEFAULT 0,
  auth_type tinyint DEFAULT 1,
  auth_secret varchar(100) DEFAULT NULL,
  status tinyint DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL ,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL ,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_agent IS '企业号应用信息表'
;
COMMENT ON COLUMN em_cp_agent.cp_corp_id IS '企业号基本信息ID'
;
COMMENT ON COLUMN em_cp_agent.agent_name IS '应用名称'
;
COMMENT ON COLUMN em_cp_agent.open_agent_id IS '应用ID'
;
COMMENT ON COLUMN em_cp_agent.agent_secret IS '应用秘钥'
;
COMMENT ON COLUMN em_cp_agent.agent_desc IS '应用描述信息'
;
COMMENT ON COLUMN em_cp_agent.callback_token IS '回调令牌'
;
COMMENT ON COLUMN em_cp_agent.callback_aeskey IS '回调秘钥'
;
COMMENT ON COLUMN em_cp_agent.redirect_domain IS '可信域名'
;
COMMENT ON COLUMN em_cp_agent.report_location_flag IS '是否上报地理位置：1-是，0-否'
;
COMMENT ON COLUMN em_cp_agent.report_user IS '是否上报用户状态：1-是，0-否'
;
COMMENT ON COLUMN em_cp_agent.report_msg IS '是否上报用户消息：1-是，0-否'
;
COMMENT ON COLUMN em_cp_agent.auth_type IS '身份认证类型 1-auth2，2-SHA1，3-auth_code'
;
COMMENT ON COLUMN em_cp_agent.auth_secret IS '身份认证秘钥，主要针对auth_type为2的情况'
;
COMMENT ON COLUMN em_cp_agent.status  IS '状态：1-正常、3-删除'
;
COMMENT ON COLUMN em_cp_agent.create_user_id  IS '创建人'
;
COMMENT ON COLUMN em_cp_agent.create_time  IS '创建时间'
;
COMMENT ON COLUMN em_cp_agent.update_user_id  IS '修改人'
;
COMMENT ON COLUMN em_cp_agent.update_time  IS '修改时间'
;
COMMENT ON COLUMN em_cp_agent.tenant_id  IS '企业租户ID'
;
CREATE OR REPLACE INDEX em_cp_agent_open_agent_id_index ON em_cp_agent(open_agent_id)
;
CREATE OR REPLACE INDEX em_cp_agent_cp_corp_id_index ON em_cp_agent(cp_corp_id)
;
CREATE OR REPLACE INDEX em_cp_agent_tenant_id_index ON em_cp_agent(tenant_id)
;

CREATE TABLE em_cp_dept (
  id varchar(32) NOT NULL PRIMARY KEY,
  cp_corp_id varchar(32) DEFAULT NULL,
  open_dept_id varchar(100) DEFAULT NULL,
  dept_name varchar(100) DEFAULT NULL,
  parent_id varchar(100) DEFAULT NULL,
  all_parent_ids varchar(1000) DEFAULT NULL,
  outsys_id varchar(32) DEFAULT NULL,
  outsys_dept_type tinyint DEFAULT NULL,
  outsys_dept_id varchar(32) DEFAULT NULL,
  showorder decimal(10,2) DEFAULT NULL,
  status tinyint DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL ,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_dept IS '企业号通讯录部门表'
;
COMMENT ON COLUMN em_cp_dept.id IS '主键ID'
;
COMMENT ON COLUMN em_cp_dept.cp_corp_id IS '企业号基本信息ID'
;
COMMENT ON COLUMN em_cp_dept.open_dept_id IS '企业号中的部门ID'
;
COMMENT ON COLUMN em_cp_dept.dept_name IS '部门名称'
;
COMMENT ON COLUMN em_cp_dept.parent_id IS '上级部门ID'
;
COMMENT ON COLUMN em_cp_dept.all_parent_ids IS '所有上级部门ID用逗号分隔'
;
COMMENT ON COLUMN em_cp_dept.outsys_id IS '对应集成系统的ID'
;
COMMENT ON COLUMN em_cp_dept.outsys_dept_type IS '对应集成系统部门类型：1-分部，2-部门'
;
COMMENT ON COLUMN em_cp_dept.outsys_dept_id IS '对应集成系统部门ID'
;
COMMENT ON COLUMN em_cp_dept.showorder IS '显示顺序'
;
COMMENT ON COLUMN em_cp_dept.status  IS '状态：1-正常、3-删除'
;
COMMENT ON COLUMN em_cp_dept.create_user_id  IS '创建人'
;
COMMENT ON COLUMN em_cp_dept.create_time  IS '创建时间'
;
COMMENT ON COLUMN em_cp_dept.update_user_id  IS '修改人'
;
COMMENT ON COLUMN em_cp_dept.update_time  IS '修改时间'
;
COMMENT ON COLUMN em_cp_dept.tenant_id  IS '企业租户ID'
;
CREATE OR REPLACE INDEX em_cp_dept_open_dept_id_index ON em_cp_dept(open_dept_id)
;
CREATE OR REPLACE INDEX em_cp_dept_parent_id_index ON em_cp_dept(parent_id)
;
CREATE OR REPLACE INDEX em_cp_dept_tenant_id_index ON em_cp_dept(tenant_id)
;

CREATE TABLE em_cp_user (
  id varchar(32) NOT NULL PRIMARY KEY,
  cp_corp_id varchar(32) DEFAULT NULL,
  open_user_id varchar(100) DEFAULT NULL,
  user_name varchar(100) DEFAULT NULL,
  nick_name varchar(100) DEFAULT NULL,
  english_name varchar(100) DEFAULT NULL,
  mobile varchar(50) DEFAULT NULL,
  position varchar(100) DEFAULT NULL,
  gender tinyint DEFAULT NULL,
  email varchar(100) DEFAULT NULL,
  telephone varchar(100) DEFAULT NULL,
  avatar varchar(500) DEFAULT NULL,
  showorder decimal(10,2) DEFAULT NULL,
  issync tinyint DEFAULT NULL,
   customfield CLOB DEFAULT NULL,
  corp_status tinyint DEFAULT NULL,
  isadmin tinyint DEFAULT NULL,
  last_sync_status tinyint DEFAULT NULL,
  last_sync_error varchar(500) DEFAULT NULL,
  status tinyint DEFAULT NULL ,
  create_user_id varchar(32) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL ,
  update_time TIMESTAMP DEFAULT NULL ,
  base_user_id varchar(32) DEFAULT NULL ,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_user IS '企业号通讯录成员表'
;
COMMENT ON COLUMN em_cp_user.id IS '主键ID'
;
COMMENT ON COLUMN em_cp_user.cp_corp_id IS '企业号基本信息ID'
;
COMMENT ON COLUMN em_cp_user.open_user_id IS '用户在企业号内的唯一标识'
;
COMMENT ON COLUMN em_cp_user.user_name IS '姓名'
;
COMMENT ON COLUMN em_cp_user.nick_name IS '昵称'
;
COMMENT ON COLUMN em_cp_user.english_name IS '英文名'
;
COMMENT ON COLUMN em_cp_user.mobile IS '手机'
;
COMMENT ON COLUMN em_cp_user.position IS '岗位'
;
COMMENT ON COLUMN em_cp_user.gender IS '性别 1表示男性，2表示女性，0表示未知'
;
COMMENT ON COLUMN em_cp_user.email IS '邮箱'
;
COMMENT ON COLUMN em_cp_user.telephone IS '座机'
;
COMMENT ON COLUMN em_cp_user.avatar IS '头像'
;
COMMENT ON COLUMN em_cp_user.showorder IS '显示顺序'
;
COMMENT ON COLUMN em_cp_user.issync IS '是否已添加到企业号通讯录 1-是，0-否'
;
COMMENT ON COLUMN em_cp_user.customfield IS '自定义字段'
;
COMMENT ON COLUMN em_cp_user.corp_status IS '企业号通讯录中的状态'
;
COMMENT ON COLUMN em_cp_user.isadmin IS '是否为企业的管理员 1-是，0-否'
;
COMMENT ON COLUMN em_cp_user.last_sync_status IS '最后同步到企业号中的状态：0-成功，1-失败'
;
COMMENT ON COLUMN em_cp_user.last_sync_error IS '最后同步到企业号中失败的信息'
;
COMMENT ON COLUMN em_cp_user.status  IS '状态：1-正常、3-删除'
;
COMMENT ON COLUMN em_cp_user.create_user_id  IS '创建人'
;
COMMENT ON COLUMN em_cp_user.create_time  IS '创建时间'
;
COMMENT ON COLUMN em_cp_user.update_user_id  IS '修改人'
;
COMMENT ON COLUMN em_cp_user.update_time  IS '修改时间'
;
COMMENT ON COLUMN em_cp_user.base_user_id  IS '基础用户ID'
;
COMMENT ON COLUMN em_cp_user.tenant_id  IS '企业租户ID'
;
CREATE OR REPLACE INDEX em_cp_user_open_user_id_index ON em_cp_user(open_user_id)
;
CREATE OR REPLACE INDEX em_cp_user_base_user_id_index ON em_cp_user(base_user_id)
;
CREATE OR REPLACE INDEX em_cp_user_tenant_id_index ON em_cp_user(tenant_id)
;

CREATE TABLE em_cp_dept_user (
  id varchar(32) NOT NULL PRIMARY KEY,
  cp_user_id varchar(32) DEFAULT NULL,
  cp_dept_id varchar(32) DEFAULT NULL,
  position varchar(100) DEFAULT NULL,
  showorder decimal(10,2) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_dept_user IS '企业号通讯录成员与部门关联表'
;
COMMENT ON COLUMN em_cp_dept_user.id IS '主键ID'
;
COMMENT ON COLUMN em_cp_dept_user.cp_user_id IS '通讯录人员表ID'
;
COMMENT ON COLUMN em_cp_dept_user.cp_dept_id IS '通讯录部门表ID'
;
COMMENT ON COLUMN em_cp_dept_user.position IS '岗位信息'
;
COMMENT ON COLUMN em_cp_dept_user.showorder IS '显示顺序'
;
COMMENT ON COLUMN em_cp_dept_user.create_user_id  IS '创建人'
;
COMMENT ON COLUMN em_cp_dept_user.create_time  IS '创建时间'
;
COMMENT ON COLUMN em_cp_dept_user.update_user_id  IS '修改人'
;
COMMENT ON COLUMN em_cp_dept_user.update_time  IS '修改时间'
;
COMMENT ON COLUMN em_cp_dept_user.tenant_id  IS '企业租户ID'
;
CREATE OR REPLACE INDEX em_cp_dept_user_cp_user_id_index ON em_cp_dept_user(cp_user_id)
;
CREATE OR REPLACE INDEX em_cp_dept_user_cp_dept_id_index ON em_cp_dept_user(cp_dept_id)
;
CREATE OR REPLACE INDEX em_cp_dept_user_tenant_id_index ON em_cp_dept_user(tenant_id)
;

CREATE TABLE em_cp_user_account (
  id varchar(32) NOT NULL  PRIMARY KEY,
  cp_user_id varchar(32) DEFAULT NULL,
  outsys_id varchar(32) DEFAULT NULL,
  outsys_user_id varchar(32) DEFAULT NULL,
  outsys_user_name varchar(50) DEFAULT NULL,
  status tinyint DEFAULT 1 ,
  create_user_id varchar(32) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL ,
  update_time TIMESTAMP DEFAULT NULL ,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_user_account IS '通讯录成员与集成系统人员关联表'
;
COMMENT ON COLUMN em_cp_user_account.id IS '主键ID'
;
COMMENT ON COLUMN em_cp_user_account.cp_user_id IS '用户ID'
;
COMMENT ON COLUMN em_cp_user_account.outsys_id IS '集成系统ID'
;
COMMENT ON COLUMN em_cp_user_account.outsys_user_id IS '集成系统中的用户ID'
;
COMMENT ON COLUMN em_cp_user_account.outsys_user_name IS '集成系统中的用户姓名'
;
COMMENT ON COLUMN em_cp_user_account.status  IS '状态：1-正常、3-删除'
;
COMMENT ON COLUMN em_cp_user_account.create_user_id  IS '创建人'
;
COMMENT ON COLUMN em_cp_user_account.create_time  IS '创建时间'
;
COMMENT ON COLUMN em_cp_user_account.update_user_id  IS '修改人'
;
COMMENT ON COLUMN em_cp_user_account.update_time  IS '修改时间'
;
COMMENT ON COLUMN em_cp_user_account.tenant_id  IS '企业租户ID'
;
CREATE OR REPLACE INDEX em_cp_user_account_cp_user_id_index ON em_cp_user_account(cp_user_id)
;
CREATE OR REPLACE INDEX em_cp_user_account_outsys_user_id_index ON em_cp_user_account(outsys_user_id)
;
CREATE OR REPLACE INDEX em_cp_user_account_tenant_id_index ON em_cp_user_account(tenant_id)
;

CREATE TABLE em_cp_link (
  id varchar(32) NOT NULL PRIMARY KEY,
  cp_corp_id varchar(32) DEFAULT NULL ,
  cp_agent_id varchar(32) DEFAULT NULL,
  link_name varchar(50) DEFAULT NULL,
  link_desc varchar(500) DEFAULT NULL,
  link_type tinyint DEFAULT NULL,
  link_menu_key varchar(50) DEFAULT NULL,
  link_menu_pid varchar(32) DEFAULT NULL,
  link_action_type tinyint DEFAULT NULL,
  link_action_setting varchar(100) DEFAULT NULL,
  showorder int DEFAULT NULL,
  status tinyint DEFAULT 1 ,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_link IS '企业号链接功能信息表'
;
COMMENT ON COLUMN em_cp_link.id IS '主键ID'
;
COMMENT ON COLUMN em_cp_link.cp_corp_id IS '所属企业号ID'
;
COMMENT ON COLUMN em_cp_link.cp_agent_id IS '所属企业号应用ID'
;
COMMENT ON COLUMN em_cp_link.link_name IS '链接名称'
;
COMMENT ON COLUMN em_cp_link.link_desc IS '链接描述信息'
;
COMMENT ON COLUMN em_cp_link.link_type IS '链接类型： 1-应用主页，2-应用菜单，3-普通链接'
;
COMMENT ON COLUMN em_cp_link.link_menu_key IS 'link_type为2时对应的菜单key值'
;
COMMENT ON COLUMN em_cp_link.link_menu_pid IS 'link_type为2时对应的菜单的上级ID'
;
COMMENT ON COLUMN em_cp_link.link_action_type IS '链接动作类型： 1-打开门户，2-打开应用，3-自定义链接'
;
COMMENT ON COLUMN em_cp_link.link_action_setting IS '链接动作参数值，link_action_type为1时表示门户ID，link_action_type为2时表示应用ID，link_action_type为3时表示自定义链接地址'
;
COMMENT ON COLUMN em_cp_link.showorder IS '显示顺序'
;
COMMENT ON COLUMN em_cp_link.status  IS '状态：1-正常、3-删除'
;
COMMENT ON COLUMN em_cp_link.create_user_id  IS '创建人'
;
COMMENT ON COLUMN em_cp_link.create_time  IS '创建时间'
;
COMMENT ON COLUMN em_cp_link.update_user_id  IS '修改人'
;
COMMENT ON COLUMN em_cp_link.update_time  IS '修改时间'
;
COMMENT ON COLUMN em_cp_link.tenant_id  IS '企业租户ID'
;
CREATE OR REPLACE INDEX em_cp_link_cp_agent_id_index ON em_cp_link(cp_agent_id)
;
CREATE OR REPLACE INDEX em_cp_link_tenant_id_index ON em_cp_link(tenant_id)
;

CREATE TABLE em_cp_msg_rule (
  id varchar(32) NOT NULL PRIMARY KEY,
  cp_corp_id varchar(32) DEFAULT NULL,
  rule_name varchar(50) DEFAULT NULL,
  rule_desc varchar(500) DEFAULT NULL,
  cp_agent_id varchar(32) DEFAULT NULL,
  relate_agent_id varchar(32) DEFAULT NULL,
  status tinyint DEFAULT 1,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL ,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_msg_rule IS '企业号消息推送规则设置表'
;
COMMENT ON COLUMN em_cp_msg_rule.id  IS '主键ID'
;
COMMENT ON COLUMN em_cp_msg_rule.cp_corp_id  IS '所属企业号ID'
;
COMMENT ON COLUMN em_cp_msg_rule.rule_name  IS '规则名称'
;
COMMENT ON COLUMN em_cp_msg_rule.rule_desc  IS '规则描述信息'
;
COMMENT ON COLUMN em_cp_msg_rule.cp_agent_id  IS '推送目标，即企业号应用ID'
;
COMMENT ON COLUMN em_cp_msg_rule.relate_agent_id  IS '关联的本地消息型应用ID'
;
COMMENT ON COLUMN em_cp_msg_rule.status  IS '状态：1-正常、3-删除'
;
COMMENT ON COLUMN em_cp_msg_rule.create_user_id  IS '创建人'
;
COMMENT ON COLUMN em_cp_msg_rule.create_time  IS '创建时间'
;
COMMENT ON COLUMN em_cp_msg_rule.update_user_id  IS '修改人'
;
COMMENT ON COLUMN em_cp_msg_rule.update_time  IS '修改时间'
;
COMMENT ON COLUMN em_cp_msg_rule.tenant_id  IS '企业租户ID'
;
CREATE OR REPLACE INDEX em_cp_msg_rule_cp_agent_id_index ON em_cp_msg_rule(cp_agent_id)
;

CREATE TABLE em_cp_msg_log (
  id varchar(32) PRIMARY KEY,
  cp_corp_id varchar(32) DEFAULT NULL,
  cp_agent_id varchar(32) DEFAULT NULL,
  relate_agent_id varchar(32) DEFAULT NULL,
  msg_json CLOB DEFAULT NULL,
  msg_data_id varchar(50) DEFAULT NULL,
  msg_data_type tinyint DEFAULT NULL,
  link_url varchar(500) DEFAULT NULL,
  link_url_pc varchar(500) DEFAULT NULL,
  im_msg_id CLOB DEFAULT NULL,
  tousers CLOB DEFAULT NULL,
  sende_time TIMESTAMP DEFAULT NULL,
  status tinyint DEFAULT 1 ,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_msg_log IS '企业号推送消息信息表'
;
COMMENT ON COLUMN em_cp_msg_log.id  IS '主键ID'
;
COMMENT ON COLUMN em_cp_msg_log.cp_corp_id  IS '所属企业号ID'
;
COMMENT ON COLUMN em_cp_msg_log.cp_agent_id  IS '所属企业号应用ID'
;
COMMENT ON COLUMN em_cp_msg_log.relate_agent_id  IS '关联的本地消息型应用ID'
;
COMMENT ON COLUMN em_cp_msg_log.msg_json  IS '消息内容'
;
COMMENT ON COLUMN em_cp_msg_log.msg_data_id  IS '消息数据ID'
;
COMMENT ON COLUMN em_cp_msg_log.msg_data_type  IS '消息数据类型'
;
COMMENT ON COLUMN em_cp_msg_log.link_url  IS '链接地址'
;
COMMENT ON COLUMN em_cp_msg_log.link_url_pc  IS 'PC端链接地址'
;
COMMENT ON COLUMN em_cp_msg_log.im_msg_id  IS 'IM返回的消息ID'
;
COMMENT ON COLUMN em_cp_msg_log.tousers  IS '消息接收者'
;
COMMENT ON COLUMN em_cp_msg_log.sende_time  IS '发送时间'
;
COMMENT ON COLUMN em_cp_msg_log.status  IS '状态：1-正常、3-删除'
;
COMMENT ON COLUMN em_cp_msg_log.create_user_id  IS '创建人'
;
COMMENT ON COLUMN em_cp_msg_log.create_time  IS '创建时间'
;
COMMENT ON COLUMN em_cp_msg_log.update_user_id  IS '修改人'
;
COMMENT ON COLUMN em_cp_msg_log.update_time  IS '修改时间'
;
COMMENT ON COLUMN em_cp_msg_log.tenant_id  IS '企业租户ID'
;
CREATE OR REPLACE INDEX em_cp_msg_log_cp_agent_id_index ON em_cp_msg_log(cp_agent_id)
;
CREATE OR REPLACE INDEX em_cp_msg_log_relate_agent_id_index ON em_cp_msg_log(relate_agent_id)
;
CREATE OR REPLACE INDEX em_cp_msg_log_msg_data_id_index ON em_cp_msg_log(msg_data_id)
;
CREATE OR REPLACE INDEX em_cp_msg_log_msg_data_type_index ON em_cp_msg_log(msg_data_type)
;
CREATE OR REPLACE INDEX em_cp_msg_log_sende_time_index ON em_cp_msg_log(sende_time)
;