CREATE TABLE em_cp_user_sync_set (
  id varchar(32) NOT NULL PRIMARY KEY,
  sys_task_id varchar(32) DEFAULT NULL,
  cp_corp_id varchar(32) DEFAULT NULL,
  sync_type tinyint DEFAULT 1,
  cp_dept_id varchar(32) DEFAULT NULL,
  bind_type tinyint DEFAULT 0 ,
  root_dept_id varchar(32) DEFAULT NULL,
  add_type tinyint DEFAULT 1,
  invite_type tinyint DEFAULT 0,
  userid_field tinyint DEFAULT 1,
  user_del_type tinyint DEFAULT 1,
  dept_sync_type tinyint DEFAULT 1,
  isalluser tinyint DEFAULT 0,
  match_user_field tinyint DEFAULT 1,
  match_outsys_field tinyint DEFAULT 1 ,
  outsys_id varchar(32) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_user_sync_set IS '企业号通讯录成员同步设置表'
;
COMMENT ON COLUMN em_cp_user_sync_set.id  IS '主键ID'
;
COMMENT ON COLUMN em_cp_user_sync_set.sys_task_id  IS '定时同步任务ID'
;
COMMENT ON COLUMN em_cp_user_sync_set.cp_corp_id  IS '企业号基本信息ID'
;
COMMENT ON COLUMN em_cp_user_sync_set.sync_type  IS '同步类型：1-从企业号同步 ，2-从集成系统同步'
;
COMMENT ON COLUMN em_cp_user_sync_set.cp_dept_id  IS '从企业号同步时对应的部门ID，当sync_type为1时需要此值，不设置则为企业号获取到的顶级部门'
;
COMMENT ON COLUMN em_cp_user_sync_set.bind_type  IS '新成员关联集成系统用户类型：0-不关联，1-自动关联 ，2-手动关联，3-先自动后手动，当sync_type为1时需要此值'
;
COMMENT ON COLUMN em_cp_user_sync_set.root_dept_id  IS '集成系统部门对应的顶级部门ID，即em_cp_dept表主键ID，当sync_type为2时需要此值'
;
COMMENT ON COLUMN em_cp_user_sync_set.add_type  IS '新成员是否添加到企业号：1-是 ，0-否，当sync_type为2时需要此值'
;
COMMENT ON COLUMN em_cp_user_sync_set.invite_type  IS '新成员是否邀请加入，主要针对企业微信：1-是 ，0-否，当sync_type为2时需要此值'
;
COMMENT ON COLUMN em_cp_user_sync_set.userid_field  IS '新成员账号字段：1-数据库ID ，2-登录账号，3-手机号，当sync_type为2时需要此值'
;
COMMENT ON COLUMN em_cp_user_sync_set.user_del_type  IS '离职成员的处理方式：1-禁用 ，2-删除，当sync_type为2时需要此值'
;
COMMENT ON COLUMN em_cp_user_sync_set.dept_sync_type  IS '部门同步方式：1-同步部门 2-不同步部门且将人员移动到顶级部门下 3-不同步部门且人员部门信息不变，当sync_type为2时需要此值'
;
COMMENT ON COLUMN em_cp_user_sync_set.isalluser  IS '是否同步无账号人员：0-否 ，1-是，当sync_type为2时需要此值'
;
COMMENT ON COLUMN em_cp_user_sync_set.match_user_field  IS '已存在成员本系统的匹配字段：1-账号 ，2-手机号，3-邮箱'
;
COMMENT ON COLUMN em_cp_user_sync_set.match_outsys_field  IS '已存在成员集成系统的匹配字段：1-数据库ID ，2-登录账号，3-手机，4-邮箱，5-工号'
;
COMMENT ON COLUMN em_cp_user_sync_set.outsys_id  IS '集成系统ID'
;
COMMENT ON COLUMN em_cp_user_sync_set.create_user_id  IS '创建人'
;
COMMENT ON COLUMN em_cp_user_sync_set.create_time  IS '创建时间'
;
COMMENT ON COLUMN em_cp_user_sync_set.update_user_id  IS '修改人'
;
COMMENT ON COLUMN em_cp_user_sync_set.update_time  IS '修改时间'
;
COMMENT ON COLUMN em_cp_user_sync_set.tenant_id  IS '企业租户ID'
;

CREATE OR REPLACE INDEX em_cp_user_sync_set_outsys_id_index ON em_cp_user_sync_set(outsys_id)
;