CREATE TABLE em_cp_msg_all (
  id varchar(32) PRIMARY KEY,
  cp_corp_id varchar(32) DEFAULT NULL,
  cp_agent_id varchar(32) DEFAULT NULL,
  relate_agent_id varchar(32) DEFAULT NULL,
  msg_json CLOB DEFAULT NULL,
  msg_data_id varchar(50) DEFAULT NULL,
  msg_data_type tinyint DEFAULT NULL,
  link_url varchar(500) DEFAULT NULL,
  link_url_pc varchar(500) DEFAULT NULL,
  im_msg_id CLOB DEFAULT NULL,
  tousers CLOB DEFAULT NULL,
  sende_time TIMESTAMP DEFAULT NULL,
  status tinyint DEFAULT 1 ,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_msg_all IS '企业号推送消息所有数据表'
;
COMMENT ON COLUMN em_cp_msg_all.id  IS '主键ID'
;
COMMENT ON COLUMN em_cp_msg_all.cp_corp_id  IS '所属企业号ID'
;
COMMENT ON COLUMN em_cp_msg_all.cp_agent_id  IS '所属企业号应用ID'
;
COMMENT ON COLUMN em_cp_msg_all.relate_agent_id  IS '关联的本地消息型应用ID'
;
COMMENT ON COLUMN em_cp_msg_all.msg_json  IS '消息内容'
;
COMMENT ON COLUMN em_cp_msg_all.msg_data_id  IS '消息数据ID'
;
COMMENT ON COLUMN em_cp_msg_all.msg_data_type  IS '消息数据类型'
;
COMMENT ON COLUMN em_cp_msg_all.link_url  IS '链接地址'
;
COMMENT ON COLUMN em_cp_msg_all.link_url_pc  IS 'PC端链接地址'
;
COMMENT ON COLUMN em_cp_msg_all.im_msg_id  IS 'IM返回的消息ID'
;
COMMENT ON COLUMN em_cp_msg_all.tousers  IS '消息接收者'
;
COMMENT ON COLUMN em_cp_msg_all.sende_time  IS '发送时间'
;
COMMENT ON COLUMN em_cp_msg_all.status  IS '状态：1-正常、3-删除'
;
COMMENT ON COLUMN em_cp_msg_all.create_user_id  IS '创建人'
;
COMMENT ON COLUMN em_cp_msg_all.create_time  IS '创建时间'
;
COMMENT ON COLUMN em_cp_msg_all.update_user_id  IS '修改人'
;
COMMENT ON COLUMN em_cp_msg_all.update_time  IS '修改时间'
;
COMMENT ON COLUMN em_cp_msg_all.tenant_id  IS '企业租户ID'
;
CREATE OR REPLACE INDEX em_cp_msg_all_cp_agent_id_index ON em_cp_msg_all(cp_agent_id)
;
CREATE OR REPLACE INDEX em_cp_msg_all_relate_agent_id_index ON em_cp_msg_all(relate_agent_id)
;
CREATE OR REPLACE INDEX em_cp_msg_all_msg_data_id_index ON em_cp_msg_all(msg_data_id)
;
CREATE OR REPLACE INDEX em_cp_msg_all_msg_data_type_index ON em_cp_msg_all(msg_data_type)
;
CREATE OR REPLACE INDEX em_cp_msg_all_sende_time_index ON em_cp_msg_all(sende_time)
;