CREATE TABLE em_agent_msg_log_all (
  id varchar(32) NOT NULL PRIMARY KEY,
  open_agent_id int DEFAULT NULL,
  target_type tinyint DEFAULT 0 ,
  touser text DEFAULT NULL,
  toparty text DEFAULT NULL,
  todept text DEFAULT NULL,
  totag text DEFAULT NULL,
  msgtype varchar(10) DEFAULT NULL,
  safe tinyint DEFAULT 0 ,
  datainfo text DEFAULT NULL,
  requsetinfo text DEFAULT NULL,
  errcode int DEFAULT NULL,
  errmsg varchar(1000) DEFAULT NULL,
  invaliduser text DEFAULT NULL ,
  invalidparty text DEFAULT NULL ,
  invaliddept text DEFAULT NULL ,
  invalidtag text DEFAULT NULL ,
  realityreceivers clob DEFAULT NULL,
  source_msg_id varchar(100) DEFAULT NULL,
  server_msg_id varchar(100) DEFAULT NULL,
  send_type tinyint DEFAULT 0 ,
  send_time TIMESTAMP DEFAULT NULL,
  log_group_id varchar(100) DEFAULT NULL,
  status tinyint DEFAULT 1 ,
  create_user_id varchar(32) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL ,
  tenant_id varchar(32) DEFAULT NULL 
)
;

COMMENT ON TABLE em_agent_msg_log_all IS '企业应用发送消息记录表'
;
COMMENT ON COLUMN em_agent_msg_log_all.id IS '主键ID'
;
COMMENT ON COLUMN em_agent_msg_log_all.open_agent_id IS '企业应用openid'
;
COMMENT ON COLUMN em_agent_msg_log_all.target_type IS '推送目标类型，0-无，1-E-mobile，2-企业号'
;
COMMENT ON COLUMN em_agent_msg_log_all.touser IS '成员ID列表（消息接收者，多个接收者用‘|’分隔，最多支持1000个）。特殊情况：指定为@all，则向该企业应用的全部成员发送'
;
COMMENT ON COLUMN em_agent_msg_log_all.toparty IS '部门ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数'
;
COMMENT ON COLUMN em_agent_msg_log_all.todept IS '部门ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数'
;
COMMENT ON COLUMN em_agent_msg_log_all.totag IS '标签ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数'
;
COMMENT ON COLUMN em_agent_msg_log_all.msgtype IS '消息类型 text-文本，image-图片，voice-语音，video-视频，file-文件，news-图文'
;
COMMENT ON COLUMN em_agent_msg_log_all.safe IS '表示是否是保密消息，0表示否，1表示是，默认0'
;
COMMENT ON COLUMN em_agent_msg_log_all.datainfo IS '发送数据的详细信息，json格式的完整内容'
;
COMMENT ON COLUMN em_agent_msg_log_all.requsetinfo IS '请求数据vo'
;
COMMENT ON COLUMN em_agent_msg_log_all.errcode IS '发送结果状态码'
;
COMMENT ON COLUMN em_agent_msg_log_all.errmsg IS '错误信息'
;
COMMENT ON COLUMN em_agent_msg_log_all.invaliduser IS '无效的成员ID列表'
;
COMMENT ON COLUMN em_agent_msg_log_all.invalidparty IS '无效的部门ID列表'
;
COMMENT ON COLUMN em_agent_msg_log_all.invaliddept IS '无效的部门ID列表'
;
COMMENT ON COLUMN em_agent_msg_log_all.invalidtag IS '无效的标签ID列表'
;
COMMENT ON COLUMN em_agent_msg_log_all.realityreceivers IS '消息发送实际上所有接收人id'
;
COMMENT ON COLUMN em_agent_msg_log_all.source_msg_id IS '消息数据原始ID，接口传入，不传则系统自动生成'
;
COMMENT ON COLUMN em_agent_msg_log_all.server_msg_id IS '消息数据在消息服务端的ID'
;
COMMENT ON COLUMN em_agent_msg_log_all.send_type IS '消息发送类型，1-立即发送，2-定时发送'
;
COMMENT ON COLUMN em_agent_msg_log_all.send_time IS '消息发送时间，如果为定时发送，这里为定时发送时间'
;
COMMENT ON COLUMN em_agent_msg_log_all.log_group_id IS '操作批次id'
;
COMMENT ON COLUMN em_agent_msg_log_all.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_agent_msg_log_all.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_agent_msg_log_all.create_time IS '创建时间'
;
COMMENT ON COLUMN em_agent_msg_log_all.tenant_id IS '企业租户ID'
;
CREATE OR REPLACE INDEX em_agent_msg_log_open_agent_id_index ON em_agent_msg_log(open_agent_id)
;
CREATE OR REPLACE INDEX em_agent_msg_log_source_msg_id_index ON em_agent_msg_log(source_msg_id)
;
CREATE OR REPLACE INDEX em_agent_msg_log_server_msg_id_index ON em_agent_msg_log(server_msg_id)
;
CREATE OR REPLACE INDEX em_agent_msg_log_tenant_id_index ON em_agent_msg_log(tenant_id)
;