
CREATE TABLE em_sys_ca_setting (
  id varchar(32) NOT NULL  PRIMARY KEY ,
  enabled tinyint DEFAULT NULL,
  api_url varchar(200) DEFAULT NULL,
  app_id varchar(100) DEFAULT NULL ,
  auth_key_id varchar(100) DEFAULT NULL ,
  status tinyint DEFAULT 1 ,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL ,
  update_user_id varchar(32) DEFAULT NULL ,
  update_time TIMESTAMP DEFAULT NULL ,
  tenant_id varchar(32) DEFAULT NULL 
)
;
COMMENT ON TABLE em_sys_ca_setting IS 'CA集成设置信息'
;
COMMENT ON COLUMN em_sys_ca_setting.id  IS '主键ID'
;
COMMENT ON COLUMN em_sys_ca_setting.enabled  IS '是否开启CA集成功能：0-禁用、1-开启'
;
COMMENT ON COLUMN em_sys_ca_setting.api_url  IS '接口地址'
;
COMMENT ON COLUMN em_sys_ca_setting.app_id  IS '接入的appId'
;
COMMENT ON COLUMN em_sys_ca_setting.auth_key_id  IS '接入的authKeyID'
;
COMMENT ON COLUMN em_sys_ca_setting.status  IS '状态：1-正常、3-删除'
;
COMMENT ON COLUMN em_sys_ca_setting.create_user_id  IS '创建人'
;
COMMENT ON COLUMN em_sys_ca_setting.create_time  IS '创建时间'
;
COMMENT ON COLUMN em_sys_ca_setting.update_user_id  IS '修改人'
;
COMMENT ON COLUMN em_sys_ca_setting.update_time  IS '修改时间'
;
COMMENT ON COLUMN em_sys_ca_setting.tenant_id  IS '企业租户ID'
;
INSERT INTO em_sys_ca_setting VALUES ('1', 0, null, null, null, 1, '1',  SYSDATE(), null, null, '1')
;
