CREATE TABLE em_sys_baseuser_phrase (
  id varchar(32) NOT NULL PRIMARY KEY,
  base_user_id varchar(32) DEFAULT NULL ,
  phrase_name varchar(100) DEFAULT NULL ,
  phrase_content varchar(200) DEFAULT NULL ,
  phrase_type int DEFAULT NULL ,
  showorder int DEFAULT NULL,
  status tinyint DEFAULT NULL ,
  create_user_id varchar(32) DEFAULT NULL,
  create_time datetime DEFAULT NULL ,
  update_user_id varchar(32) DEFAULT NULL,
  update_time timestamp DEFAULT NULL ,
  tenant_id varchar(32) DEFAULT NULL 
)
;
COMMENT ON TABLE em_sys_baseuser_phrase IS '基础用户常用短语表'
;
COMMENT ON COLUMN em_sys_baseuser_phrase.id  IS '主键ID'
;
COMMENT ON COLUMN em_sys_baseuser_phrase.base_user_id  IS '基础用户ID'
;
COMMENT ON COLUMN em_sys_baseuser_phrase.phrase_name  IS '短语简称'
;
COMMENT ON COLUMN em_sys_baseuser_phrase.phrase_content  IS '短语内容'
;
COMMENT ON COLUMN em_sys_baseuser_phrase.phrase_type  IS '短语类型：1-私人 2-公共'
;
COMMENT ON COLUMN em_sys_baseuser_phrase.showorder  IS '显示顺序'
;
COMMENT ON COLUMN em_sys_baseuser_phrase.status  IS '状态：1-正常、3-删除'
;
COMMENT ON COLUMN em_sys_baseuser_phrase.create_user_id  IS '创建人'
;
COMMENT ON COLUMN em_sys_baseuser_phrase.create_time  IS '创建时间'
;
COMMENT ON COLUMN em_sys_baseuser_phrase.update_user_id  IS '修改人'
;
COMMENT ON COLUMN em_sys_baseuser_phrase.update_time  IS '修改时间'
;
COMMENT ON COLUMN em_sys_baseuser_phrase.tenant_id  IS '企业租户ID'
;
CREATE OR REPLACE INDEX em_sys_baseuser_phrase_base_user_id_index ON em_sys_baseuser_phrase(base_user_id)
;