update em_sys_lang_base set lang_tag='zh' where id = '1'
;
update em_sys_lang_base set status=2 where id = '2' or id = '3'
;
CREATE TABLE em_sys_lang_data (
  id varchar(32) NOT NULL PRIMARY KEY,
  data_tag varchar(50) DEFAULT NULL,
  data_id varchar(32) DEFAULT NULL,
  lang_tag varchar(10) DEFAULT NULL,
  set_value varchar(200) DEFAULT NULL,
  status number(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
CREATE OR REPLACE INDEX data_tag ON em_sys_lang_data(data_tag)
;
CREATE OR REPLACE INDEX data_id ON em_sys_lang_data(data_id)
;
CREATE OR REPLACE INDEX lang_tag ON em_sys_lang_data(lang_tag)
;
COMMENT ON TABLE em_sys_lang_data IS '系统配置数据多语言设置'
;
COMMENT ON COLUMN em_sys_lang_data.data_tag IS '数据标识，规则为：表名:字段名，如em_sc_theme_nav:nav_name'
;
COMMENT ON COLUMN em_sys_lang_data.data_id IS '数据ID，即具体数据的主键ID值'
;
COMMENT ON COLUMN em_sys_lang_data.lang_tag IS '语言标识：zh-汉语(简体)，zh_TW-汉语(繁体)，en-英语，ja-日语，ko-韩语，vi-越南语'
;
COMMENT ON COLUMN em_sys_lang_data.set_value IS '设置项显示内容'
;
COMMENT ON COLUMN em_sys_lang_data.status IS '状态：1-正常、3-删除'
;
COMMENT ON COLUMN em_sys_lang_data.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_lang_data.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_lang_data.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_lang_data.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_lang_data.tenant_id IS '企业租户ID'
;