CREATE TABLE em_sys_sign_setting (
  id varchar(32) NOT NULL PRIMARY KEY,
  enabled number(4,0) DEFAULT NULL,
  ios_sign_type number(4,0) DEFAULT NULL,
  ios_wps_secret varchar(500) DEFAULT NULL,
  ios_office_secret varchar(800) DEFAULT NULL,
  and_sign_type number(4,0) DEFAULT NULL,
  and_wps_secret varchar(500) DEFAULT NULL,
  and_office_secret varchar(800) DEFAULT NULL,
  status number(4,0) DEFAULT 1,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_sign_setting IS '手写签批设置信息'
;
COMMENT ON COLUMN em_sys_sign_setting.enabled IS '是否开启手写签批：0-禁用、1-开启'
;
COMMENT ON COLUMN em_sys_sign_setting.ios_sign_type IS 'IOS签批方式：1-WPS、2-金格office'
;
COMMENT ON COLUMN em_sys_sign_setting.ios_wps_secret IS 'IOS WPS秘钥'
;
COMMENT ON COLUMN em_sys_sign_setting.ios_office_secret IS 'IOS 金格秘钥'
;
COMMENT ON COLUMN em_sys_sign_setting.and_sign_type IS 'Android签批方式：1-WPS、2-金格office、3-永中office'
;
COMMENT ON COLUMN em_sys_sign_setting.and_wps_secret IS 'Android WPS秘钥'
;
COMMENT ON COLUMN em_sys_sign_setting.and_office_secret IS 'Android 金格秘钥'
;
COMMENT ON COLUMN em_sys_sign_setting.status IS '状态'
;
COMMENT ON COLUMN em_sys_sign_setting.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_sign_setting.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_sign_setting.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_sign_setting.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_sign_setting.tenant_id IS '企业租户ID'
;
INSERT INTO em_sys_sign_setting VALUES ('1', 0, 1, '', '', 1, '', '', 1, '1', now(), null, null, '1')
;

CREATE TABLE em_sign_right (
  id varchar(32) NOT NULL PRIMARY KEY,
  client_type number(4,0) DEFAULT NULL,
  hrm_data_id varchar(32) DEFAULT NULL,
  hrm_data_type number(4,0) DEFAULT NULL,
  status number(4,0) DEFAULT 1,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
CREATE OR REPLACE INDEX hrm_data_id ON em_sign_right(hrm_data_id)
;
CREATE OR REPLACE INDEX tenant_id ON em_sign_right(tenant_id)
;
COMMENT ON TABLE em_sign_right IS '手写签批使用权限设置表'
;
COMMENT ON COLUMN em_sign_right.id IS '主键ID'
;
COMMENT ON COLUMN em_sign_right.client_type IS '2-IOS客户端，3-安卓客户端'
;
COMMENT ON COLUMN em_sign_right.hrm_data_id IS '通讯录成员或部门表ID'
;
COMMENT ON COLUMN em_sign_right.hrm_data_type IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;
COMMENT ON COLUMN em_sign_right.status IS '状态：1-正常，3-删除'
;
COMMENT ON COLUMN em_sign_right.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sign_right.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sign_right.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sign_right.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sign_right.tenant_id IS '企业租户ID'
;