CREATE TABLE em_cp_scan_rule (
  id varchar(32) NOT NULL PRIMARY KEY,
  cp_corp_id varchar(32) DEFAULT NULL,
  cp_agent_id varchar(32) DEFAULT NULL,
  status number(4,0) DEFAULT 1,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
CREATE OR REPLACE INDEX cp_agent_id ON em_cp_scan_rule(cp_agent_id)
;
COMMENT ON TABLE em_cp_scan_rule IS '企业号扫码登录EC规则表'
;
COMMENT ON COLUMN em_cp_scan_rule.id IS '主键ID'
;
COMMENT ON COLUMN em_cp_scan_rule.cp_corp_id IS '所属企业号ID'
;
COMMENT ON COLUMN em_cp_scan_rule.cp_agent_id IS '所属企业号应用ID'
;
COMMENT ON COLUMN em_cp_scan_rule.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_cp_scan_rule.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_scan_rule.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_scan_rule.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_cp_scan_rule.update_time IS '修改时间'
;
COMMENT ON COLUMN em_cp_scan_rule.tenant_id IS '企业租户ID'
;