CREATE TABLE em_cp_msg_setlog (
  id varchar(32) NOT NULL PRIMARY KEY,
  tousers clob DEFAULT NULL,
  msg_data_id varchar(50) DEFAULT NULL,
  msg_data_type varchar(20) DEFAULT NULL,
  requestinfo clob,
  resultinfo clob,
  status number(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_msg_setlog IS '企业号消息变更日志表'
;
COMMENT ON COLUMN em_cp_msg_setlog.id IS '主键ID'
;
COMMENT ON COLUMN em_cp_msg_setlog.tousers IS '消息接收者'
;
COMMENT ON COLUMN em_cp_msg_setlog.msg_data_id IS '消息数据ID'
;
COMMENT ON COLUMN em_cp_msg_setlog.msg_data_type IS '消息数据类型'
;
COMMENT ON COLUMN em_cp_msg_setlog.requestinfo IS '消息变更请求内容'
;
COMMENT ON COLUMN em_cp_msg_setlog.resultinfo IS '消息变更结果'
;
COMMENT ON COLUMN em_cp_msg_setlog.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_cp_msg_setlog.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_msg_setlog.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_msg_setlog.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_cp_msg_setlog.update_time IS '修改时间'
;
COMMENT ON COLUMN em_cp_msg_setlog.tenant_id IS '企业租户ID'
;