CREATE TABLE em_sys_face_setting (
  id varchar(32) NOT NULL  PRIMARY KEY,
  enabled number(4,0) DEFAULT NULL,
  api_url varchar(200) DEFAULT NULL ,
  app_id varchar(100) DEFAULT NULL ,
  auth_key_id varchar(100) DEFAULT NULL ,
  right_type number(4,0) ,
  enable_login_verify number(4,0),
  verify_range_type number(4,0),
  status number(4,0) DEFAULT 1 ,
  create_user_id varchar(32) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL ,
  update_user_id varchar(32) DEFAULT NULL ,
  update_time TIMESTAMP DEFAULT NULL ,
  tenant_id varchar(32) DEFAULT NULL
)
;
INSERT INTO em_sys_face_setting VALUES ('1', 0, null, null, null, 1, 0, 1, 1, '1', now(), null, null, '1')
;
COMMENT ON TABLE em_sys_face_setting IS '人脸集成设置信息'
;
COMMENT ON COLUMN em_sys_face_setting.id IS '主键ID'
;
COMMENT ON COLUMN em_sys_face_setting.enabled IS '是否开启人脸集成功能：0-禁用、1-开启'
;
COMMENT ON COLUMN em_sys_face_setting.api_url IS '接口地址'
;
COMMENT ON COLUMN em_sys_face_setting.app_id IS '接入的appId'
;
COMMENT ON COLUMN em_sys_face_setting.auth_key_id IS '接入的authKeyID'
;
COMMENT ON COLUMN em_sys_face_setting.right_type IS '权限类型：1-包含，2-排除'
;
COMMENT ON COLUMN em_sys_face_setting.enable_login_verify IS '是否开启登录验证：1-是，0-否'
;
COMMENT ON COLUMN em_sys_face_setting.verify_range_type IS '登录验证范围类型：1-包含，2-排除'
;
COMMENT ON COLUMN em_sys_face_setting.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_sys_face_setting.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_face_setting.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_face_setting.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_face_setting.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_face_setting.tenant_id IS '企业租户ID'
;

CREATE TABLE em_sys_face_right (
  id varchar(32) NOT NULL  PRIMARY KEY,
  hrm_data_id varchar(32) DEFAULT NULL ,
  hrm_data_type  number(4,0)  DEFAULT NULL ,
  status  number(4,0)  DEFAULT 1 ,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL ,
  update_user_id varchar(32) DEFAULT NULL ,
  update_time TIMESTAMP DEFAULT NULL ,
  tenant_id varchar(32) DEFAULT NULL
)
;
CREATE OR REPLACE INDEX face_right_hrm_id_index ON em_sys_face_right(hrm_data_id)
;
CREATE OR REPLACE INDEX face_right_tenant_id_index ON em_sys_face_right(tenant_id)
;
COMMENT ON TABLE em_sys_face_right IS '人脸使用权限设置表'
;
COMMENT ON COLUMN em_sys_face_right.id IS 'id'
;
COMMENT ON COLUMN em_sys_face_right.hrm_data_id IS '通讯录成员或部门表ID'
;
COMMENT ON COLUMN em_sys_face_right.hrm_data_type IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;
COMMENT ON COLUMN em_sys_face_right.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_sys_face_right.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_face_right.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_face_right.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_face_right.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_face_right.tenant_id IS '企业租户ID'
;


CREATE TABLE em_sys_face_verify_range (
  id varchar(32) NOT NULL  PRIMARY KEY,
  hrm_data_id varchar(32) DEFAULT NULL,
  hrm_data_type number(4,0) DEFAULT NULL ,
  status number(4,0) DEFAULT 1 ,
  create_user_id varchar(32) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL ,
  update_user_id varchar(32) DEFAULT NULL ,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL 
) 
;
CREATE OR REPLACE INDEX  face_verify_range_hrm_id_index ON em_sys_face_verify_range(hrm_data_id)
;
CREATE OR REPLACE INDEX face_verify_range_tenant_id_index ON em_sys_face_verify_range(tenant_id)
;
COMMENT ON TABLE em_sys_face_verify_range IS '人脸登录验证使用范围设置表'
;
COMMENT ON COLUMN em_sys_face_verify_range.id IS 'id'
;
COMMENT ON COLUMN em_sys_face_verify_range.hrm_data_id IS '通讯录成员或部门表ID'
;
COMMENT ON COLUMN em_sys_face_verify_range.hrm_data_type IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;
COMMENT ON COLUMN em_sys_face_verify_range.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_sys_face_verify_range.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_face_verify_range.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_face_verify_range.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_face_verify_range.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_face_verify_range.tenant_id IS '企业租户ID'
;



CREATE TABLE em_face_baseuser_photo  (
  id varchar(32) NOT NULL PRIMARY KEY ,
  base_user_id varchar(32) ,
  photo_id varchar(32) ,
  collect_status number(4,0),
  collect_desc varchar(500) ,
  status number(4,0) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL ,
  create_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL ,
  update_user_id varchar(32) DEFAULT NULL ,
  tenant_id varchar(32) DEFAULT NULL 
) 
;
COMMENT ON TABLE em_face_baseuser_photo IS '用户人脸信息记录表'
;
COMMENT ON COLUMN em_face_baseuser_photo.id IS 'id'
;
COMMENT ON COLUMN em_face_baseuser_photo.base_user_id IS '基础用户ID'
;
COMMENT ON COLUMN em_face_baseuser_photo.photo_id IS '采集照片ID'
;
COMMENT ON COLUMN em_face_baseuser_photo.collect_status IS '采集状态：0-未采集，1-成功，2-失败'
;
COMMENT ON COLUMN em_face_baseuser_photo.collect_desc IS '采集信息描述'
;
COMMENT ON COLUMN em_face_baseuser_photo.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_face_baseuser_photo.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_face_baseuser_photo.create_time IS '创建时间'
;
COMMENT ON COLUMN em_face_baseuser_photo.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_face_baseuser_photo.update_time IS '修改时间'
;
COMMENT ON COLUMN em_face_baseuser_photo.tenant_id IS '企业租户ID'
;