CREATE TABLE em_license_module (
  id varchar(32) NOT NULL PRIMARY KEY,
  identification_number varchar(32) DEFAULT NULL,
  module varchar(32) DEFAULT NULL,
  "count" number(4,0) DEFAULT NULL,
  user_count number(11,0) DEFAULT NULL,
  user_count_type number(4,0) DEFAULT NULL,
  expire_date timestamp DEFAULT NULL,
  license_id varchar(32) DEFAULT NULL,
  status number(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time timestamp DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time timestamp DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
comment on table em_license_module is '服务端License模块信息表'
;
comment on column em_license_module.id is '主键'
;
comment on column em_license_module.identification_number is '识别码'
;
comment on column em_license_module.module is '模块名称'
;
comment on column em_license_module."count" is '集成数量'
;
comment on column em_license_module.user_count is '用户数量'
;
comment on column em_license_module.user_count_type is '用户数类型，1-并发、2-注册，默认并发'
;
comment on column em_license_module.expire_date is '过期时间'
;
comment on column em_license_module.license_id is '关联主license主键'
;
comment on column em_license_module.status is '状态'
;
comment on column em_license_module.create_user_id is '创建人'
;
comment on column em_license_module.create_time is '创建时间'
;
comment on column em_license_module.update_user_id is '最后修改人'
;
comment on column em_license_module.update_time is '最后修改时间'
;
comment on column em_license_module.tenant_id is '租户ID'
;
CREATE OR REPLACE INDEX em_license_module_identification_number_index ON em_license_module(identification_number)
;
CREATE OR REPLACE INDEX em_license_module_module_index ON em_license_module(module)
;
CREATE OR REPLACE INDEX em_license_module_license_id_index ON em_license_module(license_id)
;
insert into em_license_module select sys_guid(),identification_number,'em',1,(case when em_user_count is null then user_count else em_user_count end),(case when em_user_count_type is null then 1 else em_user_count_type end),(case when em_expire_date is null then (case when eternal = 1 then null else expire_date end) else em_expire_date end),id,1,create_user_id,create_time,null,null,tenant_id from em_license where em_count = 1 or em_count = 2
;
insert into em_license_module select sys_guid(),identification_number,'emPC',1,(case when em_pc_user_count is null then user_count else em_pc_user_count end),(case when em_pc_user_count_type is null then 1 else em_pc_user_count_type end),(case when em_pc_expire_date is null then (case when eternal = 1 then null else expire_date end) else em_pc_expire_date end),id,1,create_user_id,create_time,null,null,tenant_id from em_license where em_count = 1 or em_count = 3
;
insert into em_license_module select sys_guid(),identification_number,'cp',1,(case when cp_user_count is null then user_count else cp_user_count end),(case when cp_user_count_type is null then 1 else cp_user_count_type end),(case when cp_expire_date is null then (case when eternal = 1 then null else expire_date end) else cp_expire_date end),id,1,create_user_id,create_time,null,null,tenant_id from em_license where cp_count = 1
;
insert into em_license_module select sys_guid(),identification_number,'mp',1,(case when mp_user_count is null then user_count else mp_user_count end),(case when mp_user_count_type is null then 1 else mp_user_count_type end),(case when mp_expire_date is null then (case when eternal = 1 then null else expire_date end) else mp_expire_date end),id,1,create_user_id,create_time,null,null,tenant_id from em_license where mp_count = 1
;
insert into em_license_module select sys_guid(),identification_number,'dd',1,(case when dd_user_count is null then user_count else dd_user_count end),(case when dd_user_count_type is null then 1 else dd_user_count_type end),(case when dd_expire_date is null then (case when eternal = 1 then null else expire_date end) else dd_expire_date end),id,1,create_user_id,create_time,null,null,tenant_id from em_license where dd_count = 1
;
insert into em_license_module select sys_guid(),identification_number,'lx',1,(case when lx_user_count is null then user_count else lx_user_count end),(case when lx_user_count_type is null then 1 else lx_user_count_type end),(case when lx_expire_date is null then (case when eternal = 1 then null else expire_date end) else lx_expire_date end),id,1,create_user_id,create_time,null,null,tenant_id from em_license where lx_count = 1
;
insert into em_license_module select sys_guid(),identification_number,'gzb',1,(case when gzb_user_count is null then user_count else gzb_user_count end),(case when gzb_user_count_type is null then 1 else gzb_user_count_type end),(case when gzb_expire_date is null then (case when eternal = 1 then null else expire_date end) else gzb_expire_date end),id,1,create_user_id,create_time,null,null,tenant_id from em_license where gzb_count = 1
;
insert into em_license_module select sys_guid(),identification_number,'jdyzj',1,(case when jdyzj_user_count is null then user_count else jdyzj_user_count end),(case when jdyzj_user_count_type is null then 1 else jdyzj_user_count_type end),(case when jdyzj_expire_date is null then (case when eternal = 1 then null else expire_date end) else jdyzj_expire_date end),id,1,create_user_id,create_time,null,null,tenant_id from em_license where jdyzj_count = 1
;
insert into em_license_module select sys_guid(),identification_number,'hfx',1,(case when hfx_user_count is null then user_count else hfx_user_count end),(case when hfx_user_count_type is null then 1 else hfx_user_count_type end),(case when hfx_expire_date is null then (case when eternal = 1 then null else expire_date end) else hfx_expire_date end),id,1,create_user_id,create_time,null,null,tenant_id from em_license where hfx_count = 1
;
insert into em_license_module select sys_guid(),identification_number,'fxxk',1,(case when fxxk_user_count is null then user_count else fxxk_user_count end),(case when fxxk_user_count_type is null then 1 else fxxk_user_count_type end),(case when fxxk_expire_date is null then (case when eternal = 1 then null else expire_date end) else fxxk_expire_date end),id,1,create_user_id,create_time,null,null,tenant_id from em_license where fxxk_count = 1
;