CREATE TABLE em_cp_tag (
  id varchar(32) NOT NULL PRIMARY KEY,
  cp_corp_id varchar(32) DEFAULT NULL,
  open_tag_id varchar(100) DEFAULT NULL,
  tag_name varchar(100) DEFAULT NULL,
  user_amount NUMBER(11, 0) DEFAULT NULL,
  status NUMBER(4, 0) DEFAULT '1',
  create_user_id VARCHAR(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id VARCHAR(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id VARCHAR(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_tag IS '企业号通讯录标签表'
;
COMMENT ON COLUMN em_cp_tag.id IS '主键ID'
;
COMMENT ON COLUMN em_cp_tag.cp_corp_id IS '企业号基本信息ID'
;
COMMENT ON COLUMN em_cp_tag.open_tag_id IS '公众号标签ID'
;
COMMENT ON COLUMN em_cp_tag.tag_name IS '标签名称'
;
COMMENT ON COLUMN em_cp_tag.user_amount IS '标签用户数'
;
COMMENT ON COLUMN em_cp_tag.status IS '状态：1-正常，2-禁用，3-删除'
;
COMMENT ON COLUMN em_cp_tag.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_tag.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_tag.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_cp_tag.update_time IS '修改时间'
;
COMMENT ON COLUMN em_cp_tag.tenant_id IS '企业租户ID'
;

CREATE TABLE em_cp_tag_user (
  id varchar(32) NOT NULL PRIMARY KEY,
  cp_tag_id varchar(32) DEFAULT NULL,
  cp_user_id varchar(32) DEFAULT NULL,
  status NUMBER(4, 0) DEFAULT '1',
  create_user_id VARCHAR(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id VARCHAR(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id VARCHAR(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_tag_user IS '企业号通讯录标签与成员关联表'
;
COMMENT ON COLUMN em_cp_tag_user.id IS '主键ID'
;
COMMENT ON COLUMN em_cp_tag_user.cp_tag_id IS '通讯录标签表ID'
;
COMMENT ON COLUMN em_cp_tag_user.cp_user_id IS '通讯录人员表ID'
;
COMMENT ON COLUMN em_cp_tag_user.status IS '状态：1-正常，2-禁用，3-删除'
;
COMMENT ON COLUMN em_cp_tag_user.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_tag_user.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_tag_user.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_cp_tag_user.update_time IS '修改时间'
;
COMMENT ON COLUMN em_cp_tag_user.tenant_id IS '企业租户ID'
;
