CREATE TABLE em_sys_conc_whitelist (
  id varchar(32) NOT NULL  PRIMARY KEY,
  cp_type number(4,0) NOT NULL ,
  base_user_id varchar(100) NOT NULL,
  status number(4,0) DEFAULT '1' ,
  create_user_id varchar(32) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL  ,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
) 
;
COMMENT ON TABLE em_sys_conc_whitelist IS '并发控制白名单'
;
COMMENT ON COLUMN em_sys_conc_whitelist.id IS '主键ID'
;
COMMENT ON COLUMN em_sys_conc_whitelist.cp_type IS '对应授权模块的类型'
;
COMMENT ON COLUMN em_sys_conc_whitelist.base_user_id IS '白名单人员主键id'
;
COMMENT ON COLUMN em_sys_conc_whitelist.status IS '状态'
;
COMMENT ON COLUMN em_sys_conc_whitelist.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_conc_whitelist.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_conc_whitelist.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_conc_whitelist.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_conc_whitelist.tenant_id IS '企业租户ID'
;
CREATE  INDEX conc_whitelist_user_id_index ON em_sys_conc_whitelist(base_user_id)
;