CREATE TABLE em_cp_pay_config (
  id varchar(32) NOT NULL PRIMARY KEY,
  cp_corp_id varchar(32) DEFAULT NULL,
  mchid varchar(32) DEFAULT NULL,
  apikey varchar(32) DEFAULT NULL,
  certfile varchar(32) DEFAULT NULL,
  certpassword varchar(255) DEFAULT NULL,
  handling_fee_rate number(4, 0) DEFAULT NULL,
  status number(4, 0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;

COMMENT ON TABLE em_cp_pay_config IS '企业号支付配置'
;
COMMENT ON COLUMN em_cp_pay_config.id IS '主键ID'
;
COMMENT ON COLUMN em_cp_pay_config.cp_corp_id IS '企业号基本信息ID'
;
COMMENT ON COLUMN em_cp_pay_config.mchid IS '商户ID'
;
COMMENT ON COLUMN em_cp_pay_config.apikey IS '支付key'
;
COMMENT ON COLUMN em_cp_pay_config.certfile IS '支付证书文件ID'
;
COMMENT ON COLUMN em_cp_pay_config.certpassword IS '支持证书密码'
;
COMMENT ON COLUMN em_cp_pay_config.handling_fee_rate IS '支付手续费：千分比'
;
COMMENT ON COLUMN em_cp_pay_config.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_cp_pay_config.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_pay_config.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_pay_config.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_cp_pay_config.update_time IS '修改时间'
;
COMMENT ON COLUMN em_cp_pay_config.tenant_id IS '企业租户ID'
;
