
CREATE TABLE em_sys_search_setting (
  id varchar(32) NOT NULL PRIMARY KEY,
  enable_search NUMBER(4,0) DEFAULT NULL,
  input_search_type NUMBER(4,0) DEFAULT NULL ,
  input_search_contact NUMBER(4,0) DEFAULT 0 ,
  input_search_group NUMBER(4,0) DEFAULT 0 ,
  detail_search_group NUMBER(4,0) DEFAULT NULL,
  detail_search_msg NUMBER(4,0) DEFAULT NULL ,
  status NUMBER(4,0) DEFAULT 1 ,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT  NULL,
  update_time TIMESTAMP DEFAULT NULL ,
  tenant_id varchar(32) DEFAULT NULL
) 
;
COMMENT ON TABLE em_sys_search_setting is '搜索设置信息'
;
COMMENT ON COLUMN em_sys_search_setting.id IS '主键'
;
COMMENT ON COLUMN em_sys_search_setting.enable_search IS '是否开启搜索功能：0-禁用、1-开启(默认)'
;
COMMENT ON COLUMN em_sys_search_setting.input_search_type IS '搜索框搜索方式：1-默认、2-自定义'
;
COMMENT ON COLUMN em_sys_search_setting.input_search_contact IS '搜索框是否搜索通讯录：0-不搜索、1-搜索，搜索方式为默认时有效'
;
COMMENT ON COLUMN em_sys_search_setting.input_search_group IS '搜索框是否搜索群组：0-不搜索、1-搜索，搜索方式为默认时有效'
;
COMMENT ON COLUMN em_sys_search_setting.detail_search_group IS '是否开启详细搜索群组：0-不开启，1-开启(默认)'
;
COMMENT ON COLUMN em_sys_search_setting.detail_search_msg IS '是否开启详细搜索消息：0-不开启，1-开启(默认)'
;
COMMENT ON COLUMN em_sys_search_setting.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_search_setting.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_search_setting.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_search_setting.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_search_setting.tenant_id IS '企业租户ID'
;
