CREATE TABLE em_cp_process_template (
  id varchar(32) NOT NULL PRIMARY KEY,
  cp_corp_id varchar(32) DEFAULT NULL,
  outsys_id varchar(32) DEFAULT NULL,
  msg_data_id varchar(50) DEFAULT NULL,
  msg_data_type varchar(20) DEFAULT NULL,
  process_instance_id varchar(100) DEFAULT NULL,
  status number(4, 0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;

COMMENT ON TABLE em_cp_process_template IS '企业号待办消息流程实例'
;
COMMENT ON COLUMN em_cp_process_template.id IS '主键ID'
;
COMMENT ON COLUMN em_cp_process_template.cp_corp_id IS '企业号基本信息ID'
;
COMMENT ON COLUMN em_cp_process_template.outsys_id IS '集成系统ID'
;
COMMENT ON COLUMN em_cp_process_template.msg_data_id IS '消息数据ID'
;
COMMENT ON COLUMN em_cp_process_template.msg_data_type IS '消息数据类型'
;
COMMENT ON COLUMN em_cp_process_template.process_instance_id IS '实例ID'
;
COMMENT ON COLUMN em_cp_process_template.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_cp_process_template.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_process_template.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_process_template.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_cp_process_template.update_time IS '修改时间'
;
COMMENT ON COLUMN em_cp_process_template.tenant_id IS '企业租户ID'
;
