CREATE TABLE em_sys_proxy (
  id varchar(32) NOT NULL PRIMARY KEY,
  enabled NUMBER(4,0) DEFAULT NULL,
  proxy_type varchar(255) DEFAULT NULL CHECK (proxy_type IN ('HTTP','SOCKS')),
  host varchar(255) DEFAULT NULL,
  port NUMBER(11,0) DEFAULT NULL,
  username varchar(255) DEFAULT NULL,
  password varchar(255) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_proxy is '系统代理信息'
;
COMMENT ON COLUMN em_sys_proxy.id IS '主键'
;
COMMENT ON COLUMN em_sys_proxy.enabled IS '是否启用：0-否、1-是'
;
COMMENT ON COLUMN em_sys_proxy.proxy_type IS '代理服务协议'
;
COMMENT ON COLUMN em_sys_proxy.host IS '代理服务地址'
;
COMMENT ON COLUMN em_sys_proxy.port IS '代理服务端口'
;
COMMENT ON COLUMN em_sys_proxy.username IS '代理服务账号'
;
COMMENT ON COLUMN em_sys_proxy.password IS '代理服务密码'
;
COMMENT ON COLUMN em_sys_proxy.status IS '状态'
;
COMMENT ON COLUMN em_sys_proxy.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_proxy.create_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_proxy.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_proxy.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_proxy.tenant_id IS '企业租户ID'
;