CREATE TABLE em_msg_group_sharetk (
  id varchar(32) NOT NULL PRIMARY KEY,
  group_id varchar(50) DEFAULT NULL,
  operator varchar(32) DEFAULT NULL,
  sharetk varchar(32) DEFAULT NULL,
  qrcode_file_id varchar(32) DEFAULT NULL,
  group_name varchar(100) DEFAULT NULL,
  group_icon varchar(32) DEFAULT NULL,
  status  NUMBER(4,0) DEFAULT 1 ,
  create_user_id varchar(32) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL ,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL 
)
;
CREATE INDEX em_msg_group_sharetk_id_index ON em_msg_group_sharetk(create_time)
;

COMMENT ON TABLE em_msg_group_sharetk is '消息群组分享标识表'
;
COMMENT ON COLUMN em_msg_group_sharetk.id IS 'ID'
;
COMMENT ON COLUMN em_msg_group_sharetk.group_id IS '群组ID'
;
COMMENT ON COLUMN em_msg_group_sharetk.operator IS '分享者人员ID'
;
COMMENT ON COLUMN em_msg_group_sharetk.sharetk IS '分享标识'
;
COMMENT ON COLUMN em_msg_group_sharetk.qrcode_file_id IS '分享二维码图片ID'
;
COMMENT ON COLUMN em_msg_group_sharetk.group_name IS '群组名称'
;
COMMENT ON COLUMN em_msg_group_sharetk.group_icon IS '群组头像文件ID'
;
COMMENT ON COLUMN em_msg_group_sharetk.status IS '状态'
;
COMMENT ON COLUMN em_msg_group_sharetk.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_msg_group_sharetk.create_time IS '创建时间'
;
COMMENT ON COLUMN em_msg_group_sharetk.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_msg_group_sharetk.update_time IS '修改时间'
;
COMMENT ON COLUMN em_msg_group_sharetk.tenant_id IS '企业租户ID'
;