CREATE TABLE em_video_zhumu_m_attendee (
  id varchar(32) NOT NULL PRIMARY KEY,
  base_user_id varchar(32) DEFAULT NULL ,
  meeting_id varchar(32) DEFAULT NULL,
  status  NUMBER(4,0) DEFAULT 1 ,
  create_user_id varchar(32) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL ,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL 
) 
;
CREATE INDEX em_zhumu_attendee_baseid_index ON em_video_zhumu_m_attendee(base_user_id)
;
CREATE INDEX em_zhumu_attendee_mid_index ON em_video_zhumu_m_attendee(meeting_id)
;

COMMENT ON TABLE em_video_zhumu_m_attendee is '瞩目视频会议参会人员表'
;
COMMENT ON COLUMN em_video_zhumu_m_attendee.id IS 'ID'
;
COMMENT ON COLUMN em_video_zhumu_m_attendee.base_user_id IS '基础用户ID'
;
COMMENT ON COLUMN em_video_zhumu_m_attendee.meeting_id IS '会议主键ID'
;
COMMENT ON COLUMN em_video_zhumu_m_attendee.status IS '状态'
;
COMMENT ON COLUMN em_video_zhumu_m_attendee.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_video_zhumu_m_attendee.create_time IS '修改时间'
;
COMMENT ON COLUMN em_video_zhumu_m_attendee.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_video_zhumu_m_attendee.update_time IS '修改时间'
;
COMMENT ON COLUMN em_video_zhumu_m_attendee.tenant_id IS '企业租户ID'
;